/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.restapi.client.request;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import crazydev.iccube.restapi.client.reply.RestApiClientReply;
import crazydev.iccube.restapi.client.reply.RestApiClientReplyDeserializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.Nullable;

public abstract class RestApiClientRequest<REPLY> {
    public static final String URL_CONSOLE = "/console";
    public static final String URL_ADMIN = "/console/admin";
    public static final String URL_MDX = "/console/mdx";
    public static boolean DUMP_JSON = false;
    @Nullable
    public static String DUMP_JSON_FILE;
    protected final List<NameValuePair> params = new ArrayList<NameValuePair>();

    public abstract String getCommandUrl();

    public abstract Class<REPLY> getReplyClass();

    protected RestApiClientRequest<REPLY> addParam(String name, String value) {
        this.params.add((NameValuePair)new BasicNameValuePair(name, value));
        return this;
    }

    public URIBuilder addParams(URIBuilder uri) {
        uri.addParameters(this.params);
        return uri;
    }

    public String getJsonParams() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (NameValuePair pair : this.params) {
            Object value = map.get(pair.getName());
            if (value == null) {
                map.put(pair.getName(), pair.getValue());
                continue;
            }
            if (value instanceof List) {
                ((List)value).add(pair.getValue());
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add((String)value);
            values.add(pair.getValue());
            map.put(pair.getName(), values);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(map);
    }

    public RestApiClientReply parseResponse(byte[] bytes) {
        String json = new String(bytes, StandardCharsets.UTF_8);
        if (DUMP_JSON) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Object reply = gson.fromJson(json, Map.class);
            String prettyJson = gson.toJson(reply);
            System.out.println();
            System.out.println("JSON");
            System.out.println(prettyJson);
            System.out.println();
        }
        if (DUMP_JSON_FILE != null) {
            try {
                PrintWriter jsonFile = new PrintWriter(DUMP_JSON_FILE);
                jsonFile.write(json);
                jsonFile.flush();
                jsonFile.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not write the file [" + DUMP_JSON_FILE + "]", ex);
            }
        }
        Class<REPLY> clazz = this.getReplyClass();
        Gson gson = new GsonBuilder().registerTypeAdapter(RestApiClientReply.class, (Object)new RestApiClientReplyDeserializer(clazz)).create();
        RestApiClientReply reply = (RestApiClientReply)gson.fromJson(json, RestApiClientReply.class);
        return reply;
    }
}

