/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.restapi.client;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.restapi.client.RestApiClientException;
import crazydev.iccube.restapi.client.reply.RestApiClientReply;
import crazydev.iccube.restapi.client.request.RestApiClientRequest;
import crazydev.iccube.restapi.client.request.RestApiClientRequestKind;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.jetty.util.B64Code;
import org.jetbrains.annotations.Nullable;

public class RestApiClient {
    private final CloseableHttpClient httpClient;
    private final String schema;
    private final String host;
    private final int port;
    private final String path;
    @Nullable
    private final String userName;
    @Nullable
    private final String userPassword;

    public RestApiClient(String schema, String host, int port, String path) {
        this(schema, host, port, path, null, null);
    }

    public RestApiClient(String schema, String host, int port, String path, @Nullable String userName, @Nullable String userPassword) {
        this.schema = schema;
        this.host = host;
        this.port = port;
        this.path = path;
        this.userName = userName;
        this.userPassword = userPassword;
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.httpClient = builder.build();
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    public <R> R sendRequest(RestApiClientRequestKind kind, RestApiClientRequest<R> request) throws RestApiClientException, URISyntaxException, IOException {
        HttpPost uriRequest;
        String path = this.path + request.getCommandUrl();
        URIBuilder uri = new URIBuilder().setScheme(this.schema).setHost(this.host).setPort(this.port).setPath(path);
        if (kind == RestApiClientRequestKind.POST) {
            uriRequest = new HttpPost(uri.build());
            if (CdStringUtils.isNotNullAndNotBlank((String)this.userName)) {
                uriRequest.setHeader("X-AUTHORIZATION", B64Code.encode(this.userName + ":" + this.userPassword, "iso-8859-1"));
            }
            String json = request.getJsonParams();
            uriRequest.setEntity((HttpEntity)new StringEntity(json, ContentType.create((String)"application/json", (String)"UTF-8")));
        } else {
            uriRequest = new HttpGet(request.addParams(uri).build());
            if (CdStringUtils.isNotNullAndNotBlank((String)this.userName)) {
                uriRequest.setHeader("X-AUTHORIZATION", B64Code.encode(this.userName + ":" + this.userPassword, "iso-8859-1"));
            }
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)uriRequest);){
            Object payload;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            InputStream in = response.getEntity().getContent();
            IOUtils.copy((InputStream)in, (OutputStream)content);
            byte[] bytes = content.toByteArray();
            RestApiClientReply reply = request.parseResponse(bytes);
            if (reply.isError()) {
                throw new RestApiClientException(reply.getAsError());
            }
            Object p = payload = reply.getPayload();
            return (R)p;
        }
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

