/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas;

import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtAbstractLoadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtFullReloadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadOfflineSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtOfflineSnapshot;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import org.jetbrains.annotations.Nullable;

public class GwtLoadWithParametersSchemaQuery
extends GwtAbstractLoadSchemaQuery<GwtSchemaLifeCycleReply> {
    private static final long serialVersionUID = 3972761770245345378L;
    private String buttonStyle;
    private String titleTag;
    private String tooltipTag;
    private String schemaName;
    private Mode mode;
    @Nullable
    private GwtOfflineSnapshot offlineSnapshot;
    private boolean unload;

    protected GwtLoadWithParametersSchemaQuery() {
    }

    public GwtLoadWithParametersSchemaQuery(String buttonStyle, String titleTag, String tooltipTag, String schemaName, String factoryShortFileName, String schemaFactoryFileName, Mode mode) {
        super(factoryShortFileName, schemaFactoryFileName);
        this.buttonStyle = buttonStyle;
        this.titleTag = titleTag;
        this.tooltipTag = tooltipTag;
        this.schemaName = schemaName;
        this.mode = mode;
    }

    @Override
    public boolean confirmNeeded() {
        return false;
    }

    @Override
    public String getButtonStyle() {
        return this.buttonStyle;
    }

    @Override
    public String getTitleTag() {
        return this.titleTag;
    }

    @Override
    public String getTooltipTag() {
        return this.tooltipTag;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public String getSchemaOfflineSnapshot() {
        if (this.offlineSnapshot != null) {
            return this.offlineSnapshot.getFullName();
        }
        return null;
    }

    @Nullable
    public GwtOfflineSnapshot getOfflineSnapshot() {
        return this.offlineSnapshot;
    }

    public void setOfflineSnapshot(@Nullable GwtOfflineSnapshot offlineSnapshot) {
        this.offlineSnapshot = offlineSnapshot;
    }

    public boolean isUnload() {
        return this.unload;
    }

    public void setUnload(boolean unload) {
        this.unload = unload;
    }

    public GwtQuery asFullReload() {
        return new GwtFullReloadSchemaQuery(this.getFactoryShortFileName(), this.getSchemaFactoryFileName());
    }

    public GwtQuery asLoad() {
        return new GwtLoadSchemaQuery(this.getFactoryShortFileName(), this.getSchemaFactoryFileName());
    }

    public GwtQuery asOffline(boolean enabled) {
        GwtLoadOfflineSchemaQuery.Mode offlineMode;
        if (this.mode == Mode.WRITING) {
            offlineMode = GwtLoadOfflineSchemaQuery.Mode.WRITING;
        } else if (this.mode == Mode.WRITING_ZIP) {
            offlineMode = GwtLoadOfflineSchemaQuery.Mode.WRITING_ZIP;
        } else if (this.mode == Mode.WRITING_ONLY) {
            offlineMode = GwtLoadOfflineSchemaQuery.Mode.WRITING_ONLY;
        } else if (this.mode == Mode.READING) {
            offlineMode = GwtLoadOfflineSchemaQuery.Mode.READING;
        } else {
            throw new RuntimeException("internal error: unexpected offline load command");
        }
        return new GwtLoadOfflineSchemaQuery(enabled, this.getFactoryShortFileName(), this.getSchemaFactoryFileName(), offlineMode, this.getOfflineSnapshot());
    }

    public static enum Mode {
        RELOAD,
        LOAD,
        WRITING,
        WRITING_ZIP,
        WRITING_ONLY,
        READING;

    }
}

