/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.schemabrowser;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdFilter;
import crazydev.common.collection.CdTreeNode;
import crazydev.common.utils.CdArrayUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorSetupMode;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeModel;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeIdentifier;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreePathTreeNodeIdentifier;
import crazydev.iccube.gwt.base.shared.widget.lazytree.request.GwtLazyTreeNodesQuery;
import crazydev.iccube.gwt.server.lazytree.AbstractLazyTreeCommand;
import crazydev.iccube.gwt.server.lazytree.AbstractLazyTreeVisitor;
import crazydev.iccube.gwt.server.lazytree.LazyTreeChildrenStruct;
import crazydev.iccube.gwt.server.lazytree.LazyTreeVisitor;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.model.GwtSchemaBrowserTreeInfoModel;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.model.GwtSchemaBrowserTreeNodeModel;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilterHelper;
import crazydev.iccube.olap.schema.IOlapSchema;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyTreeSchemaBrowserCommand
extends AbstractLazyTreeCommand<GwtSchemaBrowserTreeNodeModel> {
    protected final OlapEngineRequestContext context;
    protected final OlapRequestId requestId;
    protected final int maxChildrenCount;
    private final Locale schemaLocale;
    private final OlapRolePermissions permissions;
    private final String engineUid;
    private final Iterable<IOlapSchema> allSchemas;
    private final int fromChildPos;
    private final OlapRequestNamesContext requestNamingContext;

    public LazyTreeSchemaBrowserCommand(IcCubeServerRequestContext requestContext, int maxChildrenCount, GwtLazyTreeNodesQuery serverQuery, String engineUid, Iterable<IOlapSchema> allSchemas) {
        this(requestContext, -1, maxChildrenCount, serverQuery, engineUid, allSchemas);
    }

    public LazyTreeSchemaBrowserCommand(IcCubeServerRequestContext requestContext, int fromChildPos, int maxChildrenCount, GwtLazyTreeNodesQuery serverQuery, String engineUid, Iterable<IOlapSchema> allSchemas) {
        super(requestContext.getBabylonService(), serverQuery);
        this.schemaLocale = this.babylon.getLocale();
        this.permissions = requestContext.getCurrentPermissions();
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        this.requestNamingContext = olapEngineRequestContext.getNameContext();
        this.engineUid = engineUid;
        this.allSchemas = allSchemas;
        this.fromChildPos = fromChildPos;
        this.maxChildrenCount = maxChildrenCount;
        this.context = requestContext.getOlapEngineRequestContext();
        this.requestId = requestContext.getRequestId();
    }

    @Override
    protected String getServerTreeUId() {
        return this.engineUid;
    }

    protected Iterable<IOlapSchema> getAllSchemas() {
        return this.allSchemas;
    }

    @Override
    protected void visitTree(LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> treeVisitor) {
        this.visitRoot(treeVisitor);
    }

    @Override
    protected GwtLazyTreeModel onTreeOutOfSync(String clientTreeUId) {
        return new GwtSchemaBrowserTreeInfoModel(clientTreeUId, true);
    }

    @Override
    protected GwtLazyTreeModel newRootTreeRequest() {
        ArrayList<GwtSchemaBrowserTreeNodeModel> models = new ArrayList<GwtSchemaBrowserTreeNodeModel>();
        this.getInitialRoot(models);
        return this.createResponse(this.serverQuery, models, this.getServerTreeUId());
    }

    @Override
    protected GwtLazyTreeModel newRequest(LazyTreeChildrenStruct<GwtSchemaBrowserTreeNodeModel> node) {
        return this.createResponse(this.serverQuery, node.children, this.getServerTreeUId());
    }

    protected List<GwtSchemaBrowserTreeNodeModel> getInitialRoot(List<GwtSchemaBrowserTreeNodeModel> models) {
        ArrayList<IOlapSchema> sortedSchemas = new ArrayList<IOlapSchema>();
        for (IOlapSchema schema : this.getAllSchemas()) {
            sortedSchemas.add(schema);
        }
        sortedSchemas.sort(Comparator.comparing(IOlapSchema::getName));
        for (IOlapSchema schema : sortedSchemas) {
            try {
                GwtSchemaBrowserTreeNodeModel node = this.asTreeNodeForRoot(schema);
                models.add(node);
            }
            catch (OlapRoleAuthorizationRuntimeException olapRoleAuthorizationRuntimeException) {}
        }
        return models;
    }

    protected void visitRoot(LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor) {
        for (IOlapSchema fakeSchema : this.getAllSchemas()) {
            OlapSchema schema = (OlapSchema)fakeSchema;
            GwtSchemaBrowserTreeNodeModel node = this.asTreeNode(schema);
            if (!visitor.acceptNode(null, node, -1)) continue;
            this.visitCube(visitor, node, schema);
        }
    }

    protected void visitCube(LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, GwtSchemaBrowserTreeNodeModel schemaNode, OlapSchema schema) {
        IOlapSchemaPermission schemaAuthorizations = this.getSchemaPermissions(schema);
        ArrayList<OlapCube> accessibleCubes = new ArrayList<OlapCube>(schema.getCubes(schemaAuthorizations));
        accessibleCubes.sort(Comparator.comparing(o -> o.getCaption(this.schemaLocale, (OlapNameContext)this.requestNamingContext)));
        for (OlapCube accessibleCube : accessibleCubes) {
            GwtSchemaBrowserTreeNodeModel cubeMode = this.asTreeNode(accessibleCube);
            IOlapSchemaPermission cubePermissions = this.getSchemaPermissions(accessibleCube);
            if (!visitor.acceptNode(schemaNode, cubeMode, -1)) continue;
            this.visitMeasures(visitor, cubePermissions.getDimensionsPermissions(accessibleCube), cubeMode, schema, accessibleCube);
            if (!accessibleCube.hasPerspective()) continue;
            this.visitDimensions(visitor, schemaAuthorizations.getDimensionsPermissions(accessibleCube), cubeMode, schema, accessibleCube);
        }
        this.visitDimensions(visitor, schemaAuthorizations.getDimensionsPermissions(null), schemaNode, schema, null);
        if (visitor.isEmpty()) {
            visitor.acceptNode(schemaNode, new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.Empty_Schema, "<Empty>"), -1);
        }
    }

    protected void visitMeasures(LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, IOlapDimensionsPermission permissions, GwtSchemaBrowserTreeNodeModel mcube, OlapSchema schema, OlapCube cube) {
        OlapMeasuresDimension measuresDimension;
        OlapNameContext namingContext = permissions.getNamingContext(this.requestNamingContext);
        GwtSchemaBrowserTreeNodeModel mdim = this.asTreeNode(namingContext, schema, permissions, (OlapDimension)(measuresDimension = cube.getMeasuresDimension()));
        if (visitor.acceptNode(mcube, mdim, -1)) {
            OlapMemberFilter memberFilter = permissions.getMemberFilter();
            ArrayList<OlapMeasureMember> measures = new ArrayList<OlapMeasureMember>(measuresDimension.getMeasureMembers(memberFilter));
            measures.sort(Comparator.comparing(meas -> meas.getName(namingContext)));
            List<OlapMember> calcMembers = this.getCubeCalcMembers(cube);
            calcMembers.sort(Comparator.comparing(meas -> meas.getName(namingContext)));
            ArrayList calMeasures = CdCollections.filter(calcMembers, olapCalculatedMember -> olapCalculatedMember.isMeasure() && OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)olapCalculatedMember));
            MeasureTree tree = this.builderFolderTree(namingContext, permissions, mdim, measures, calMeasures);
            if (tree == null) {
                this.doVisitMembers(namingContext, visitor, permissions, mdim, (OlapIterator<? extends OlapMember>)OlapSetFactory.instance(measures).getIterator(false));
                this.doVisitMembers(namingContext, visitor, permissions, mdim, (OlapIterator<? extends OlapMember>)OlapSetFactory.instance((List)calMeasures).getIterator(false));
            } else {
                tree.forEachChild((parent, child, pos) -> visitor.acceptNode((GwtSchemaBrowserTreeNodeModel)parent.getData(), (GwtSchemaBrowserTreeNodeModel)child.getData(), pos, true), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(((GwtSchemaBrowserTreeNodeModel)o1.getData()).getName(), ((GwtSchemaBrowserTreeNodeModel)o2.getData()).getName()));
            }
        }
    }

    private MeasureTree builderFolderTree(OlapNameContext namingContext, IOlapDimensionsPermission permissions, GwtSchemaBrowserTreeNodeModel root, List<OlapMeasureMember> measures, List<OlapMember> calMeasures) {
        Optional<String> any = Stream.of(measures, calMeasures).flatMap(Collection::stream).map(m -> m.getDisplayFolder(this.schemaLocale, (OlapNameContext)this.requestNamingContext)).filter(CdStringUtils::isNotNullAndNotBlank).findAny();
        if (!any.isPresent()) {
            return null;
        }
        MeasureTree measuresRootNode = new MeasureTree(root, null);
        Stream.of(measures, calMeasures).flatMap(Collection::stream).forEach(measure -> {
            GwtSchemaBrowserTreeNodeModel measureNode = this.asTreeNode(namingContext, permissions, (OlapMember)measure);
            if (measureNode != null) {
                String folder = measure.getDisplayFolder(this.schemaLocale, (OlapNameContext)this.requestNamingContext);
                if (folder != null) {
                    String[] paths;
                    for (String path : paths = folder.split(";")) {
                        ArrayList<GwtSchemaBrowserTreeNodeModel> treeFolders = new ArrayList<GwtSchemaBrowserTreeNodeModel>();
                        String[] folders = path.split("\\\\");
                        for (int i = 0; i < folders.length; ++i) {
                            String subFolder = folders[i];
                            if (subFolder.trim().length() <= 0) continue;
                            String subFolderPath = Arrays.stream(folders, 0, i + 1).collect(Collectors.joining("/", "/", ""));
                            treeFolders.add(this.asTreeNode(subFolder, subFolderPath));
                        }
                        measuresRootNode.addPath(treeFolders, 0, measureNode);
                    }
                } else {
                    measuresRootNode.addChild(measureNode);
                }
            }
        });
        return measuresRootNode;
    }

    private List<OlapMember> getCubeCalcMembers(OlapCube cube) {
        OlapSchema schema = cube.getSchema();
        OlapCubeCalculatedMemberManager cubeCalcMemberManager = cube.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = this.context.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(schema, (OlapCalculatedMemberManager)cubeCalcMemberManager);
        List calcMembers = calcMemberManager.getVisibleCalculatedMembers(null);
        return calcMembers;
    }

    protected void visitDimensions(LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, IOlapDimensionsPermission schemaPermission, GwtSchemaBrowserTreeNodeModel parent, OlapSchema schema, @Nullable OlapCube cube) {
        List dimensions = cube == null ? schema.getDimensions(schemaPermission) : cube.getOwnDimensionsWithoutMeasures(schemaPermission);
        OlapNameContext namingContext = schemaPermission.getNamingContext(this.requestNamingContext);
        Comparator comparator = OlapSchema.getNameComparator((Locale)this.context.getBabylonService().getLocale());
        dimensions.stream().sorted((o1, o2) -> comparator.compare(o1.getName(namingContext), o2.getName(namingContext))).forEach(dimension -> {
            GwtSchemaBrowserTreeNodeModel dimModel;
            if (!dimension.isMeasures() && visitor.acceptNode(parent, dimModel = this.asTreeNode(namingContext, schema, schemaPermission, (OlapDimension)dimension), -1)) {
                this.visitDimension(namingContext, visitor, dimModel, schemaPermission, schema, (OlapDimension)dimension);
            }
        });
    }

    protected void visitDimension(OlapNameContext namingContext, LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, GwtSchemaBrowserTreeNodeModel mdim, IOlapDimensionsPermission permissions, OlapSchema schema, OlapDimension dimension) {
        IOlapDimensionPermission dimPermission = permissions.getDimensionPermissions(dimension);
        List hierarchies = dimension.getHierarchies(permissions);
        Comparator comparator = OlapSchema.getNameComparator((Locale)this.schemaLocale);
        hierarchies.sort((o1, o2) -> {
            if (o1.isBase()) {
                return -1;
            }
            if (o2.isBase()) {
                return 1;
            }
            String n1 = o1.getCaption(this.schemaLocale, namingContext) != null ? o1.getCaption(this.schemaLocale, namingContext) : "";
            String n2 = o2.getCaption(this.schemaLocale, namingContext) != null ? o2.getCaption(this.schemaLocale, namingContext) : "";
            return comparator.compare(n1, n2);
        });
        for (OlapHierarchy hierarchy : hierarchies) {
            if (!dimPermission.isHierarchyAuthorized(hierarchy)) continue;
            final OlapLevel rootLevel = hierarchy.getFirstLevel();
            IOlapHierarchyPermission hierarchyPermission = dimPermission.getHierarchyPermission(hierarchy);
            GwtSchemaBrowserTreeNodeModel mhierarchy = this.asTreeNode(namingContext, hierarchyPermission, hierarchy);
            if (!visitor.acceptNode(mdim, mhierarchy, -1) || !hierarchyPermission.isLevelAuthorized(rootLevel)) continue;
            this.visitLevels(namingContext, visitor, permissions.getMemberFilter(), rootLevel, hierarchyPermission, mhierarchy);
            if (rootLevel == null) continue;
            final OlapMemberFilter memberFilter = permissions.getMemberFilter();
            OlapIterator members = rootLevel.getMembers(memberFilter).getIterator(false);
            this.doVisitMembers(namingContext, visitor, permissions, mhierarchy, (OlapIterator<? extends OlapMember>)members);
            List<OlapMember> allCalcMembers = this.getSchemaCalcMembers(schema, memberFilter);
            ArrayList calcMembers = CdCollections.filter(allCalcMembers, (CdFilter)new CdFilter<OlapMember>(){
                {
                    Objects.requireNonNull(this$0);
                }

                public boolean accept(OlapMember calcMember) {
                    return calcMember.getLevel().equals((Object)rootLevel) && !calcMember.isMeasure() && OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)calcMember);
                }
            });
            if (calcMembers == null) continue;
            this.doVisitMembers(namingContext, visitor, permissions, mhierarchy, (OlapIterator<? extends OlapMember>)OlapSetFactory.instance((List)calcMembers).getIterator(false));
        }
    }

    protected void visitLevels(OlapNameContext namingContext, LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, @Nullable OlapMemberFilter memberFilter, OlapLevel rootLevel, IOlapHierarchyPermission hierarchyPermission, GwtSchemaBrowserTreeNodeModel mhierarchy) {
        GwtSchemaBrowserTreeNodeModel mrootlevel = new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.Levels, GwtSchemaBrowserTreeNodeModel.NodeType.Levels.name(), null, true);
        if (visitor.acceptNode(mhierarchy, mrootlevel, -1)) {
            for (OlapLevel level = rootLevel; level != null; level = level.getNextLevel()) {
                GwtSchemaBrowserTreeNodeModel mlevel;
                if (!hierarchyPermission.isLevelAuthorized(level) || !visitor.acceptNode(mrootlevel, mlevel = this.asTreeNode(namingContext, memberFilter, level), -1)) continue;
                this.visitLevel(namingContext, visitor, memberFilter, mlevel, level);
            }
        }
    }

    protected void visitLevel(OlapNameContext namingContext, LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, @Nullable OlapMemberFilter memberFilter, GwtSchemaBrowserTreeNodeModel mlevel, OlapLevel level) {
        for (OlapUserDefinedMemberProperty prop : level.getMemberProperties(memberFilter)) {
            String uniqueName = level.getUniqueName(namingContext) + ".[" + prop.getName() + "]";
            GwtSchemaBrowserTreeNodeModel mprop = new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.Property, prop.getName(), uniqueName, false);
            visitor.acceptNode(mlevel, mprop, -1);
        }
    }

    protected void doVisitMembers(OlapNameContext namingContext, LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, IOlapDimensionsPermission permission, GwtSchemaBrowserTreeNodeModel mmember, OlapIterator<? extends OlapMember> iter) {
        OlapMember child;
        int childPos = 0;
        iter.reset();
        while ((child = (OlapMember)iter.next()) != null) {
            GwtSchemaBrowserTreeNodeModel mchild = this.asTreeNode(namingContext, permission, child);
            if (!visitor.acceptNode(mmember, mchild, ++childPos)) continue;
            this.visitMemberChildren(namingContext, visitor, permission, mchild, child);
        }
    }

    protected void visitMemberChildren(OlapNameContext namingContext, LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, IOlapDimensionsPermission permission, GwtSchemaBrowserTreeNodeModel mmember, final OlapMember member) {
        OlapSchema schema = member.getDimension().getSchema();
        final OlapMemberFilter tupleFilter = permission.getMemberFilter();
        OlapIterator children = member.getChildren(tupleFilter);
        this.doVisitMembers(namingContext, visitor, permission, mmember, (OlapIterator<? extends OlapMember>)children);
        List<OlapMember> allCalcMembers = this.getSchemaCalcMembers(schema, tupleFilter);
        ArrayList calcMembers = CdCollections.filter(allCalcMembers, (CdFilter)new CdFilter<OlapMember>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapMember calcMember) {
                OlapMember calcMemberParent = calcMember.getParent();
                return calcMemberParent != null && calcMemberParent.equals((Object)member) && !calcMember.isMeasure() && OlapMemberFilterHelper.isAccepting((OlapMemberFilter)tupleFilter, (OlapMember)calcMember);
            }
        });
        if (calcMembers != null) {
            this.doVisitMembers(namingContext, visitor, permission, mmember, (OlapIterator<? extends OlapMember>)OlapSetFactory.instance((List)calcMembers).getIterator(false));
        }
    }

    private List<OlapMember> getSchemaCalcMembers(OlapSchema schema, @Nullable OlapMemberFilter tupleFilter) {
        OlapSchemaCalculatedMemberManager schemaCalcMemberManager = schema.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = this.context.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(schema, (OlapCalculatedMemberManager)schemaCalcMemberManager);
        List calcMembers = calcMemberManager.getVisibleCalculatedMembers(tupleFilter);
        return calcMembers;
    }

    protected GwtSchemaBrowserTreeNodeModel asTreeNodeForRoot(IOlapSchema schema) {
        boolean isEmpty = !schema.hasCubes() && !schema.hasDimensions();
        GwtSchemaBrowserTreeNodeModel node = new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.Schema, schema.getName(), null, !isEmpty);
        node.setNodeId(new GwtLazyTreePathTreeNodeIdentifier(schema.getName()));
        return node;
    }

    protected GwtSchemaBrowserTreeNodeModel asTreeNode(OlapSchema schema) {
        IOlapDimensionsPermission perm = this.getSchemaPermissions(schema).getDimensionsPermissions(null);
        boolean isEmpty = this.getAuthorizedCubes(schema).isEmpty() && schema.getDimensions(perm).isEmpty();
        GwtSchemaBrowserTreeNodeModel node = new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.Schema, schema.getName(), null, !isEmpty);
        node.setNodeId(new GwtLazyTreePathTreeNodeIdentifier(schema.getName()));
        return node;
    }

    protected GwtSchemaBrowserTreeNodeModel asTreeNode(OlapCube cube) {
        if (cube instanceof OlapPerspectiveCube) {
            return new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.PerspectiveOnCube, cube.getCaption(this.schemaLocale, (OlapNameContext)this.requestNamingContext), null, true);
        }
        if (cube.hasPerspective()) {
            return new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.CubeWithDefaultPerspective, cube.getCaption(this.schemaLocale, (OlapNameContext)this.requestNamingContext), null, true);
        }
        return new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.Cube, cube.getCaption(this.schemaLocale, (OlapNameContext)this.requestNamingContext), null, true);
    }

    private GwtSchemaBrowserTreeNodeModel asTreeNode(String measureFolder, String path) {
        return new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.MeasureFolder, measureFolder, measureFolder, path, true);
    }

    protected GwtSchemaBrowserTreeNodeModel asTreeNode(OlapNameContext namingContext, OlapSchema schema, IOlapDimensionsPermission permissions, OlapDimension dimension) {
        String caption = dimension.getCaption(this.schemaLocale, namingContext);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("name : ").append(dimension.getName(namingContext)).append("\n");
        tooltip.append("dimensionality index : ").append(dimension.getTupleDimensionalityIndex()).append("\n");
        if (this.permissions.isFullControl()) {
            tooltip.append("member count : ").append(dimension.getMemberCount()).append("\n");
        }
        tooltip.append("in measure groups : ").append(CdCollections.toString((Collection)schema.getLinkingMeasureGroups(dimension), (String)"", (String)", ")).append("\n");
        return new GwtSchemaBrowserTreeNodeModel(dimension.isMeasures() ? GwtSchemaBrowserTreeNodeModel.NodeType.MeasureDimension : GwtSchemaBrowserTreeNodeModel.NodeType.Dimension, caption, dimension.getUniqueName(namingContext), tooltip.toString(), dimension.getHierarchyCount(permissions) > 0);
    }

    protected GwtSchemaBrowserTreeNodeModel asTreeNode(OlapNameContext namingContext, IOlapHierarchyPermission permissions, OlapHierarchy hierarchy) {
        String caption = hierarchy.getCaption(this.schemaLocale, namingContext);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("name : ").append(hierarchy.getName(namingContext)).append("\n");
        if (!hierarchy.isBase() && hierarchy.getDimension().getBaseHierarchy().hasOneRelationWithBase(hierarchy)) {
            tooltip.append("attribute hierarchy").append("\n");
        }
        tooltip.append("dimensionality index : ").append(hierarchy.getTupleDimensionalityIndex()).append("\n");
        if (hierarchy.getFolderName() != null) {
            tooltip.append("folder name : ").append(hierarchy.getFolderName()).append("\n");
        }
        if (this.permissions.isFullControl()) {
            tooltip.append("member count : ").append(hierarchy.getMemberCount()).append("\n");
        }
        return new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.Hierarchy, caption, hierarchy.getUniqueName(namingContext), tooltip.toString(), hierarchy.getLevels(permissions).size() != 0);
    }

    protected GwtSchemaBrowserTreeNodeModel asTreeNode(OlapNameContext namingContext, @Nullable OlapMemberFilter memberFilter, OlapLevel level) {
        Set hierarchies;
        String caption = level.getCaption(this.schemaLocale, namingContext);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("name : ").append(level.getName(namingContext)).append("\n");
        if (this.permissions.isFullControl()) {
            tooltip.append("member count : ").append(level.getMemberCount()).append("\n");
        }
        if (level.isHollow()) {
            tooltip.append("Cloned").append("\n");
        }
        if (level.getHierarchy().isBase() && !(hierarchies = level.getDimension().getHierarchies().stream().filter(hierarchy -> !hierarchy.isBase() && level.hasOneRelationWithBase(hierarchy)).collect(Collectors.toSet())).isEmpty()) {
            String hierList = hierarchies.stream().map(OlapHierarchy::getNameX).collect(Collectors.joining(", "));
            tooltip.append("Attribute Hierarchies : ").append(hierList).append("\n");
        }
        return new GwtSchemaBrowserTreeNodeModel(level.isAll() ? GwtSchemaBrowserTreeNodeModel.NodeType.AllLevel : GwtSchemaBrowserTreeNodeModel.NodeType.Level, caption, level.getUniqueName(namingContext), tooltip.toString(), !level.getMemberProperties(memberFilter).isEmpty());
    }

    protected GwtSchemaBrowserTreeNodeModel asTreeNode(OlapNameContext namingContext, IOlapDimensionsPermission permissions, OlapMember member) {
        GwtSchemaBrowserTreeNodeModel.NodeType nodeType;
        OlapMemberFilter tupleFilter = permissions.getMemberFilter();
        String uniqueName = member.getUniqueName(namingContext);
        boolean keyUC = member.getLevel().isStringKeyUpperCase();
        String caption = member.getCaption(this.schemaLocale, namingContext);
        int childrenCount = member.getXmlaChildrenCardinality(tupleFilter);
        int descCount = member.getXmlaDescendantsCardinality(tupleFilter);
        boolean isUnknown = member.isCreatedUnknownMember();
        if (member instanceof OlapCalculatedMember) {
            nodeType = member.isMeasure() ? GwtSchemaBrowserTreeNodeModel.NodeType.CalcMeasure : GwtSchemaBrowserTreeNodeModel.NodeType.CalcMember;
        } else {
            boolean isDefault = member.isDefault(tupleFilter);
            nodeType = member.isMeasure() ? (isDefault ? GwtSchemaBrowserTreeNodeModel.NodeType.DefaultMeasure : GwtSchemaBrowserTreeNodeModel.NodeType.Measure) : (isDefault ? (member.isAll() ? GwtSchemaBrowserTreeNodeModel.NodeType.AllDefaultMember : GwtSchemaBrowserTreeNodeModel.NodeType.DefaultMember) : (member.isAll() ? GwtSchemaBrowserTreeNodeModel.NodeType.AllMember : GwtSchemaBrowserTreeNodeModel.NodeType.Member));
        }
        String definedNonEmptyBehaviorInfo = null;
        S_NonEmptyBehavior definedNonEmptyBehavior = member.getDefinedNonEmptyBehavior();
        if (definedNonEmptyBehavior != null) {
            definedNonEmptyBehaviorInfo = definedNonEmptyBehavior.asMdxResult().value();
        }
        String computedNonEmptyBehaviorInfo = null;
        OlapProperties props = this.context.getOlapEngineProperties();
        S_NonEmptyBehaviorSetupMode mode = props.getNonEmptyBehaviorSetupMode();
        StringBuilder tooltip = new StringBuilder();
        if (member.getDimension().isMeasures()) {
            String displayFolder;
            tooltip.append("uniqueName : ").append(uniqueName).append("\n");
            if (CdStringUtils.isNotNullAndNotBlank((String)member.getMeasureGroupName())) {
                tooltip.append("measure group : ").append(member.getMeasureGroupName()).append("\n");
            }
            if (member instanceof OlapMeasureMember) {
                OlapMeasureMember measureMember = (OlapMeasureMember)member;
                tooltip.append("data type : ").append(measureMember.getCubeDataType().getShortName()).append("\n");
                tooltip.append("aggregation : ").append(measureMember.getHierarchyAggregationType().getFriendlyName()).append("\n");
                if (measureMember.getRollupHierarchy() != null) {
                    tooltip.append("rollup : ").append(measureMember.getRollupHierarchy().getUniqueName(namingContext)).append("\n");
                }
                tooltip.append("fact rows size : ").append(measureMember.getFactManager().sizeInRows()).append("\n");
                if (measureMember.measureHasNullsInFactColumns()) {
                    tooltip.append("has nulls in facts\n");
                }
            }
            if (CdStringUtils.isNotNullAndNotBlank((String)(displayFolder = member.getDisplayFolder(this.schemaLocale, (OlapNameContext)this.requestNamingContext)))) {
                tooltip.append("folder : ").append(displayFolder).append("\n");
            }
        } else {
            tooltip.append("name : ").append(member.getName(namingContext)).append("\n");
            if (member.getKey() != null) {
                tooltip.append("key : ").append(member.getKey().toString()).append(this.getKeyTypesAsString(member)).append("\n");
            }
            tooltip.append("uniqueName : ").append(uniqueName).append("\n");
            tooltip.append("keyUC : ").append(keyUC).append("\n");
            if (childrenCount > 0) {
                tooltip.append("children count : ").append(childrenCount).append("\n");
            }
            if (descCount > 0) {
                tooltip.append("descendant count : ").append(descCount).append("\n");
            }
        }
        if (isUnknown) {
            tooltip.append("unknown member").append("\n");
        }
        if (OlapMember.equal((OlapMember)member.getDimension().getUnknownMemberForFacts(), (OlapMember)member)) {
            tooltip.append("unknown member for facts").append("\n");
        }
        if (member.isStructuralFactHollow()) {
            tooltip.append("struct. hollow of : ").append(member.getFactIndexingMember().getUniqueName(namingContext)).append("\n");
        } else if (member.isFactHollow()) {
            tooltip.append("hollow of : ").append(member.getFactIndexingMember().getUniqueName(namingContext)).append("\n");
        }
        if (definedNonEmptyBehaviorInfo != null) {
            tooltip.append("non-empty-behavior : (defined) ").append(definedNonEmptyBehaviorInfo).append("\n");
        } else if (computedNonEmptyBehaviorInfo != null) {
            tooltip.append("non-empty-behavior : (calculated wo/ dimensionality) ").append(computedNonEmptyBehaviorInfo).append("\n");
        }
        List memberProperties = member.getLevel().getMemberProperties(permissions.getMemberFilter());
        if (!memberProperties.isEmpty()) {
            tooltip.append("\n");
        }
        for (OlapUserDefinedMemberProperty prop : memberProperties) {
            tooltip.append(prop.getName()).append(" : ").append(member.getPropertyValue(permissions.getMemberFilter(), prop)).append("\n");
        }
        if (member instanceof OlapCalculatedMember) {
            OlapCalculatedMember calcMember = (OlapCalculatedMember)member;
            tooltip.append("formula : ").append(calcMember.getFormula().getMdx()).append("\n");
        }
        return new GwtSchemaBrowserTreeNodeModel(nodeType, caption, uniqueName, tooltip.toString(), childrenCount != 0);
    }

    private String getKeyTypesAsString(OlapMember member) {
        StringBuilder builder = new StringBuilder(" ");
        OlapBuilderInputType[] types = member.getKey().getTypes();
        for (int i = 0; types != null && i < types.length; ++i) {
            OlapBuilderInputType type = types[i];
            builder.append(type.getName()).append(i == 0 ? "" : ",");
        }
        return builder.toString();
    }

    @Override
    public LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> createVisitor(GwtLazyTreeNodeIdentifier lookupNodeId, LazyTreeChildrenStruct<GwtSchemaBrowserTreeNodeModel> lookupRes) {
        return this.buildVisitor(lookupNodeId, lookupRes);
    }

    protected GwtSchemaBrowserTreeInfoModel createResponse(GwtLazyTreeNodesQuery command, List<GwtSchemaBrowserTreeNodeModel> models, String serverTreeUId) {
        return new GwtSchemaBrowserTreeInfoModel(serverTreeUId, command.getClientTreeUId(), (GwtLazyTreeNodeIdentifier)command.getParentNodeId(), models);
    }

    protected LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> buildVisitor(GwtLazyTreeNodeIdentifier lookupNodeId, LazyTreeChildrenStruct<GwtSchemaBrowserTreeNodeModel> lookupRes) {
        return new Visitor(this, lookupNodeId, lookupRes);
    }

    private Collection<OlapCube> getAuthorizedCubes(OlapSchema schema) {
        IOlapSchemaPermission schemaPermission = this.getSchemaPermissions(schema);
        return schema.getCubes(schemaPermission);
    }

    private IOlapSchemaPermission getSchemaPermissions(OlapCube cube) {
        return this.permissions.getSchemasPermissions().getSchemaPermissions(this.context, cube.getSchema(), true);
    }

    private IOlapSchemaPermission getSchemaPermissions(OlapSchema schema) {
        IOlapSchemasPermission schemasPermissions = this.permissions.getSchemasPermissions();
        return schemasPermissions.getSchemaPermissions(this.context, schema, true);
    }

    static class MeasureTree
    extends CdTreeNode<GwtSchemaBrowserTreeNodeModel, MeasureTree> {
        public @Nullable MeasureTree(GwtSchemaBrowserTreeNodeModel data, @Nullable MeasureTree parent) {
            super((Object)data, (CdTreeNode)parent);
        }

        @NotNull
        protected MeasureTree createChildNode(GwtSchemaBrowserTreeNodeModel child) {
            return new MeasureTree(child, this);
        }

        public MeasureTree addPath(List<GwtSchemaBrowserTreeNodeModel> subFolders, int startIdx, GwtSchemaBrowserTreeNodeModel measure) {
            GwtSchemaBrowserTreeNodeModel subFolder = subFolders.get(startIdx);
            MeasureTree papa = (MeasureTree)this.getChild(subFolder);
            if (papa == null) {
                papa = (MeasureTree)this.addChild(subFolder);
            }
            if (subFolders.size() >= startIdx + 2) {
                papa = papa.addPath(subFolders, startIdx + 1, measure);
            }
            papa.addChild(measure);
            return papa;
        }
    }

    protected class Visitor
    extends AbstractLazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> {
        final ArrayList<GwtSchemaBrowserTreeNodeModel> parentPath;
        final IntArrayList childrenCount;
        String schemaName;
        final /* synthetic */ LazyTreeSchemaBrowserCommand this$0;

        public Visitor(LazyTreeSchemaBrowserCommand this$0, GwtLazyTreeNodeIdentifier lookupNodeId, LazyTreeChildrenStruct<GwtSchemaBrowserTreeNodeModel> lookupRes) {
            LazyTreeSchemaBrowserCommand lazyTreeSchemaBrowserCommand = this$0;
            Objects.requireNonNull(lazyTreeSchemaBrowserCommand);
            this.this$0 = lazyTreeSchemaBrowserCommand;
            super(lookupNodeId, lookupRes, this$0.fromChildPos, this$0.maxChildrenCount);
            this.parentPath = new ArrayList();
            this.childrenCount = new IntArrayList();
            this.schemaName = "";
        }

        @Override
        protected int getMaxForChild(GwtSchemaBrowserTreeNodeModel child) {
            if (child.getType() == GwtSchemaBrowserTreeNodeModel.NodeType.Dimension) {
                return 1000;
            }
            return super.getMaxForChild(child);
        }

        @Override
        protected boolean isInBranch(GwtLazyTreeNodeIdentifier lookupNodeId, GwtSchemaBrowserTreeNodeModel parent) {
            if (parent == null || parent.getNodeId() == null) {
                return true;
            }
            return parent.getNodeId().isInBranch((GwtLazyTreePathTreeNodeIdentifier)lookupNodeId);
        }

        @Override
        protected void handlePath(GwtSchemaBrowserTreeNodeModel parent, GwtSchemaBrowserTreeNodeModel child) {
            if (parent == null) {
                this.parentPath.clear();
                return;
            }
            if (parent.getType() == GwtSchemaBrowserTreeNodeModel.NodeType.Schema) {
                this.parentPath.clear();
                this.parentPath.add(child);
                if (this.schemaName.equals(parent.getNodeId().getSchemaName())) {
                    CdCollections.shrinkTo((IntArrayList)this.childrenCount, (int)1);
                    this.incrementValue(0);
                } else {
                    this.resetValue(0);
                    this.schemaName = parent.getNodeId().getSchemaName();
                }
                child.setNodeId(new GwtLazyTreePathTreeNodeIdentifier(this.schemaName, CdArrayUtils.toNativeArray((IntArrayList)this.childrenCount, (int)0, (int)1)));
            } else {
                int idx = this.parentPath.indexOf(parent);
                if (idx < 0) {
                    this.parentPath.clear();
                    this.parentPath.add(parent);
                    this.parentPath.add(child);
                    this.resetValue(this.parentPath.size() - 1);
                } else {
                    CdCollections.shrinkTo(this.parentPath, (int)(idx + 1));
                    CdCollections.shrinkTo((IntArrayList)this.childrenCount, (int)(idx + 2));
                    this.parentPath.add(child);
                    this.incrementValue(this.parentPath.size() - 1);
                }
                int[] pathAsArray = CdArrayUtils.toNativeArray((IntArrayList)this.childrenCount, (int)0, (int)this.parentPath.size());
                child.setNodeId(new GwtLazyTreePathTreeNodeIdentifier(this.schemaName, pathAsArray));
            }
        }

        @Override
        protected GwtSchemaBrowserTreeNodeModel getMoreChildren() {
            String caption = this.this$0.babylon.translate("more", new Serializable[0]);
            return new GwtSchemaBrowserTreeNodeModel(GwtSchemaBrowserTreeNodeModel.NodeType.More, caption);
        }

        private void incrementValue(int index) {
            if (index >= this.childrenCount.size()) {
                this.resetValue(index);
            } else {
                int value = this.childrenCount.getInt(index) + 1;
                this.childrenCount.set(index, value);
            }
        }

        private void resetValue(int index) {
            if (index >= this.childrenCount.size()) {
                this.childrenCount.add(index, 0);
            } else {
                this.childrenCount.set(index, 0);
            }
        }
    }
}

