/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.qeditor;

import crazydev.common.utils.CdLocaleUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractOlapEngineQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.qeditor.command.GwtEvalAlertQuery;
import crazydev.iccube.gwt.shared.portlets.qeditor.command.GwtEvalAlertQueryResult;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.eval.alert.OlapAlertEvalHelper;
import crazydev.iccube.olap.eval.alert.OlapAlertResultStoreReferenceKey;
import crazydev.iccube.olap.eval.alert.OlapAlertResultStoreSerializer;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.facts.cells.IOlapFactsCellEvaluationTask;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellEvaluationTaskFactory;
import crazydev.iccube.olap.eval.select.context.IOlapExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapAlert;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class GwtEvalAlertQueryHandler
extends GwtAbstractOlapEngineQueryHandler<GwtEvalAlertQuery, GwtEvalAlertQueryResult> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<GwtEvalAlertQuery>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, GwtEvalAlertQuery request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
            }
        };
    }

    @Override
    protected GwtEvalAlertQueryResult handleImpl(IcCubeGwtServerRequestContext requestContext, GwtEvalAlertQuery serverRequest) {
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        GwtEvalAlertQueryResult res = this.doHandleImpl(olapEngineRequestContext, serverRequest);
        GwtEvalAlertQueryResult.Kind kind = res.kind();
        String err = res.getError();
        if (GwtEvalAlertQueryResult.Kind.OK == kind) {
            olapEngineRequestContext.onDetailAdded("Alert Result", "" + res.isAlerted());
        } else {
            olapEngineRequestContext.onDetailAdded("Alert Result", kind.name() + (String)(err != null ? " " + err : ""));
        }
        return res;
    }

    private GwtEvalAlertQueryResult doHandleImpl(OlapEngineRequestContext olapEngineRequestContext, GwtEvalAlertQuery serverRequest) {
        OlapEngineRequestContext engineRequestContext;
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        String schemaName = serverRequest.getSchemaName();
        String alertName = serverRequest.getAlertName();
        String alertStatement = serverRequest.getAlertStatement();
        String alertCubeName = serverRequest.getAlertCubeName();
        olapEngineRequestContext.onDetailAdded("Alert Schema", schemaName);
        olapEngineRequestContext.onDetailAdded("Alert Name", alertName);
        OlapSchema schema = olapEngine.getAuthorizedSchema(olapEngineRequestContext, IcCubeSchemaAccessLockMode.READ, schemaName);
        if (schema == null) {
            if (olapEngine.isSchemaDeployed(olapEngineRequestContext.asRuntimeContext(), schemaName)) {
                if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
                    OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] not evaluated as the schema is not loaded"));
                }
                return new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.SCHEMA_NOT_LOADED, false, null);
            }
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] missing schema"));
            return new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.MISSING_SCHEMA, false, null);
        }
        OlapAlert alert = new OlapAlert(alertName, alertStatement, alertCubeName);
        if (alert == null) {
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] missing alert"));
            return new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.MISSING_ALERT, false, null);
        }
        if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation started [schema:" + schemaName + "] [alert:" + alertName + "]"));
        }
        olapEngineRequestContext.onDetailAdded("Alert Create Statement", alert.createStatement());
        String roleName = serverRequest.getRoleName();
        if (roleName != null) {
            if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
                OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation impersonated [schema:" + schemaName + "] [alert:" + alertName + "] [role:" + roleName + "]"));
            }
            String localeName = serverRequest.getLocaleName();
            Locale locale = CdLocaleUtils.fromName((String)localeName);
            engineRequestContext = olapEngineRequestContext.impersonate(roleName, locale);
        } else {
            engineRequestContext = olapEngineRequestContext;
        }
        GwtEvalAlertQueryResult result = this.evalAlert(engineRequestContext, schema, alert);
        return result;
    }

    protected GwtEvalAlertQueryResult evalAlert(OlapEngineRequestContext requestContext, OlapSchema schema, OlapAlert alert) {
        OlapResultCache resultCache = requestContext.getOrCreateResultCacheForAlerts(schema);
        if (resultCache != null) {
            GwtEvalAlertQueryResult result = this.doEvalAlertWithCache(requestContext, resultCache, schema, alert);
            return result;
        }
        GwtEvalAlertQueryResult result = this.doEvalAlert(requestContext, schema, alert);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected GwtEvalAlertQueryResult doEvalAlert(OlapEngineRequestContext requestContext, OlapSchema schema, OlapAlert alert) {
        schemaName = schema.getName();
        alertName = alert.getName();
        try {
            cube = OlapAlertEvalHelper.resolveAlertCube((OlapEngineRequestContext)requestContext, (OlapSchema)schema, (OlapAlert)alert);
        }
        catch (OlapEvaluationException ex) {
            errCode = ex.getErrorCode();
            if (errCode == OlapErrorCode.ALERT_MISSING_CUBE) {
                OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] missing cube : " + ex.getMessage()));
                return new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.MISSING_CUBE, false, ex.getMessage());
            }
            if (errCode == OlapErrorCode.ALERT_CUBE_UNSPECIFIED) {
                OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] cube unspecified : " + ex.getMessage()));
                return new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.MISSING_CUBE, false, ex.getMessage());
            }
            throw ex;
        }
        mdx = alert.createStatement();
        alerted = GwtEvalAlertQueryHandler.evalAlertWithoutMdxExecutors(mdx);
        if (alerted != null) {
            if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
                OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation completed [schema:" + schemaName + "] [alert:" + alertName + "] [alert-mdx:" + mdx + "] [value:" + alerted + "]"));
            }
            return new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.OK, alerted, null);
        }
        alerted = new Boolean[1];
        error = new RuntimeException[1];
        sContext = new OlapMdxStatementWithCubeSelectExecutionContext(requestContext, requestContext.getOlapEngineProperties(), null, null, schema, cube, true);
        permit = sContext.acquireMdxExecutionPermit();
        if (!permit.isCancelled()) {
            try {
                if (OlapLoggers.SCHEDULER.isDebugEnabled()) {
                    OlapLoggers.SCHEDULER.debug((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert MDX evaluation STARTED [schema:" + schemaName + "] [alert:" + alertName + "]"));
                }
                task = (IOlapFactsCellEvaluationTask)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$doEvalAlert$0(java.lang.String java.lang.String java.lang.Boolean[] crazydev.iccube.olap.component.context.OlapEngineRequestContext crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit crazydev.iccube.olap.schema.OlapSchema crazydev.iccube.olap.cube.OlapCube crazydev.iccube.olap.schema.OlapAlert java.lang.RuntimeException[] ), ()V)((String)schemaName, (String)alertName, (Boolean[])alerted, (OlapEngineRequestContext)requestContext, (OlapMdxExecutionPermit)permit, (OlapSchema)schema, (OlapCube)cube, (OlapAlert)alert, (RuntimeException[])error);
                tasks = new OlapFactsCellEvaluationTaskFactory(this, (IOlapExecutionContext)sContext){
                    boolean returned;
                    {
                        Objects.requireNonNull(this$0);
                        super(arg0);
                        this.returned = false;
                    }

                    @Nullable
                    protected IOlapFactsCellEvaluationTask nextTask() {
                        if (this.returned) {
                            return null;
                        }
                        this.returned = true;
                        return task;
                    }
                };
                executors = requestContext.getMdxExecutors();
                executors.executeForCellsProcessing((OlapMdxStatementExecutionContext)sContext, tasks, permit);
                if (!OlapLoggers.SCHEDULER.isDebugEnabled()) ** GOTO lbl42
                OlapLoggers.SCHEDULER.debug((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert MDX evaluation COMPLETED [schema:" + schemaName + "] [alert:" + alertName + "]"));
            }
            finally {
                sContext.releaseMdxExecutionPermit(permit);
            }
        } else {
            alerted[0] = false;
            if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
                OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation CANCELLED [schema:" + schemaName + "] [alert:" + alertName + "] [value:" + alerted[0] + "]"));
            }
        }
lbl42:
        // 5 sources

        if (error[0] != null) {
            throw error[0];
        }
        if (alerted[0] == null) {
            throw new RuntimeException("internal error: missing alert evaluation result");
        }
        if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation completed [schema:" + schemaName + "] [alert:" + alertName + "] [value:" + alerted[0] + "]"));
        }
        return new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.OK, alerted[0], null);
    }

    @Nullable
    private static Boolean evalAlertWithoutMdxExecutors(String mdx) {
        try {
            if (CdStringUtils.isNotNullAndNotBlank((String)mdx) && ((mdx = mdx.trim()).equalsIgnoreCase("true") || mdx.equalsIgnoreCase("2>1"))) {
                return true;
            }
            return null;
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    protected GwtEvalAlertQueryResult doEvalAlertWithCache(OlapEngineRequestContext olapEngineRequestContext, OlapResultCache resultCache, OlapSchema schema, OlapAlert alert) {
        String schemaName = schema.getName();
        String alertName = alert.getName();
        String mdx = alert.createStatement();
        OlapAlertResultStoreReferenceKey resultKey = new OlapAlertResultStoreReferenceKey(mdx);
        OlapResultStoreDeSerializer cachedResult = resultCache.getResult(olapEngineRequestContext, (OlapResultStoreReferenceKey)resultKey);
        if (cachedResult != null) {
            byte[] bytes = cachedResult.bytes();
            boolean alerted = bytes[0] != 0;
            olapEngineRequestContext.onDetailAdded("MDX (cache)", "Got result from cache (" + alerted + ")");
            GwtEvalAlertQueryResult result = new GwtEvalAlertQueryResult(GwtEvalAlertQueryResult.Kind.OK, alerted, null);
            if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
                OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)("[result-cache] MDX result (" + alerted + ") from cache for alert [schema:" + schemaName + "] [alert:" + alertName + "]"));
            }
            if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
                OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation completed [schema:" + schemaName + "] [alert:" + alertName + "] [value:" + alerted + "]"));
            }
            return result;
        }
        GwtEvalAlertQueryResult result = this.doEvalAlert(olapEngineRequestContext, schema, alert);
        if (!result.isOk()) {
            return result;
        }
        boolean alerted = result.isAlerted();
        OlapAlertResultStoreSerializer resultSerializer = new OlapAlertResultStoreSerializer(alerted);
        if (resultCache.addResult(olapEngineRequestContext, (OlapResultStoreReferenceKey)resultKey, (OlapResultStoreSerializer)resultSerializer)) {
            olapEngineRequestContext.onDetailAdded("MDX (cache)", "Result stored into cache (" + alerted + ")");
            if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
                OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)("[result-cache] MDX result (" + alerted + ") stored into cache for alert [schema:" + schemaName + "] [alert:" + alertName + "]"));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$doEvalAlert$0(String schemaName, String alertName, Boolean[] alerted, OlapEngineRequestContext requestContext, OlapMdxExecutionPermit permit, OlapSchema schema, OlapCube cube, OlapAlert alert, RuntimeException[] error) {
        try {
            if (OlapLoggers.SCHEDULER.isDebugEnabled()) {
                OlapLoggers.SCHEDULER.debug((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert MDX (task) evaluation STARTED [schema:" + schemaName + "] [alert:" + alertName + "]"));
            }
            alerted[0] = OlapAlertEvalHelper.eval((OlapEngineRequestContext)requestContext, (OlapMdxExecutionPermit)permit, (OlapSchema)schema, (OlapCube)cube, (OlapAlert)alert);
        }
        catch (RuntimeException ex) {
            error[0] = ex;
        }
        finally {
            if (OlapLoggers.SCHEDULER.isDebugEnabled()) {
                OlapLoggers.SCHEDULER.debug((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert MDX (task) evaluation COMPLETED [schema:" + schemaName + "] [alert:" + alertName + "]"));
            }
        }
    }
}

