/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.users.common;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.iccube.authentication.errors.OlapUserDefinitionError;
import crazydev.iccube.authentication.errors.OlapUserDefinitionErrorCode;
import crazydev.iccube.authentication.errors.OlapUserDefinitionErrorException;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.base.shared.model.validation.GwtValidationResult;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.users.common.GwtUserAbstractQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.exceptions.users.UserExpectedServerException;
import crazydev.iccube.gwt.shared.portlets.monitoring.exceptions.users.UserValidationExpectedServerException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.authentication.IcCubeEmptyAuthenticationService;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.error.IcCubeServerExpectedError;
import crazydev.iccube.server.error.IcCubeServerExpectedErrorCode;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class GwtUserAbstractQueryHandler<REQUEST extends GwtUserAbstractQuery<REPLY>, REPLY extends GwtInfo>
extends GwtAbstractQueryHandler<REQUEST, REPLY> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<REQUEST>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, REQUEST request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
                permissions.assertMonitoringUsersEnabled();
            }
        };
    }

    @Override
    protected final REPLY handleImpl(IcCubeGwtServerRequestContext icCubeServerRequestContext, REQUEST serverRequest) {
        return this.safeHandleImpl(icCubeServerRequestContext, serverRequest);
    }

    private REPLY safeHandleImpl(IcCubeGwtServerRequestContext userRequestContext, REQUEST serverRequest) {
        try {
            return this.unsafeHandleImpl(userRequestContext, serverRequest);
        }
        catch (UserExpectedServerException ex) {
            throw ex;
        }
        catch (OlapUserDefinitionErrorException ex) {
            GwtValidationResult validationErrors = this.setupValidationModel(userRequestContext, Arrays.asList(ex.getError()));
            OlapBabylonService babylon = userRequestContext.getBabylonService();
            IcCubeServerExpectedError error = new IcCubeServerExpectedError(IcCubeServerExpectedErrorCode.ROLE_VALIDATION_ERRORS, new Serializable[0]);
            throw new UserValidationExpectedServerException(ex, validationErrors, error.toString(), error.asMessage((CdBabylonService)babylon));
        }
    }

    private REPLY unsafeHandleImpl(IcCubeGwtServerRequestContext userRequestContext, REQUEST serverRequest) {
        REPLY result = this.doHandleImpl(userRequestContext, serverRequest);
        return result;
    }

    protected abstract REPLY doHandleImpl(IcCubeGwtServerRequestContext var1, REQUEST var2);

    protected List<OlapContextualError> onAuthenticationServiceException(IcCubeGwtServerRequestContext requestContext, OlapAuthenticationServiceException ex) {
        OlapLoggers.AUTHENTICATION.warn((Object)"Authentication Service Setup Error(s)", (Throwable)ex);
        List<OlapContextualError> errors = this.reportAuthenticationServiceErrors(requestContext, OlapUserDefinitionErrorCode.AUTHENTICATION_SERVICE_SETUP_ERROR, (Exception)((Object)ex));
        OlapLoggers.AUTHENTICATION.error((Object)"");
        OlapLoggers.AUTHENTICATION.error((Object)"Authentication Service Setup : due to previous errors/warning some users are possibly not enabled.");
        OlapLoggers.AUTHENTICATION.error((Object)"");
        return errors;
    }

    protected List<OlapContextualError> onAuthenticationServiceFatalException(IcCubeGwtServerRequestContext requestContext, Exception ex) {
        OlapLoggers.AUTHENTICATION.warn((Object)"Authentication Service Setup Fatal Error(s)", (Throwable)ex);
        List<OlapContextualError> errors = this.reportAuthenticationServiceErrors(requestContext, OlapUserDefinitionErrorCode.AUTHENTICATION_SERVICE_SETUP_FATAL_ERROR, ex);
        OlapLoggers.AUTHENTICATION.error((Object)"");
        OlapLoggers.AUTHENTICATION.error((Object)"Authentication Service Setup : fallback to empty (i.e., non authorizing) service - anonymous login is possible if enabled.");
        OlapLoggers.AUTHENTICATION.error((Object)"");
        this.setupFallbackService(requestContext);
        return errors;
    }

    private List<OlapContextualError> reportAuthenticationServiceErrors(IcCubeGwtServerRequestContext requestContext, OlapUserDefinitionErrorCode errorType, Exception ex) {
        ArrayList<OlapContextualError> allErrors = new ArrayList<OlapContextualError>();
        allErrors.add((OlapContextualError)new OlapUserDefinitionError(errorType, new Serializable[0]));
        if (ex instanceof OlapAuthenticationServiceException) {
            Object contextual = (OlapAuthenticationServiceException)((Object)ex);
            List contextualErrors = contextual.getErrors();
            if (!contextualErrors.isEmpty()) {
                for (String contextualError : contextualErrors) {
                    allErrors.add((OlapContextualError)new OlapUserDefinitionError(OlapUserDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{contextualError}));
                }
            } else {
                allErrors.add((OlapContextualError)new OlapUserDefinitionError(OlapUserDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex}));
            }
        } else {
            allErrors.add((OlapContextualError)new OlapUserDefinitionError(OlapUserDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex}));
        }
        for (OlapContextualError error : allErrors) {
            OlapLoggers.AUTHENTICATION.warn((Object)("- " + error.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
        }
        IcCubeRequestStatusManager statusManager = requestContext.getRequestStatusManager();
        statusManager.onRequestErrors(requestContext.getRequestClientUUID(), allErrors);
        return allErrors;
    }

    protected void setupFallbackService(IcCubeGwtServerRequestContext requestContext) {
        IcCubeServerApplicationContext applicationContext = requestContext.getApplicationContext();
        applicationContext.setAuthenticationService((IOlapAuthenticationService)new IcCubeEmptyAuthenticationService());
    }
}

