/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.schemas;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractOlapEngineQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtRestoreSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import crazydev.iccube.olap.component.command.builtin.OlapEngineRestoreSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapRestoreSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.io.File;
import java.util.Objects;

public class GwtRestoreSchemaQueryHandler
extends GwtAbstractOlapEngineQueryHandler<GwtRestoreSchemaQuery, GwtSchemaLifeCycleReply> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<GwtRestoreSchemaQuery>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, GwtRestoreSchemaQuery request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
                permissions.assertMonitoringSchemasEnabled();
                if (!requestContext.isBackupLicensed()) {
                    throw new OlapRoleAuthorizationApplicationException("app.server.backup");
                }
            }
        };
    }

    @Override
    protected GwtSchemaLifeCycleReply handleImpl(IcCubeGwtServerRequestContext icCubeServerRequestContext, GwtRestoreSchemaQuery serverRequest) {
        String schemaName = serverRequest.getSchema();
        if (schemaName == null) {
            throw new RuntimeException("internal error: missing schema name");
        }
        String schemaFactoryFileName = serverRequest.getSchemaFactoryFile();
        if (schemaFactoryFileName == null) {
            throw new RuntimeException("internal error: missing schema [" + schemaName + "] factory definition");
        }
        File schemaFactoryFile = new File(schemaFactoryFileName);
        OlapEngineRestoreSchemaParams params = new OlapEngineRestoreSchemaParams(icCubeServerRequestContext.isInCluster(), "n/a", schemaFactoryFile, schemaName, serverRequest.getTimestamp(), serverRequest.getMode(), false, -1, -1);
        OlapEngineRequestContext requestContext = icCubeServerRequestContext.getOlapEngineRequestContext();
        OlapRestoreSchemaHelper helper = new OlapRestoreSchemaHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.restoreSchema(params);
        return new GwtSchemaLifeCycleReply(schemaName, GwtRestoreSchemaQueryHandler.createUiStatus(status.getLoadStatus()), null);
    }
}

