/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.schemas;

import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtOfflineSnapshot;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public abstract class GwtOfflineSnapshotHelper {
    public static final String DATE_FORMAT = "dd MMM yyyy HH:mm:ss";

    public static GwtOfflineSnapshot generateCaption(SimpleDateFormat df, OlapSnapshotFile offlineSnapshot, @Nullable String schemaName, String schemaFactory, String size, boolean dateOnly) {
        String offlineSnapshotName = offlineSnapshot.getName();
        try {
            long millis = OlapBuilderOfflineHelper.getNameMillis((String)offlineSnapshotName);
            if (millis == -1L) {
                return new GwtOfflineSnapshot(offlineSnapshotName, offlineSnapshotName, GwtOfflineSnapshotHelper.getFixedSchemaName(schemaName, offlineSnapshotName), schemaFactory, size, 0L);
            }
            String captionAsDate = df.format(new Date(millis));
            Object caption = dateOnly ? captionAsDate : GwtOfflineSnapshotHelper.getFixedSchemaName(schemaName, offlineSnapshotName) + " - " + captionAsDate + "  [ " + offlineSnapshotName + " ]";
            return new GwtOfflineSnapshot((String)caption, offlineSnapshotName, GwtOfflineSnapshotHelper.getFixedSchemaName(schemaName, offlineSnapshotName), schemaFactory, size, millis);
        }
        catch (RuntimeException noLuck) {
            return new GwtOfflineSnapshot(offlineSnapshotName, offlineSnapshotName, GwtOfflineSnapshotHelper.getFixedSchemaName(schemaName, offlineSnapshotName), schemaFactory, size, 0L);
        }
    }

    private static String getFixedSchemaName(@Nullable String schemaName, String offlineSnapshotName) {
        return schemaName != null ? schemaName : offlineSnapshotName;
    }
}

