/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.schemas;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.base.shared.model.strings.GwtString;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadSchemaMdxResultCachePostProcessingQuery;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfo;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfoAlert;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfoGvi;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfoXmla;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfos;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.request.processor.cache.IcCubeMdxResultCacheInfoAlert;
import crazydev.iccube.server.request.processor.cache.IcCubeMdxResultCacheInfoGvi;
import crazydev.iccube.server.request.processor.cache.IcCubeMdxResultCacheInfoXmla;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.util.List;
import java.util.Objects;

public class GwtLoadSchemaMdxResultCachePostProcessingQueryHandler
extends GwtAbstractQueryHandler<GwtLoadSchemaMdxResultCachePostProcessingQuery, GwtInfo> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor(this){
            {
                Objects.requireNonNull(this$0);
            }

            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, Object o, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
            }
        };
    }

    @Override
    protected GwtInfo handleImpl(IcCubeGwtServerRequestContext icCubeServerRequestContext, GwtLoadSchemaMdxResultCachePostProcessingQuery serverRequest) {
        if (icCubeServerRequestContext.isCancelling()) {
            return new GwtString("done:nothing", "done:nothing");
        }
        String schemaName = serverRequest.getSchema();
        if (schemaName == null) {
            LOGGER.warn((Object)"Load schema MDX result cache post-processing unexpected missing schema");
            return new GwtString("done:nothing", "done:nothing");
        }
        try {
            GwtLoadSchemaMdxResultCachePostProcessingQueryHandler.buildMdxResultCache(icCubeServerRequestContext, serverRequest);
        }
        catch (RuntimeException ex) {
            LOGGER.warn((Object)("Load schema [" + schemaName + "] MDX result cache post-processing unexpected error"), (Throwable)ex);
        }
        return new GwtString("done", "done");
    }

    public static void buildMdxResultCache(IcCubeGwtServerRequestContext requestContext, GwtLoadSchemaMdxResultCachePostProcessingQuery query) {
        OlapLoggers.BUILDER.info((Object)"[builder] MDX result cache rebuild started");
        OlapMdxResultCacheInfos infos = (OlapMdxResultCacheInfos)query.getInfos();
        if (infos != null && !infos.isEmpty()) {
            IcCubeServerApplicationContext appContext = requestContext.getApplicationContext();
            List requests = infos.getRequests();
            for (OlapMdxResultCacheInfo request : requests) {
                if (requestContext.isCancelling()) break;
                GwtLoadSchemaMdxResultCachePostProcessingQueryHandler.execute(appContext, request);
            }
        }
        OlapLoggers.BUILDER.info((Object)"[builder] MDX result cache rebuild completed");
    }

    private static void execute(IcCubeServerApplicationContext appContext, OlapMdxResultCacheInfo request) {
        if (request instanceof OlapMdxResultCacheInfoGvi) {
            IcCubeMdxResultCacheInfoGvi logic = new IcCubeMdxResultCacheInfoGvi((OlapMdxResultCacheInfoGvi)request);
            logic.execute(appContext);
            return;
        }
        if (request instanceof OlapMdxResultCacheInfoXmla) {
            IcCubeMdxResultCacheInfoXmla logic = new IcCubeMdxResultCacheInfoXmla((OlapMdxResultCacheInfoXmla)request);
            logic.execute(appContext);
            return;
        }
        if (request instanceof OlapMdxResultCacheInfoAlert) {
            IcCubeMdxResultCacheInfoAlert logic = new IcCubeMdxResultCacheInfoAlert((OlapMdxResultCacheInfoAlert)request);
            logic.execute(appContext);
            return;
        }
        throw new RuntimeException("internal error : unexpected request [" + String.valueOf(request.getClass()) + "]");
    }
}

