/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.roles.common;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.gwt.base.shared.model.GwtEmptyInfo;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.monitoring.roles.common.GwtRoleAbstractQueryHandler;
import crazydev.iccube.gwt.server.roles.OlapRoleDefinitionXmlBeanFileRepository;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.roles.common.GwtRoleSetUpApplicationPermissionsQuery;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;

public class GwtRoleSetUpApplicationPermissionsQueryHandler
extends GwtRoleAbstractQueryHandler<GwtRoleSetUpApplicationPermissionsQuery, GwtEmptyInfo> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<GwtRoleSetUpApplicationPermissionsQuery>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, GwtRoleSetUpApplicationPermissionsQuery request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
            }
        };
    }

    @Override
    protected GwtEmptyInfo doHandleImpl(IcCubeGwtServerRequestContext roleRequestContext, GwtRoleSetUpApplicationPermissionsQuery serverRequest) {
        IOlapPermissionsService service;
        Integer version;
        OlapDirectoriesResolved directories = roleRequestContext.asRuntimeContext().getDirectoriesResolved();
        OlapRoleDefinitions roleDefinitions = null;
        try {
            File rolesDirectory = directories.getRolesDirectory();
            if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
                OlapLoggers.AUTHORIZATION.info((Object)("[auth] roles/permissions setup : " + rolesDirectory.getAbsolutePath()));
            }
            OlapRoleDefinitionXmlBeanFileRepository repository = new OlapRoleDefinitionXmlBeanFileRepository(rolesDirectory);
            roleDefinitions = repository.unmarshallExistingRoleDefinitions();
        }
        catch (RuntimeException ex) {
            this.onApplyPermissionsFatalException(roleRequestContext, ex);
        }
        if (roleDefinitions != null && (version = roleDefinitions.getVersion()) == null) {
            try {
                throw new IOException("roles: old format not migrated");
            }
            catch (IOException ex) {
                this.onApplyPermissionsFatalException(roleRequestContext, ex);
                return new GwtEmptyInfo();
            }
        }
        if (roleDefinitions != null) {
            try {
                service = roleRequestContext.getRolePermissionsService();
                service.setupApplicationsPermissionsOnStartup(roleRequestContext.getRequestId(), roleDefinitions);
            }
            catch (OlapContextualBigException ex) {
                this.onApplyPermissionsException(roleRequestContext, ex);
            }
        }
        if (roleDefinitions != null) {
            service = roleRequestContext.getRolePermissionsService();
            service.reportDashboardsPermissionsOnStartup(roleRequestContext.getRequestId());
            service.reportDocsPermissionsOnStartup(roleRequestContext.getRequestId());
        }
        return new GwtEmptyInfo();
    }

    private void onApplyPermissionsFatalException(IcCubeGwtServerRequestContext roleRequestContext, Exception ex) {
        OlapLoggers.AUTHORIZATION.error((Object)"[auth] roles/permissions setup error(s)");
        ArrayList<OlapRoleDefinitionError> errors = new ArrayList<OlapRoleDefinitionError>();
        errors.add(new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.APPLICATIONS_PERMISSIONS_SETUP_FATAL_ERROR, new Serializable[0]));
        OlapLoggers.AUTHORIZATION.error((Object)"[auth] unexpected exception ", (Throwable)ex);
        errors.add(new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()}));
        for (OlapContextualError olapContextualError : errors) {
            OlapLoggers.AUTHORIZATION.error((Object)("- " + olapContextualError.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
        }
        OlapLoggers.AUTHORIZATION.error((Object)"");
        OlapLoggers.AUTHORIZATION.error((Object)"[auth] roles/permissions setup : fallback to administrator role only.");
        OlapLoggers.AUTHORIZATION.error((Object)"");
        IcCubeRequestStatusManager statusManager = roleRequestContext.getRequestStatusManager();
        statusManager.onRequestErrors(roleRequestContext.getRequestClientUUID(), errors);
        IOlapPermissionsService iOlapPermissionsService = roleRequestContext.getRolePermissionsService();
        iOlapPermissionsService.setupOnStartupError();
    }
}

