/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.roles.common;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorException;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.base.shared.model.validation.GwtValidationResult;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.roles.common.GwtRoleAbstractQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.exceptions.roles.RoleExpectedServerException;
import crazydev.iccube.gwt.shared.portlets.monitoring.exceptions.roles.RoleValidationExpectedServerException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.error.IcCubeServerExpectedError;
import crazydev.iccube.server.error.IcCubeServerExpectedErrorCode;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public abstract class GwtRoleAbstractQueryHandler<REQUEST extends GwtRoleAbstractQuery<REPLY>, REPLY extends GwtInfo>
extends GwtAbstractQueryHandler<REQUEST, REPLY> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<REQUEST>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, REQUEST request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
                permissions.assertMonitoringRolesEnabled();
            }
        };
    }

    @Override
    protected final REPLY handleImpl(IcCubeGwtServerRequestContext icCubeServerRequestContext, REQUEST serverRequest) {
        return this.safeHandleImpl(icCubeServerRequestContext, serverRequest);
    }

    private REPLY safeHandleImpl(IcCubeGwtServerRequestContext roleRequestContext, REQUEST serverRequest) {
        try {
            return this.unsafeHandleImpl(roleRequestContext, serverRequest);
        }
        catch (RoleExpectedServerException ex) {
            throw ex;
        }
        catch (OlapRoleDefinitionErrorException ex) {
            GwtValidationResult validationErrors = this.setupValidationModel(roleRequestContext, Arrays.asList(ex.getError()));
            OlapBabylonService babylon = roleRequestContext.getBabylonService();
            IcCubeServerExpectedError error = new IcCubeServerExpectedError(IcCubeServerExpectedErrorCode.ROLE_VALIDATION_ERRORS, new Serializable[0]);
            throw new RoleValidationExpectedServerException(ex, validationErrors, error.toString(), error.asMessage((CdBabylonService)babylon));
        }
    }

    private REPLY unsafeHandleImpl(IcCubeGwtServerRequestContext roleRequestContext, REQUEST serverRequest) {
        REPLY result = this.doHandleImpl(roleRequestContext, serverRequest);
        return result;
    }

    protected abstract REPLY doHandleImpl(IcCubeGwtServerRequestContext var1, REQUEST var2);

    protected void onApplyPermissionsException(IcCubeGwtServerRequestContext roleRequestContext, OlapContextualBigException contextual) {
        OlapLoggers.AUTHORIZATION.error((Object)"[auth] roles/permissions setup error(s)");
        ArrayList<Object> errors = new ArrayList<Object>();
        errors.add(new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.APPLICATIONS_PERMISSIONS_SETUP_ERROR, new Serializable[0]));
        for (OlapContextualError olapContextualError : contextual.getErrors()) {
            errors.add(olapContextualError);
        }
        for (OlapContextualError olapContextualError : errors) {
            OlapLoggers.AUTHORIZATION.error((Object)("- " + olapContextualError.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
        }
        OlapLoggers.AUTHORIZATION.error((Object)"");
        OlapLoggers.AUTHORIZATION.error((Object)"[auth] roles/permissions Setup : several roles might be disabled.");
        OlapLoggers.AUTHORIZATION.error((Object)"");
        IcCubeRequestStatusManager statusManager = roleRequestContext.getRequestStatusManager();
        statusManager.onRequestErrors(roleRequestContext.getRequestClientUUID(), errors);
    }
}

