/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.gizmos;

import crazydev.common.olap.OlapEntityType;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoMeta;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDocsGizmoName {
    public final String type;
    public final String name;
    public final String path;
    @Nullable
    public final String parentPath;
    @Nullable
    public final String lastModified;
    public final long lastModifiedTS;
    @Nullable
    public final OlapDocsPermissions perms;
    @Nullable
    public final OlapDocsGizmoMeta meta;
    @Nullable
    public List<OlapDocsGizmoName> children;

    public OlapDocsGizmoName(String type, String name, @Nullable String parentPath, String path, @Nullable String lastModified, long lastModifiedTS, @Nullable OlapDocsPermissions perms, @Nullable OlapDocsGizmoMeta meta) {
        this.type = type;
        this.name = name;
        this.parentPath = parentPath;
        this.path = path;
        this.lastModified = lastModified;
        this.lastModifiedTS = lastModifiedTS;
        this.perms = perms;
        this.meta = meta;
    }

    public boolean isFolder() {
        return this.type.equals(OlapEntityType.REPORT_FOLDER.getShortName());
    }

    public boolean isFile() {
        return !this.isFolder();
    }

    public boolean isAccepting(String pattern) {
        if (CdStringUtils.isNullOrBlank((String)pattern)) {
            return true;
        }
        return this.name.toLowerCase().contains(pattern.toLowerCase());
    }

    public static List<OlapDocsGizmoName> sort(List<OlapDocsGizmoName> names) {
        names.sort((o1, o2) -> {
            if (o1.isFolder()) {
                if (o2.isFolder()) {
                    return o1.name.compareToIgnoreCase(o2.name);
                }
                return -1;
            }
            if (o2.isFolder()) {
                return 1;
            }
            return o1.name.compareToIgnoreCase(o2.name);
        });
        for (OlapDocsGizmoName name : names) {
            if (name.children == null || name.children.isEmpty()) continue;
            OlapDocsGizmoName.sort(name.children);
        }
        return names;
    }

    public void add(OlapDocsGizmoName name) {
        if (this.children == null) {
            this.children = new ArrayList<OlapDocsGizmoName>();
        }
        this.children.add(name);
    }

    public String toString() {
        return this.type + ":" + this.path;
    }
}

