/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.docs;

import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapClusterConfiguration;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.audit.OlapDocsAuditManager;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingLocation;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsError;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorRuntimeException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntityRepositoryType;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsPermsBypass;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSession;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsErrorHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsZipHelper;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepositorySetupHelper;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapInternalPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.fs.FileRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapDocsActualRepository
extends OlapDocsRepository {
    public static final OlapPath URL_DOCS_ROOT = OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapPathEntry.create((String)"icCube"), OlapPathEntry.create((String)"doc")});
    @Nullable
    private final OlapReportingLocation reportingLocation;
    private final OlapDocsActualRepositorySetupHelper setupNodesHelper;

    public OlapDocsActualRepository(OlapRuntime runtime, OlapDirectoriesResolved directories, File docsLocation) {
        this(runtime, directories, null, null, null, null, docsLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDocsActualRepository(OlapRuntime runtime, OlapDirectoriesResolved directories, @Nullable OlapEngineApplicationContext appContext, @Nullable OlapReportingLocation reportingLocation, @Nullable OlapDocsAuditManager auditManager, @Nullable IcCubeMimeTypesConfiguration mimeTypesConfiguration, File docsLocation, boolean autoInstallWebReporting) {
        super(auditManager, mimeTypesConfiguration, (OlapDocsMimeTypes mimeTypes) -> {
            OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] create docs (file) repository");
            OlapClusterConfiguration cluster = appContext != null ? appContext.getClusterConfiguration() : new OlapClusterConfiguration(false);
            return FileRepository.create(runtime.getVfs(), cluster, mimeTypes, docsLocation, true);
        });
        this.reportingLocation = reportingLocation;
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] repository initial setup");
        this.setupNodesHelper = new OlapDocsActualRepositorySetupHelper(this);
        try {
            OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] repository Web Dashboards setup");
            OlapDocsSession session = this.createStartupSession(directories.getTmpDirectory());
            try {
                this.setupNodesHelper.setupRequiredGlobalAreaNodesMF(session, runtime);
                if (autoInstallWebReporting) {
                    this.autoInstallWebDashboards(session, runtime);
                }
            }
            finally {
                session.logout();
            }
        }
        catch (OlapDocsErrorException ex) {
            throw new OlapDocsErrorRuntimeException("Docs repository Web Dashboards setup error (please consult your system administrator)", (Throwable)((Object)ex));
        }
        catch (RepositoryException ex) {
            OlapDocsError cause = OlapDocsErrorHelper.extractCause(ex);
            if (cause != null) {
                throw new OlapDocsErrorRuntimeException(ex, cause);
            }
            throw new OlapDocsErrorRuntimeException("Docs repository Web Dashboards setup error (please consult your system administrator)", ex);
        }
    }

    @Override
    public OlapDocsEntityRepositoryType getType() {
        return OlapDocsEntityRepositoryType.WEB_DOCS;
    }

    @Override
    public OlapPath getDocUrl() {
        return URL_DOCS_ROOT;
    }

    @Override
    @Nullable
    protected OlapDocsActualRepositorySetupHelper setupNodesHelper() {
        return this.setupNodesHelper;
    }

    public OlapDocsSession createStartupSession(File tmpDirectory) throws OlapDocsErrorException {
        IOlapDocsRequestContext reqContext = this.createStartupRequestContext(tmpDirectory);
        OlapDocsSession session = this.createSession(reqContext, false);
        return session;
    }

    private IOlapDocsRequestContext createStartupRequestContext(final File tmpDirectory) {
        return new IOlapDocsRequestContext(){
            final /* synthetic */ OlapDocsActualRepository this$0;
            {
                OlapDocsActualRepository olapDocsActualRepository = this$0;
                Objects.requireNonNull(olapDocsActualRepository);
                this.this$0 = olapDocsActualRepository;
            }

            @Override
            public boolean isWebDashboardsAutoInstall() {
                return this.this$0.reportingLocation == OlapReportingLocation.DOCS;
            }

            @Override
            public OlapPrincipal getUser() {
                return new OlapInternalPrincipal("icCube", "administrator", Locale.ENGLISH);
            }

            @Override
            public boolean isAdministrator() {
                return true;
            }

            @Override
            public boolean isDocAdministrator() {
                return true;
            }

            @Override
            public boolean isAppCreator() {
                return true;
            }

            @Override
            public File getTmpDirectory() {
                return tmpDirectory;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoInstallWebDashboards(OlapDocsSession session, OlapRuntime runtime) {
        Class<OlapDocsRepository> clazz = OlapDocsRepository.class;
        synchronized (OlapDocsRepository.class) {
            if (this.shutdown.get()) {
                OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] Web Dashboards auto-install shutdown");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            try {
                this.setupNodesHelper.autoInstallWebDashboards(session, runtime.getWebDashboardsKit());
            }
            catch (OlapDocsErrorException ex) {
                throw new OlapDocsErrorRuntimeException("[docs] Web Dashboards auto-install error", (Throwable)((Object)ex));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreWebDashboards(IOlapDocsRequestContext repReqCtxt, String timestamp) throws OlapDocsErrorException {
        if (!repReqCtxt.isDocAdministrator()) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_NOT_AUTH, new Serializable[0]);
        }
        OlapDocsSession session = this.createSession(repReqCtxt, false);
        try {
            this.setupNodesHelper.installWebDashboardsFromBackup(this, session, timestamp);
        }
        finally {
            session.logout();
        }
    }

    public void deleteAllWebDashboardsBackups(IOlapDocsRequestContext repReqCtxt) throws OlapDocsErrorException {
        if (!repReqCtxt.isDocAdministrator()) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_NOT_AUTH, new Serializable[0]);
        }
        OlapDocsSession session = this.createSession(repReqCtxt, false);
        try {
            Node backups = session.getNodeRootReportAppBackups(false);
            try (NodeIterator children = backups.getNodes();){
                while (children.hasNext()) {
                    Object child = children.nextNode();
                    session.removeItem(((Node)child).getPath());
                    session.commit();
                }
            }
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
        catch (IOException ex) {
            throw new OlapDocsErrorException(ex);
        }
        finally {
            session.logout();
        }
    }

    public void deleteWebDashboards(IOlapDocsRequestContext repReqCtxt, boolean active, @Nullable String timestamp) throws OlapDocsErrorException {
        if (!repReqCtxt.isDocAdministrator()) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_NOT_AUTH, new Serializable[0]);
        }
        OlapDocsSession session = this.createSession(repReqCtxt, false);
        try {
            Node reportingNode;
            if (active) {
                reportingNode = session.getNodeRootReportApp(false);
            } else {
                Node backups = session.getNodeRootReportAppBackups(false);
                reportingNode = timestamp != null ? backups.getNode(OlapPathEntry.create((String)timestamp)) : null;
            }
            if (reportingNode != null) {
                session.removeItem(reportingNode.getPath());
                session.commit();
            }
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installWebDashboards(IOlapDocsRequestContext repReqCtxt, String file, InputStream in, boolean backup) throws OlapDocsErrorException, IOException {
        if (!repReqCtxt.isDocAdministrator()) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_NOT_AUTH, new Serializable[0]);
        }
        OlapDocsSession session = this.createSession(repReqCtxt, false);
        File tmpDirectory = repReqCtxt.getTmpDirectory();
        File uploadedFile = OlapDocsZipHelper.uploadZipToTmp(session, tmpDirectory, in);
        try {
            this.setupNodesHelper.installWebDashboards(session, file, uploadedFile, backup);
        }
        finally {
            CdVFileSystemUtils.deleteQuietly((File)uploadedFile);
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installWebDashboardsFromKit(IOlapDocsRequestContext repReqCtxt, File kit) throws OlapDocsErrorException {
        if (!repReqCtxt.isDocAdministrator()) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_NOT_AUTH, new Serializable[0]);
        }
        OlapDocsSession session = this.createSession(repReqCtxt, false);
        try {
            this.setupNodesHelper.installWebDashboardsFromKit(session, kit);
        }
        finally {
            session.logout();
        }
    }

    @Override
    @Nullable
    public OlapDocsPermissions getLabelNodePermissions(OlapDocsSessionR session, Node node, @Nullable OlapDocsPermsBypass reportApp) throws OlapDocsErrorException {
        OlapDocsPermissions perms = OlapDocsActualRepository.doGetLabelNodePermissions(session, node);
        if (perms == null && reportApp != null) {
            if (reportApp == OlapDocsPermsBypass.READ) {
                perms = OlapDocsPermissions.READ;
            } else if (reportApp == OlapDocsPermsBypass.WRITE) {
                perms = OlapDocsPermissions.WRITE;
            }
        }
        return perms;
    }

    @Nullable
    private static OlapDocsPermissions doGetLabelNodePermissions(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        IOlapDocsRequestContext requestContext = session.requestContext();
        if (requestContext.isDocAdministrator()) {
            return OlapDocsPermissions.WRITE;
        }
        OlapPrincipal user = requestContext.getUser();
        try {
            String owner = node.getOwner(session.getUsers());
            if (CdStringUtils.isNotNullAndNotBlank((String)owner) && owner.equals(user.getName())) {
                return OlapDocsPermissions.WRITE;
            }
            OlapDocsPermissions permissions = session.getPermissions(node.getPath());
            return permissions;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    @Override
    @Nullable
    public OlapDocsPermissions getDocNodePermissions(OlapDocsSessionR session, Node node, @Nullable OlapDocsPermsBypass reportApp) throws OlapDocsErrorException {
        OlapDocsPermissions perms = OlapDocsActualRepository.doGetDocNodePermissions(session, node);
        if (perms == null && reportApp != null) {
            if (reportApp == OlapDocsPermsBypass.READ) {
                perms = OlapDocsPermissions.READ;
            } else if (reportApp == OlapDocsPermsBypass.WRITE) {
                perms = OlapDocsPermissions.WRITE;
            }
        }
        return perms;
    }

    @Nullable
    private static OlapDocsPermissions doGetDocNodePermissions(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        IOlapDocsRequestContext requestContext = session.requestContext();
        if (requestContext.isDocAdministrator()) {
            return OlapDocsPermissions.WRITE;
        }
        OlapPrincipal user = requestContext.getUser();
        try {
            String owner = node.getOwner(session.getUsers());
            if (CdStringUtils.isNotNullAndNotBlank((String)owner) && owner.equals(user.getName())) {
                return OlapDocsPermissions.WRITE;
            }
            List<OlapDocsSharing> sharings = OlapDocsHelper.unmarshallSharings(node);
            OlapDocsSharing everybodySharing = null;
            for (OlapDocsSharing sharing : sharings) {
                boolean isEverybody = OlapDocsHelper.isSharingEverybody(sharing);
                if (isEverybody) {
                    everybodySharing = sharing;
                    continue;
                }
                if (!user.getRoleNameForDocs().equals(sharing.getRoleName())) continue;
                return sharing.getPermissions();
            }
            if (everybodySharing != null) {
                return everybodySharing.getPermissions();
            }
            if (node.isApplyInheritedPermissions()) {
                return OlapDocsLabelHelper.getLabelNodePermissions(session, node.getParent());
            }
            return null;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }
}

