/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.common;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.component.template.OlapReportHtmlInfo;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDocFile;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntity;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.gwt.server.reporting.repository.reporting.OlapDocsReportHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntimeDashboardsVersion;
import crazydev.iccube.server.repository.Node;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDocsWebReportingHelper {
    private final OlapDocsRepository docs;

    public OlapDocsWebReportingHelper(OlapDocsRepository docs) {
        this.docs = docs;
    }

    @Nullable
    public static OlapReportHtmlInfo isReportPathInfo(String servletPath, @Nullable String pathInfo) {
        if (pathInfo == null || CdStringUtils.isNullOrBlank((String)pathInfo)) {
            return null;
        }
        if (servletPath.equals("/icCube/report") && (pathInfo.equals("/console") || pathInfo.equals("/editor") || pathInfo.equals("/viewer") || pathInfo.equals("/admin") || pathInfo.equals("/appEditor") || pathInfo.equals("/gadgetEditor") || pathInfo.equals("/mdxConsole") || pathInfo.equals("/help"))) {
            return new OlapReportHtmlInfo(true, false, pathInfo.equals("/help"));
        }
        return null;
    }

    private static String getReportHtmlTemplateUrlMF(boolean help) {
        return OlapDocsWebReportingHelper.getReportHtmlTemplateParentUrlMF(help);
    }

    private static String getReportHtmlTemplateParentUrlMF(boolean help) {
        if (help) {
            return "/" + String.valueOf(OlapDocsRepository.NODE_IC3_REPORT_NAME_MF) + "/" + String.valueOf(OlapDocsRepository.NODE_IC3_REPORT_HELP_NAME);
        }
        return "/" + String.valueOf(OlapDocsRepository.NODE_IC3_REPORT_NAME_MF) + "/" + String.valueOf(OlapDocsRepository.NODE_IC3_REPORT_APP_NAME);
    }

    public static String asPathFromReportRootData(OlapDocsSessionR session, OlapPath pathUUID) throws OlapDocsErrorException {
        try {
            Node node = session.getNodeRootReportData();
            OlapPath pathR = node.getPath();
            OlapPath pathFromRoot = pathUUID.relativeTo(pathR);
            String pathS = pathFromRoot.toSimplePath();
            if (pathS.endsWith(OlapDocsReportHelper.REPORT_EXTENSION.getName())) {
                pathS = pathS.substring(0, pathS.length() - OlapDocsReportHelper.REPORT_EXTENSION.length());
            }
            return pathS;
        }
        catch (RuntimeException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    @Nullable
    public OlapRuntimeDashboardsVersion getDashboardsVersion(OlapDocsSessionR session) {
        OlapRuntimeDashboardsVersion version = null;
        try {
            String url = OlapDocsWebReportingHelper.getReportHtmlTemplateParentUrlMF(false) + "/index.html";
            OlapDocsEntity entity = this.docs.retrieveEntityByUrl(session, url);
            if (entity instanceof OlapDocsDoc) {
                version = this.getDashboardVersion((OlapDocsDoc)entity);
            }
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] could not retrieve the Web Dashboards version", (Throwable)((Object)ex));
        }
        return version;
    }

    @Nullable
    public OlapRuntimeDashboardsVersion getDashboardVersion(OlapDocsDoc entity) throws OlapDocsErrorException {
        OlapDocsDoc doc = entity;
        OlapDocsDocFile file = doc.getDocFile();
        List<String> lines = file.getContentAsLines();
        OlapRuntimeDashboardsVersion version = OlapRuntimeDashboardsVersion.parse(lines);
        return version;
    }

    @Nullable
    public List<String> getReportHtmlTemplateMF(OlapDocsSessionR session, boolean dev, boolean help) throws OlapDocsErrorException {
        OlapDocsEntity entity;
        String path = this.getTemplatePathMF(help);
        String url = path + "index.html";
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] report index.html [" + url + "]"));
        }
        if ((entity = this.docs.retrieveEntityByUrl(session, url)) instanceof OlapDocsDoc) {
            OlapDocsDoc doc = (OlapDocsDoc)entity;
            OlapDocsDocFile file = doc.getDocFile();
            file.performRequireTenantCacheBusting(doc);
            List<String> lines = file.getContentAsLines();
            return lines;
        }
        return null;
    }

    private String getTemplatePathMF(boolean help) {
        Object path = OlapDocsWebReportingHelper.getReportHtmlTemplateUrlMF(help);
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }
}

