/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.common;

import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabel;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabelPath;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDocsLabelTree {
    private final List<OlapDocsLabelTreeNode> roots;

    public OlapDocsLabelTree() {
        this(new ArrayList<OlapDocsLabelTreeNode>());
    }

    public OlapDocsLabelTree(List<OlapDocsLabelTreeNode> roots) {
        this.roots = roots;
    }

    public boolean isEmpty() {
        return this.roots.isEmpty();
    }

    public List<OlapDocsLabelTreeNode> getRoots() {
        return this.roots;
    }

    public OlapDocsLabelTreeNode addNode(@Nullable OlapDocsLabelTreeNode parentNode, OlapDocsLabel value) {
        if (parentNode == null) {
            return this.addRoot(new OlapDocsLabelTreeNode(null, value));
        }
        return parentNode.addChild(new OlapDocsLabelTreeNode(parentNode, value));
    }

    private OlapDocsLabelTreeNode addRoot(OlapDocsLabelTreeNode root) {
        this.roots.add(root);
        return root;
    }

    public boolean remove(OlapDocsLabelTreeNode node) {
        OlapDocsLabelTreeNode parentNode = node.getParent();
        if (parentNode == null) {
            return this.roots.remove(node);
        }
        return parentNode.removeChild(node);
    }

    @Nullable
    public OlapDocsLabelTreeNode getNode(@Nullable OlapDocsLabelPath labelPath) {
        List<OlapDocsLabelTreeNode> nodes = this.getNodes(labelPath);
        return nodes.isEmpty() ? null : nodes.get(nodes.size() - 1);
    }

    public List<OlapDocsLabelTreeNode> getNodes(@Nullable OlapDocsLabelPath labelPath) {
        ArrayList<OlapDocsLabelTreeNode> nodes = new ArrayList<OlapDocsLabelTreeNode>();
        if (labelPath == null || labelPath.size() == 0) {
            return nodes;
        }
        OlapDocsLabelPath.Entry entry = labelPath.getEntry(0);
        for (OlapDocsLabelTreeNode root : this.roots) {
            OlapDocsLabel label = root.getLabel();
            if (!label.getUuid().equals(entry.getUuid())) continue;
            nodes.add(root);
            if (labelPath.size() == 1) {
                return nodes;
            }
            return this.getNodes(nodes, labelPath, 1, root);
        }
        nodes.clear();
        return nodes;
    }

    private List<OlapDocsLabelTreeNode> getNodes(List<OlapDocsLabelTreeNode> nodes, OlapDocsLabelPath path, int pos, OlapDocsLabelTreeNode node) {
        OlapDocsLabelPath.Entry entry = path.getEntry(pos);
        for (OlapDocsLabelTreeNode child : node.getChildren()) {
            OlapDocsLabel label = child.getLabel();
            if (!label.getUuid().equals(entry.getUuid())) continue;
            nodes.add(child);
            if (path.size() == pos + 1) {
                return nodes;
            }
            return this.getNodes(nodes, path, pos + 1, child);
        }
        nodes.clear();
        return nodes;
    }

    public List<OlapDocsLabel> getLabels() {
        ArrayList<OlapDocsLabel> nodes = new ArrayList<OlapDocsLabel>();
        for (OlapDocsLabelTreeNode root : this.roots) {
            this.getLabels(nodes, root);
        }
        return nodes;
    }

    private void getLabels(List<OlapDocsLabel> nodes, OlapDocsLabelTreeNode node) {
        nodes.add(node.getLabel());
        for (OlapDocsLabelTreeNode child : node.getChildren()) {
            this.getLabels(nodes, child);
        }
    }
}

