/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.common;

import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.RepositoryException;
import java.util.List;

public abstract class OlapDocsHelper {
    private OlapDocsHelper() {
    }

    public static OlapPath relativePathToRoot(OlapDocsSessionR session, Node node) throws RepositoryException, OlapDocsErrorException {
        OlapPath nodePath = node.getPath();
        Node rootNode = session.getNodeRoot(false);
        OlapPath rootNodePath = rootNode.getPath();
        OlapPath relPath = nodePath.relativeTo(rootNodePath);
        return relPath;
    }

    public static boolean isStrictlyChildOf(Node target, Node node) throws OlapDocsErrorException {
        if (target.equals(node)) {
            return false;
        }
        return OlapDocsHelper.isChildOf(target, node);
    }

    public static boolean isChildOf(Node target, Node node) throws OlapDocsErrorException {
        try {
            return node.isChildOf(target);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static boolean isSharingEverybody(OlapDocsSharing sharing) {
        return "<everybody>".equals(sharing.getRoleName());
    }

    public static boolean hasSharings(Node node) throws OlapDocsErrorException {
        try {
            boolean hasPermissions = node.hasPermissions();
            return hasPermissions;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static List<OlapDocsSharing> unmarshallSharings(Node node) throws OlapDocsErrorException {
        try {
            List<OlapDocsSharing> sharings = node.unmarshallPermissions();
            return sharings;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }
}

