/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository;

import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.gwt.server.reporting.audit.OlapDocsAuditManager;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingLocation;
import crazydev.iccube.gwt.server.reporting.repository.OlapRepositories;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.reporting.repository.webpub.OlapDocsFileSystemRepository;
import crazydev.iccube.gwt.server.reporting.repository.webpub.OlapDocsPublicRepository;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OlapRepositoryManager {
    private final IcCubeEngine engine;
    private final OlapDocsAuditManager auditManager;
    private final Map<String, OlapRepositories> repositories = new ConcurrentHashMap<String, OlapRepositories>();
    private volatile int initSequence;

    public OlapRepositoryManager(IcCubeEngine engine) {
        this.engine = engine;
        this.auditManager = new OlapDocsAuditManager();
        this.initSequence = -1;
    }

    public OlapDocsActualRepository createRootReportRepository() {
        this.initSequence = 0;
        OlapLoggers.GENERAL.info((Object)"[docs] create repository started");
        OlapEngineApplicationContext appContext = this.engine.getOlapEngineApplicationContext();
        OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)appContext);
        OlapRuntime runtime = this.engine.getRuntime();
        OlapDirectoriesResolved directoriesResolved = rContext.getDirectoriesResolved();
        File docsLocation = directoriesResolved.getDocsRepositoryDirectory();
        IcCubeServerConfiguration configuration = this.engine.getConfiguration();
        OlapReportingComponentConfiguration reportingConfiguration = configuration.getReportingConfiguration();
        OlapReportingLocation reportingLocation = reportingConfiguration != null ? reportingConfiguration.getLocation() : null;
        IcCubeMimeTypesConfiguration mimeTypes = configuration.getMimeTypesConfiguration();
        OlapDocsActualRepository reportRepository = new OlapDocsActualRepository(runtime, directoriesResolved, appContext, reportingLocation, this.auditManager, mimeTypes, docsLocation, true);
        File webPubDirectory = directoriesResolved.getWebPubDirectory();
        OlapDocsPublicRepository publicRepository = new OlapDocsPublicRepository(runtime, webPubDirectory, mimeTypes);
        OlapFileSystem fileSystem = rContext.getRootFileSystem();
        boolean fileSystemVisible = this.engine.isFileSystemRootVisibleInDocs();
        OlapDocsFileSystemRepository fsRepository = new OlapDocsFileSystemRepository(fileSystem, fileSystemVisible, mimeTypes);
        OlapRepositories repos = new OlapRepositories(reportRepository, publicRepository, fsRepository);
        this.repositories.put("$IC3_NO_TENANT_KEY$", repos);
        this.initSequence = 1;
        OlapLoggers.GENERAL.info((Object)"[docs] create repository completed");
        return repos.reportRepository;
    }

    public void setupTenantReportRepository(OlapDirectoriesResolved directories, boolean installDashboardApp) {
        OlapLoggers.GENERAL.info((Object)("[docs] create repository started [tenant : " + directories.getTenantName() + " ]"));
        OlapEngineApplicationContext appContext = this.engine.getOlapEngineApplicationContext();
        OlapRuntime runtime = this.engine.getRuntime();
        IcCubeServerConfiguration configuration = this.engine.getConfiguration();
        OlapReportingComponentConfiguration reportingConfiguration = configuration.getReportingConfiguration();
        OlapReportingLocation reportingLocation = reportingConfiguration != null ? reportingConfiguration.getLocation() : null;
        IcCubeMimeTypesConfiguration mimeTypes = configuration.getMimeTypesConfiguration();
        OlapDocsActualRepository repository = new OlapDocsActualRepository(runtime, directories, appContext, reportingLocation, this.auditManager, mimeTypes, directories.getDocsRepositoryDirectory(), installDashboardApp);
        repository.shutdownNow();
        OlapLoggers.GENERAL.info((Object)("[docs] create repository completed [tenant : " + directories.getTenantName() + " ]"));
    }

    public OlapDocsAuditManager getAuditManager() {
        return this.auditManager;
    }

    public OlapDocsActualRepository getDocsRepository(OlapRuntimeContext context) {
        OlapRepositories repos = this.getOrCreateRepositories(context);
        return repos.reportRepository;
    }

    public OlapDocsPublicRepository getWebPublicRepository(OlapRuntimeContext context) {
        OlapRepositories repos = this.getOrCreateRepositories(context);
        return repos.publicRepository;
    }

    public OlapDocsFileSystemRepository getFileSystemRootRepository(OlapRuntimeContext context) {
        OlapRepositories repos = this.getOrCreateRepositories(context);
        return repos.fsRepository;
    }

    public void shutdownNow() {
        for (OlapRepositories repos : this.repositories.values()) {
            repos.shutdownNow();
        }
    }

    private OlapRepositories getOrCreateRepositories(OlapRuntimeContext context) {
        OlapTenant tenant = context.getTenant();
        OlapRepositories repos = tenant != null ? this.getOrCreateTenantRepositories(context, tenant) : this.getOrCreateGlobalRepositories();
        return repos;
    }

    private OlapRepositories getOrCreateTenantRepositories(OlapRuntimeContext context, OlapTenant tenant) {
        return this.repositories.computeIfAbsent(tenant.getName(), tenantName -> this.createTenantReportRepositories(tenant, context.getDirectoriesResolved(), context.getRootFileSystem()));
    }

    private OlapRepositories getOrCreateGlobalRepositories() {
        OlapRepositories repos = this.repositories.get("$IC3_NO_TENANT_KEY$");
        if (repos != null) {
            return repos;
        }
        if (this.initSequence == -1) {
            throw new RuntimeException("unexpected missing global repositories");
        }
        while (this.initSequence != 1) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        repos = this.repositories.get("$IC3_NO_TENANT_KEY$");
        if (repos != null) {
            return repos;
        }
        throw new RuntimeException("unexpected missing initialized global repositories [initSequence:" + this.initSequence + "]");
    }

    private OlapRepositories createTenantReportRepositories(OlapTenant tenant, OlapDirectoriesResolved directories, OlapFileSystem fileSystem) {
        OlapLoggers.GENERAL.info((Object)("[docs] create repository started " + OlapTenant.info((OlapTenant)tenant)));
        OlapEngineApplicationContext appContext = this.engine.getOlapEngineApplicationContext();
        OlapRuntime runtime = this.engine.getRuntime();
        IcCubeServerConfiguration configuration = this.engine.getConfiguration();
        OlapReportingComponentConfiguration reportingConfiguration = configuration.getReportingConfiguration();
        OlapReportingLocation reportingLocation = reportingConfiguration != null ? reportingConfiguration.getLocation() : null;
        IcCubeMimeTypesConfiguration mimeTypes = configuration.getMimeTypesConfiguration();
        OlapDocsActualRepository reportRepository = new OlapDocsActualRepository(runtime, directories, appContext, reportingLocation, this.auditManager, mimeTypes, directories.getDocsRepositoryDirectory(), false);
        File webPubDirectory = directories.getWebPubDirectory();
        OlapDocsPublicRepository publicRepository = new OlapDocsPublicRepository(runtime, webPubDirectory, mimeTypes);
        boolean fileSystemVisible = this.engine.isFileSystemRootVisibleInDocs();
        OlapDocsFileSystemRepository fsRepository = new OlapDocsFileSystemRepository(fileSystem, fileSystemVisible, mimeTypes);
        OlapRepositories repos = new OlapRepositories(reportRepository, publicRepository, fsRepository);
        OlapLoggers.GENERAL.info((Object)("[docs] create repository completed " + OlapTenant.info((OlapTenant)tenant)));
        return repos;
    }
}

