/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository;

import crazydev.iccube.fs.OlapAttachment;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntityRepositoryType;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsPermsBypass;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepositorySetupHelper;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.PathHelper;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.Session;
import crazydev.iccube.server.repository.fs.FileRepositoryTenantRootException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapDocsSession {
    private final IOlapDocsRequestContext requestContext;
    private final OlapDocsRepository repository;
    private final PathHelper helper;
    private final Session session;
    private final OlapDocsSessionR asNoSave;

    public OlapDocsSession(IOlapDocsRequestContext requestContext, OlapDocsRepository repository, PathHelper helper, Session session) throws OlapDocsErrorException, RepositoryException {
        this.requestContext = requestContext;
        this.repository = repository;
        this.helper = helper;
        this.session = session;
        this.asNoSave = new OlapDocsSessionR(this);
        if (OlapLoggers.DOC_REPOSITORY_SESSION.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY_SESSION.debug((Object)("[docs] session created : " + this.logInfo() + " (" + System.identityHashCode(session) + ")"));
        }
    }

    public File getTmpDirectory() {
        return this.requestContext.getTmpDirectory();
    }

    public OlapDocsPermissions getLabelNodePermissions(Node node, @Nullable OlapDocsPermsBypass reportApp) throws OlapDocsErrorException {
        OlapDocsPermissions perms = this.repository.getLabelNodePermissions(this.asNoSave, node, reportApp);
        return perms;
    }

    public OlapDocsPermissions getDocNodePermissions(Node node, @Nullable OlapDocsPermsBypass reportApp) throws OlapDocsErrorException {
        OlapDocsPermissions perms = this.repository.getDocNodePermissions(this.asNoSave, node, reportApp);
        return perms;
    }

    public boolean isWebDashboardsAutoInstall() {
        return this.requestContext.isWebDashboardsAutoInstall();
    }

    public OlapDocsEntityRepositoryType getDocsType() {
        return this.repository.getType();
    }

    public OlapPath[] getUsers() {
        return OlapDocsRepository.NODE_USERS;
    }

    public String logInfo() {
        return this.getUserName();
    }

    public OlapDocsSessionR asNoSave() {
        return this.asNoSave;
    }

    public IOlapDocsRequestContext requestContext() {
        return this.requestContext;
    }

    public boolean isReadOnly() {
        return this.session.isReadOnly();
    }

    public boolean isAdministrator() {
        return this.requestContext.isAdministrator();
    }

    public boolean isDocAdministrator() {
        return this.requestContext.isDocAdministrator();
    }

    public boolean isAppCreator() {
        return this.requestContext.isAppCreator();
    }

    public String getUserName() {
        OlapPrincipal user = this.requestContext.getUser();
        return user.getName();
    }

    @Nullable
    public String getUserTenantName() {
        OlapPrincipal user = this.requestContext.getUser();
        OlapTenant tenant = user.getTenant();
        return tenant != null ? tenant.getName() : null;
    }

    public OlapPath NODE_ROOT_PATH(boolean forceGlobal) {
        return this.helper.NODE_ROOT_PATH(forceGlobal);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_PATH(boolean forceGlobal) {
        return this.helper.NODE_ROOT_IC3_REPORT_PATH(forceGlobal);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_APP_PATH(boolean forceGlobal) {
        return this.helper.NODE_ROOT_IC3_REPORT_APP_PATH(forceGlobal);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_APP_BACKUPS_PATH(boolean forceGlobal) {
        return this.helper.NODE_ROOT_IC3_REPORT_APP_BACKUPS_PATH(forceGlobal);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_APP_LOCAL_PATH(boolean forceGlobal) {
        return this.helper.NODE_ROOT_IC3_REPORT_APP_LOCAL_PATH(forceGlobal);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_GIZMOS_PATH(boolean forceGlobal) {
        return this.helper.NODE_ROOT_IC3_REPORT_GIZMOS_PATH(forceGlobal);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_PATH(boolean forceGlobal, OlapDocsGizmoEntityType type) {
        return this.helper.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_PATH(forceGlobal, type);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_SHARED_PATH(boolean forceGlobal, OlapDocsGizmoEntityType type) {
        return this.helper.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_SHARED_PATH(forceGlobal, type);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_USERS_PATH(boolean forceGlobal, OlapDocsGizmoEntityType type) {
        return this.helper.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_USERS_PATH(forceGlobal, type);
    }

    public OlapPath NODE_ROOT_IC3_REPORT_DATA_PATH() {
        return this.helper.NODE_ROOT_IC3_REPORT_DATA_PATH();
    }

    public final Node getNodeRoot(boolean forceGlobal) throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_PATH(forceGlobal);
        try {
            return this.session.getNode(path);
        }
        catch (FileRepositoryTenantRootException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.TENANT_FILE_SYSTEM_ROOT_MISSING, new Serializable[0]);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public Node getNodeRootReportApp(boolean forceGlobal) throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_IC3_REPORT_APP_PATH(forceGlobal);
        try {
            return this.session.getNode(path);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public Node getNodeRootReportAppBackups(boolean forceGlobal) throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_IC3_REPORT_APP_BACKUPS_PATH(forceGlobal);
        try {
            return this.session.getNode(path);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public Node getNodeRootReportAppLocal(boolean forceGlobal) throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_IC3_REPORT_APP_LOCAL_PATH(forceGlobal);
        try {
            return this.getNode(path);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public Node getNodeRootReportGizmosEntity(boolean forceGlobal, OlapDocsGizmoEntityType type) throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_PATH(forceGlobal, type);
        try {
            return this.getNode(path);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public Node getNodeRootReportGizmosEntityShared(boolean forceGlobal, OlapDocsGizmoEntityType type) throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_SHARED_PATH(forceGlobal, type);
        try {
            return this.getNode(path);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public Node getNodeRootReportGizmosEntityUsers(boolean forceGlobal, OlapDocsGizmoEntityType type) throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_USERS_PATH(forceGlobal, type);
        try {
            return this.getNode(path);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public Node getNodeRootReportData() throws OlapDocsErrorException {
        OlapPath path = this.NODE_ROOT_IC3_REPORT_DATA_PATH();
        try {
            return this.getNode(path);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_NODE_NOT_FOUND, new Serializable[]{path.toErrorPath()});
        }
    }

    public File createTmpFileForUpload(File tmpDirectory, String extension) throws IOException {
        return this.session.createTmpFileForUpload(tmpDirectory, extension);
    }

    public boolean nodeExists(OlapPath path) throws RepositoryException {
        return this.session.nodeExists(path);
    }

    public Node getNode(OlapPath path) throws RepositoryException {
        return this.session.getNode(path);
    }

    public Node getNodeByIdentifier(OlapPath uuid) throws RepositoryException {
        if (uuid == null) {
            throw new PathNotFoundException("");
        }
        return this.session.getNode(uuid);
    }

    @Nullable
    public OlapDocsPermissions getPermissions(OlapPath absPath) throws RepositoryException {
        return this.session.getPermissions(absPath);
    }

    public void move(OlapPath from, OlapPath to) throws RepositoryException {
        this.session.move(from, to);
    }

    public void copy(OlapPath from, OlapPath to) throws RepositoryException {
        this.session.copy(from, to);
    }

    public void removeItem(OlapPath path) throws RepositoryException {
        this.session.removeItem(path);
    }

    @Nullable
    public OlapAttachment download(File tmpDirectory, OlapPath path, List<String> entries) throws RepositoryException, IOException {
        return this.session.download(tmpDirectory, path, entries);
    }

    public void commit() throws RepositoryException {
        this.session.commit();
    }

    public void forEachNode(Node root, Consumer<Node> consumer) throws RepositoryException {
        this.session.forEachNode(root, consumer);
    }

    public String getAllPermissions() throws RepositoryException {
        return this.session.getAllPermissions();
    }

    public void logout() {
        if (OlapLoggers.DOC_REPOSITORY_SESSION.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY_SESSION.debug((Object)("[docs] session logout : " + this.logInfo() + " (" + System.identityHashCode(this.session) + ")"));
        }
        this.session.logout();
    }

    public void installWebDashboards(File zip, Predicate<String> filter, boolean backup) throws RepositoryException {
        OlapPath app = this.NODE_ROOT_IC3_REPORT_APP_PATH(false);
        OlapPath backups = this.NODE_ROOT_IC3_REPORT_APP_BACKUPS_PATH(false);
        this.session.installWebDashboards(app, backups, zip, filter, backup);
    }

    public void installWebDashboardsFromBackup(String timestamp) throws RepositoryException {
        OlapPath app = this.NODE_ROOT_IC3_REPORT_APP_PATH(false);
        OlapPath backups = this.NODE_ROOT_IC3_REPORT_APP_BACKUPS_PATH(false);
        this.session.installWebDashboardsFromBackup(app, backups, timestamp);
    }

    public Node<?> setupUserHomeFolder(OlapDocsGizmoEntityType type) {
        OlapDocsActualRepositorySetupHelper setupNodesHelper = this.repository.setupNodesHelper();
        if (setupNodesHelper != null) {
            return setupNodesHelper.setupUserHomeFolder(this, type);
        }
        OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] missing setup-nodes-helper");
        return null;
    }
}

