/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository;

import com.vdurmont.semver4j.Semver;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntimeDashboardsVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public class OlapDocsDashboardsVersion {
    public final Semver version;
    @Nullable
    public final String timestamp;
    public final boolean active;
    public final String path;
    @Nullable
    public final String backup;

    public OlapDocsDashboardsVersion(OlapRuntimeDashboardsVersion version, boolean active, String path, @Nullable String backup) {
        this.version = new Semver(version.version, Semver.SemverType.LOOSE);
        this.timestamp = version.timestamp;
        this.active = active;
        this.path = path;
        this.backup = backup;
    }

    public String getVersionWithTimestamp() {
        if (this.timestamp != null) {
            return this.version.getOriginalValue() + " (" + this.timestamp + ")";
        }
        return this.version.getOriginalValue();
    }

    @Nullable
    public Long getTimestampMS() {
        if (this.timestamp == null) {
            return null;
        }
        try {
            Date date = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz").parse(this.timestamp);
            return date.getTime();
        }
        catch (ParseException ex) {
            OlapLoggers.GENERAL.warn((Object)("getTimestampMS [" + this.timestamp + "] error"), (Throwable)ex);
            return null;
        }
    }

    public String toString() {
        return this.getVersionWithTimestamp();
    }
}

