/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.model;

import crazydev.common.utils.CdPathEscapeUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabel;
import java.util.ArrayList;
import java.util.List;

public class OlapDocsLabelPath {
    private final List<Entry> entries = new ArrayList<Entry>();

    public OlapDocsLabelPath() {
    }

    public OlapDocsLabelPath(OlapPath path) {
        for (OlapPath parent = path; parent != null && !parent.isEmpty(); parent = parent.getParent()) {
            String uuid = parent.toUUID();
            String name = parent.getName().getName();
            this.entries.add(0, new Entry(OlapDocsLabel.class, uuid, name));
        }
    }

    public OlapDocsLabelPath(OlapDocsLabel ... labels) {
        if (labels != null) {
            for (OlapDocsLabel label : labels) {
                this.entries.add(new Entry(label.getClass(), label.getLabelUuid(), label.getLabelCaption()));
            }
        }
    }

    private OlapDocsLabelPath(List<Entry> entries) {
        this.entries.addAll(entries);
    }

    public OlapDocsLabelPath truncate(String identifier) {
        Entry entry;
        ArrayList<Entry> truncated = new ArrayList<Entry>();
        for (int idx = this.entries.size() - 1; idx >= 0 && !(entry = this.entries.get(idx)).getUuid().equals(identifier); --idx) {
            truncated.add(0, entry);
        }
        return new OlapDocsLabelPath(truncated);
    }

    public int size() {
        return this.entries.size();
    }

    public Entry getEntry(int index) {
        Entry entry = this.entries.get(index);
        return entry;
    }

    public void add(Class<? extends OlapDocsLabel> clazz, String uuid, String name) {
        this.entries.add(new Entry(clazz, uuid, name));
    }

    public void addFirst(Class<? extends OlapDocsLabel> clazz, String uuid, String name) {
        this.entries.add(0, new Entry(clazz, uuid, name));
    }

    public String toUUID() {
        if (this.entries.isEmpty()) {
            return "";
        }
        return this.entries.get(this.entries.size() - 1).getUuid();
    }

    public String toSimplePath() {
        if (this.entries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Entry entry : this.entries) {
            String name = entry.getName();
            String name_ = CdPathEscapeUtils.escapeSimplePathName((String)name);
            sb.append("/").append(name_);
        }
        return sb.toString();
    }

    public String toErrorPath() {
        if (this.entries.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (Entry entry : this.entries) {
            sb.append("/").append(entry.getName());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toErrorPath();
    }

    public static class Entry {
        private final Class<? extends OlapDocsLabel> clazz;
        private final String uuid;
        private final String name;

        public Entry(Class<? extends OlapDocsLabel> clazz, String uuid, String name) {
            this.clazz = clazz;
            this.uuid = uuid;
            this.name = name;
        }

        public Class<? extends OlapDocsLabel> getClazz() {
            return this.clazz;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

