/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.model;

import crazydev.common.io.CdStringWriter;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntity;
import crazydev.iccube.server.repository.Binary;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.tenants.OlapTenantUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OlapDocsDocFile {
    private final String filename;
    private final Binary data;
    private final String mimeType;
    @Nullable
    private String requireTenantCacheBusting;

    public OlapDocsDocFile(String filename, Binary data, String mimeType) {
        this.filename = filename;
        this.data = data;
        this.mimeType = mimeType;
    }

    public String getFileName() {
        return this.filename;
    }

    public void performRequireTenantCacheBusting(OlapDocsEntity entity) {
        this.requireTenantCacheBusting = entity.getRequireTenantCacheBusting();
    }

    public InputStream getInputStream() throws OlapDocsErrorException {
        if (this.requireTenantCacheBusting != null) {
            try {
                InputStream dataIn = this.data.createInputStream();
                InputStream in = OlapTenantUtils.fixDashboardsFile((String)this.requireTenantCacheBusting, (String)this.filename, (InputStream)dataIn);
                if (in == null) {
                    return dataIn;
                }
                return in;
            }
            catch (RepositoryException ex) {
                throw new OlapDocsErrorException(ex);
            }
            catch (IOException ex) {
                throw new OlapDocsErrorException(ex);
            }
        }
        try {
            return this.data.createInputStream();
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public CdStringWriter getContentAsString(int maxLen) throws OlapDocsErrorException {
        InputStream in = null;
        try {
            in = this.getInputStream();
            CdStringWriter sw = new CdStringWriter(maxLen);
            IOUtils.copy((InputStream)in, (Writer)sw, (String)this.getEncoding());
            CdStringWriter cdStringWriter = sw;
            return cdStringWriter;
        }
        catch (IOException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_FILE_IO_ERROR, new Serializable[]{this.filename, ex});
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public List<String> getContentAsLines() throws OlapDocsErrorException {
        ArrayList<String> arrayList;
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.getInputStream(), this.getEncoding()));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (IOException ex) {
            try {
                throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_FILE_IO_ERROR, new Serializable[]{this.filename, ex});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        return arrayList;
    }

    public void dispose() {
        this.data.dispose();
    }
}

