/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.component.template;

import crazydev.common.utils.CdStringUtils;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;

public class OlapReportHtml {
    private final List<String> html;

    public OlapReportHtml(List<String> html) {
        this.html = html;
    }

    public List<String> getHtml() {
        return this.html;
    }

    public void createHtmlMF(ServletOutputStream out, @Nullable String csrfToken, boolean isMdxConsole) throws IOException {
        for (String line : this.html) {
            boolean livedemo;
            if (csrfToken != null && line.contains("ic3-CSRF-Token")) {
                line = line.replace("ic3-CSRF-Token (DO NOT REMOVE - USED TO GENERATE FILES)", csrfToken);
            }
            if (isMdxConsole && line.contains("<title>icCube Dashboards</title>")) {
                line = line.replace("<title>icCube Dashboards</title>", "<title>MDX</title>");
            }
            if ((livedemo = "true".equals(System.getProperty("ic3.livedemo"))) && line.contains("</head>")) {
                line = line.replace("</head>", "<!-- Launched -->\n<script>\n    !function(i,s,o,g,r,a,m){i.Ip2cObject=o;i[o]||(i[o]=function(){\n    (i[o].q=i[o].q||[]).push(arguments)});i[o].l=+new Date;r=s.createElement(g);\n    a=s.getElementsByTagName(g)[0];r.src='//reveal.ip2c.net/8427257.js';\n    a.parentNode.insertBefore(r,a)}(window,document,'ip2c','script');\n            \n    ip2c('verify', '8427257');\n</script>\n</head>");
            }
            out.println(line);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createHtml(ServletOutputStream out, @Nullable String csrfToken, @Nullable String reportUuid, @Nullable String reportName, @Nullable String reportCallback, @Nullable String reportMode, @Nullable String reportMenu, @Nullable String reportParams) throws IOException {
        for (String string : this.html) {
            void var10_10;
            if (csrfToken != null && string.contains("ic3-CSRF-Token")) {
                String string2 = "ic3_CSRF_token = '" + csrfToken + "';";
            } else if (CdStringUtils.isNotNullAndNotBlank((String)reportUuid) || CdStringUtils.isNotNullAndNotBlank((String)reportName) || CdStringUtils.isNotNullAndNotBlank((String)reportCallback)) {
                String string3 = OlapReportHtml.processOpenReportParams(string, reportUuid, reportName, reportCallback, reportMode, reportMenu, reportParams);
            }
            out.println((String)var10_10);
        }
    }

    private static String processOpenReportParams(String line, @Nullable String reportUuid, @Nullable String reportName, @Nullable String reportCallback, @Nullable String reportMode, @Nullable String reportMenu, @Nullable String reportParams) {
        if (CdStringUtils.isNullOrBlank((String)reportUuid) && CdStringUtils.isNullOrBlank((String)reportName) && CdStringUtils.isNullOrBlank((String)reportCallback)) {
            return line;
        }
        if (!line.contains("ic3-start-report-options")) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        if (CdStringUtils.isNotNullAndNotBlank((String)reportUuid) || CdStringUtils.isNotNullAndNotBlank((String)reportName)) {
            sb.append("report:{");
            if (CdStringUtils.isNotNullAndNotBlank((String)reportUuid)) {
                sb.append("uniqueName:\"").append(reportUuid).append("\"");
            }
            if (CdStringUtils.isNotNullAndNotBlank((String)reportName)) {
                sb.append(CdStringUtils.isNotNullAndNotBlank((String)reportUuid) ? "," : "").append("name:\"").append(StringEscapeUtils.escapeEcmaScript((String)reportName)).append("\"");
            }
            String escapedParams = !CdStringUtils.isNullOrBlank((String)reportParams) ? StringEscapeUtils.escapeEcmaScript((String)reportParams) : "{}";
            sb.append(",params:\"").append(escapedParams).append("\"}");
        }
        if (!CdStringUtils.isNullOrBlank((String)reportMode)) {
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            sb.append("mode:\"").append(reportMode).append("\"");
        }
        if (!CdStringUtils.isNullOrBlank((String)reportMenu)) {
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            sb.append("menu:\"").append(reportMenu).append("\"");
        }
        if (!CdStringUtils.isNullOrBlank((String)reportCallback)) {
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            sb.append("cb:\"").append(reportCallback).append("\"");
        }
        return sb.toString();
    }
}

