/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.component;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.gwt.server.reporting.component.OlapReportConfigFileType;
import crazydev.iccube.gwt.server.reporting.component.OlapReportHeadersConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingLocation;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="reportingComponentConfiguration")
public class OlapReportingComponentConfiguration {
    private static final OlapReportConfigFileType CONFIG_FILE_TYPE_DEFAULT = OlapReportConfigFileType.JS;
    @XmlElement(name="url", required=true)
    private List<String> urls;
    @XmlElement(name="configurationType", required=false)
    private OlapReportConfigFileType configurationType;
    @XmlElement(name="location", required=false)
    @Nullable
    private OlapReportingLocation location_;
    @XmlElement(name="reportHtmlLocation", required=false)
    @Nullable
    private String reportHtmlLocation_;
    @XmlElement(name="reportAppUrl", required=false)
    @Nullable
    private String reportAppUrl_;
    @XmlElement(name="defaultVersion", required=false)
    @Nullable
    private String defaultVersion_;
    @XmlElement(name="enableCompression", required=false)
    private boolean enableCompression = true;
    @XmlElement(name="app-headers", required=false)
    @Nullable
    private OlapReportHeadersConfiguration appHeaders;
    @XmlElement(name="filter", required=true)
    private List<String> filters;

    protected OlapReportingComponentConfiguration() {
    }

    public void validate() throws OlapConfigurationException {
        if (this.urls == null || this.urls.isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"url"});
        }
        if (this.configurationType == null) {
            this.configurationType = CONFIG_FILE_TYPE_DEFAULT;
        }
        for (int ii = 0; ii < this.urls.size(); ++ii) {
            String url = this.urls.get(ii);
            if (url != null && !CdStringUtils.isNullOrBlank((String)url)) continue;
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"url[" + ii + "]"});
        }
        if (this.appHeaders != null) {
            this.appHeaders.validate();
        }
        if (this.filters == null || this.filters.isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"report authentication filter"});
        }
        for (String filter : this.filters) {
            if (!CdStringUtils.isNullOrBlank((String)filter)) continue;
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"report authentication filter"});
        }
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public OlapReportConfigFileType getConfigurationType() {
        return this.configurationType != null ? this.configurationType : CONFIG_FILE_TYPE_DEFAULT;
    }

    public OlapReportingLocation getLocation() {
        return OlapReportingLocation.DOCS;
    }

    public OlapReportHeadersConfiguration getAppHeaders() {
        if (this.appHeaders == null) {
            return OlapReportHeadersConfiguration.EMPTY;
        }
        return this.appHeaders;
    }

    public List<String> getFilterConfiguration() {
        return this.filters;
    }
}

