/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.lazytree;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeModel;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeIdentifier;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeModel;
import crazydev.iccube.gwt.base.shared.widget.lazytree.request.GwtLazyTreeNodesQuery;
import crazydev.iccube.gwt.server.lazytree.LazyTreeChildrenStruct;
import crazydev.iccube.gwt.server.lazytree.LazyTreeVisitor;

public abstract class AbstractLazyTreeCommand<TREENODE extends GwtLazyTreeNodeModel> {
    protected final OlapBabylonService babylon;
    protected final GwtLazyTreeNodesQuery serverQuery;

    public AbstractLazyTreeCommand(OlapBabylonService babylon, GwtLazyTreeNodesQuery serverQuery) {
        this.babylon = babylon;
        this.serverQuery = serverQuery;
    }

    public final GwtLazyTreeModel call() {
        if (this.serverQuery.getServerTreeUId() != null && !this.getServerTreeUId().equals(this.serverQuery.getServerTreeUId())) {
            return this.onTreeOutOfSync(this.serverQuery.getClientTreeUId());
        }
        Object lookupNodeId = this.serverQuery.getParentNodeId();
        if (lookupNodeId == null) {
            return this.newRootTreeRequest();
        }
        LazyTreeChildrenStruct<TREENODE> children = this.getChildren((GwtLazyTreeNodeIdentifier)lookupNodeId);
        return this.newRequest(children);
    }

    protected abstract String getServerTreeUId();

    protected abstract void visitTree(LazyTreeVisitor<TREENODE> var1);

    protected abstract GwtLazyTreeModel onTreeOutOfSync(String var1);

    protected abstract GwtLazyTreeModel newRootTreeRequest();

    protected abstract GwtLazyTreeModel newRequest(LazyTreeChildrenStruct<TREENODE> var1);

    protected LazyTreeChildrenStruct<TREENODE> getChildren(GwtLazyTreeNodeIdentifier lookupNodeId) {
        LazyTreeChildrenStruct lookupRes = new LazyTreeChildrenStruct();
        this.visitTree(this.createVisitor(lookupNodeId, lookupRes));
        return lookupRes;
    }

    public abstract LazyTreeVisitor<TREENODE> createVisitor(GwtLazyTreeNodeIdentifier var1, LazyTreeChildrenStruct<TREENODE> var2);
}

