/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.base.shared.widget.lazytree.model;

import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeIdentifier;
import java.util.Arrays;

public class GwtLazyTreePathTreeNodeIdentifier
extends GwtLazyTreeNodeIdentifier {
    private static final long serialVersionUID = -6456514972987302612L;
    private String schemaName;
    private int[] pathPositions;

    private GwtLazyTreePathTreeNodeIdentifier() {
    }

    public GwtLazyTreePathTreeNodeIdentifier(String schemaName) {
        this.schemaName = schemaName;
    }

    public GwtLazyTreePathTreeNodeIdentifier(String schemaName, int[] ints) {
        this.schemaName = schemaName;
        this.pathPositions = ints;
    }

    public int[] getPathPositions() {
        return this.pathPositions;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GwtLazyTreePathTreeNodeIdentifier that = (GwtLazyTreePathTreeNodeIdentifier)o;
        if (!Arrays.equals(this.pathPositions, that.pathPositions)) {
            return false;
        }
        return !(this.schemaName != null ? !this.schemaName.equals(that.schemaName) : that.schemaName != null);
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = 31 * result + (this.pathPositions != null ? Arrays.hashCode(this.pathPositions) : 0);
        return result;
    }

    public boolean isInBranch(GwtLazyTreePathTreeNodeIdentifier lookupId) {
        boolean sameName = this.schemaName.equals(lookupId.schemaName);
        if (!sameName || this.pathPositions == null && lookupId.pathPositions == null) {
            return sameName;
        }
        if (this.pathPositions == null || lookupId.pathPositions == null) {
            return true;
        }
        int[] lookPath = lookupId.pathPositions;
        int len = Math.min(lookPath.length, this.pathPositions.length);
        for (int i = 0; i < len; ++i) {
            if (lookPath[i] == this.pathPositions[i]) continue;
            return false;
        }
        return true;
    }
}

