/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.base.shared.comm.request;

import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQueryKind;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.base.shared.utils.GwtClassUtils;
import crazydev.iccube.gwt.base.shared.utils.GwtUuidUtils;
import org.jetbrains.annotations.Nullable;

public abstract class GwtAbstractQuery<T extends GwtInfo>
implements GwtQuery<T> {
    private String clientUUID = GwtUuidUtils.getClientUUID(this);

    protected GwtAbstractQuery() {
    }

    @Override
    public String getClientUUID() {
        return this.clientUUID;
    }

    @Override
    public String getTrackingInfo(String className) {
        String kind = this.getKind().name();
        String schema = this.getSchema();
        String type = className;
        String uuid = this.getClientUUID();
        return kind + " (" + (String)(schema != null ? "schema:" + schema : "schema:none") + ") " + type + " " + uuid;
    }

    @Override
    public GwtQueryKind getKind() {
        return GwtQueryKind.OTHER;
    }

    @Override
    public abstract String getUserFriendlyTypeName();

    @Override
    @Nullable
    public String getMdxForCancelReport() {
        return null;
    }

    @Override
    public boolean isSchemaLifeCycle() {
        return false;
    }

    @Override
    @Nullable
    public String getSchemaLifeCycleName() {
        return null;
    }

    @Override
    public boolean isAllSchema() {
        return false;
    }

    @Override
    @Nullable
    public String getSchema() {
        return null;
    }

    @Override
    public boolean isSchemaWrite() {
        return false;
    }

    @Override
    @Nullable
    public String getSchemaFactoryFile() {
        return null;
    }

    @Override
    public boolean isUnloadSchema() {
        return false;
    }

    @Override
    public boolean isLoadSchema() {
        return false;
    }

    @Override
    public boolean isFullLoadSchema() {
        return false;
    }

    @Override
    public String getSchemaOfflineSnapshot() {
        return null;
    }

    @Override
    public String getName() {
        return GwtClassUtils.getSimpleName(this.getClass());
    }

    @Override
    public boolean isMonitored() {
        return false;
    }

    @Override
    public boolean isLoadMonitoring() {
        return false;
    }

    public String getTitleTag() {
        return this.getName();
    }

    public String getTooltipTag() {
        return this.getTitleTag();
    }

    @Override
    public boolean confirmNeeded() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GwtAbstractQuery that = (GwtAbstractQuery)o;
        return this.clientUUID.equals(that.clientUUID);
    }

    public int hashCode() {
        return this.clientUUID.hashCode();
    }
}

