/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded.checker;

import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class GCInfoChecker
implements Runnable {
    private final IcCubeServerApplicationContext context;
    private final Map<GarbageCollectorMXBean, GcInfo> gcInfos = new IdentityHashMap<GarbageCollectorMXBean, GcInfo>();

    public GCInfoChecker(IcCubeServerApplicationContext context) {
        this.context = context;
    }

    @Override
    public void run() {
        try {
            List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
            int size = beans.size();
            for (int ii = 0; ii < size; ++ii) {
                long updateMS;
                GarbageCollectorMXBean bean = beans.get(ii);
                GcInfo gcInfo = this.gcInfos.get(bean);
                if (gcInfo == null) {
                    gcInfo = new GcInfo(bean);
                    this.gcInfos.put(bean, gcInfo);
                }
                if ((updateMS = gcInfo.update()) == -1L) continue;
                long maxM = Runtime.getRuntime().maxMemory();
                long totalM = Runtime.getRuntime().totalMemory();
                long freeM = Runtime.getRuntime().freeMemory();
                String max = CdSizeUtils.format((double)maxM);
                String total = CdSizeUtils.format((double)totalM);
                String free = CdSizeUtils.format((double)freeM);
                String info = " ( free:" + free + " / total:" + total + " / max:" + max + " )";
                String name = gcInfo.bean.getName();
                String update = updateMS + "ms";
                OlapLoggers.GENERAL.info((Object)("[GC] (" + name + ") : " + update + info));
                this.context.onGarbageCollectorActivity(name, updateMS, freeM, totalM, maxM);
            }
        }
        catch (Exception ex) {
            OlapLoggers.GENERAL.fatal((Object)"[GC] error : ", (Throwable)ex);
        }
    }

    static class GcInfo {
        private final GarbageCollectorMXBean bean;
        private long latestTime;

        public GcInfo(GarbageCollectorMXBean bean) {
            this.bean = bean;
            this.latestTime = bean.getCollectionTime();
        }

        public long update() {
            long time = this.bean.getCollectionTime();
            if (time > this.latestTime) {
                long update = time - this.latestTime;
                this.latestTime = time;
                return update;
            }
            return -1L;
        }
    }
}

