/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.buffer.PointableRoaringArray;

public abstract class RoaringBufferFastAggregation {
    private RoaringBufferFastAggregation() {
    }

    public static boolean and(OlapBitmapCallback cb, ImmutableRoaringBitmap ... b) {
        return RoaringBufferFastAggregation.and(b, cb);
    }

    public static boolean and(ImmutableRoaringBitmap[] bitmaps, OlapBitmapCallback cb) {
        if (RoaringBufferFastAggregation.workShyAnd_New(bitmaps, cb)) {
            cb.onApplied();
            return true;
        }
        return false;
    }

    private static boolean workShyAnd_New(ImmutableRoaringBitmap[] bitmaps, OlapBitmapCallback cb) {
        if (bitmaps.length == 0 || bitmaps[0].isZero()) {
            return true;
        }
        Arrays.sort(bitmaps, Comparator.comparingInt(a -> a.highLowContainer.size()));
        int numBitmaps = bitmaps.length;
        int[] containersPos = new int[bitmaps.length];
        PointableRoaringArray firstContainer = bitmaps[0].highLowContainer;
        for (int firstI = 0; firstI < firstContainer.size(); ++firstI) {
            char currentKey = firstContainer.getKeyAtIndex(firstI);
            boolean andOnContainer = true;
            for (int j = 1; j < numBitmaps; ++j) {
                PointableRoaringArray containerJ = bitmaps[j].highLowContainer;
                int posJ = containerJ.advanceUntil(currentKey, containersPos[j] - 1);
                if (posJ == containerJ.size()) {
                    return true;
                }
                containersPos[j] = posJ;
                char keyJ = containerJ.getKeyAtIndex(posJ);
                if (keyJ == currentKey) continue;
                if ((firstI = firstContainer.advanceUntil(keyJ, firstI)) >= firstContainer.size()) {
                    return true;
                }
                andOnContainer = false;
                --firstI;
                break;
            }
            if (!andOnContainer) continue;
            MappeableContainer c = firstContainer.getContainerAtIndex(firstI).clone();
            for (int i = 1; i < numBitmaps; ++i) {
                MappeableContainer temp = c.iand(bitmaps[i].highLowContainer.getContainerAtIndex(containersPos[i]));
                if (temp.isEmpty()) {
                    c = null;
                    break;
                }
                if (temp == c) continue;
                c = temp;
            }
            if (c == null || RoaringBufferFastAggregation.forEach(currentKey, c, cb)) continue;
            return false;
        }
        return true;
    }

    private static boolean naive_and(ImmutableRoaringBitmap bitmap1, ImmutableRoaringBitmap bitmap2, OlapBitmapCallback cb) {
        MutableRoaringBitmap answer;
        if (bitmap1.highLowContainer.size() <= bitmap2.highLowContainer.size()) {
            answer = bitmap1.toMutableRoaringBitmap();
            answer.and(bitmap2);
        } else {
            answer = bitmap2.toMutableRoaringBitmap();
            answer.and(bitmap1);
        }
        PointableRoaringArray hl = answer.highLowContainer;
        int size = hl.size();
        for (int i = 0; i < size; ++i) {
            if (RoaringBufferFastAggregation.forEach(hl.getKeyAtIndex(i), hl.getContainerAtIndex(i), cb)) continue;
            return false;
        }
        return true;
    }

    private static boolean workShyAnd(ImmutableRoaringBitmap[] bitmaps, OlapBitmapCallback cb) {
        Arrays.sort(bitmaps, Comparator.comparingInt(a -> a.highLowContainer.size()));
        int[] indexed = new int[bitmaps.length];
        PointableRoaringArray smallContainer = bitmaps[0].highLowContainer;
        int smallContainerSize = smallContainer.size();
        for (int i = 0; i < smallContainerSize; ++i) {
            char key2 = smallContainer.getKeyAtIndex(i);
            int index = -1;
            for (int j = 1; j < bitmaps.length; ++j) {
                PointableRoaringArray jContainer = bitmaps[j].highLowContainer;
                index = jContainer.getIndex(key2);
                if (index < 0) {
                    int insertPos = -index - 1;
                    if (insertPos >= jContainer.size()) {
                        return true;
                    }
                    char nextKey = jContainer.getKeyAtIndex(insertPos);
                    i = smallContainer.advanceUntil(nextKey, i) - 1;
                    break;
                }
                indexed[j] = index;
            }
            if (index < 0) continue;
            MappeableContainer c1 = smallContainer.getContainerAtIndex(i);
            MappeableContainer res = null;
            boolean resIsEmpty = false;
            for (int j = 1; j < indexed.length; ++j) {
                int indexJ = indexed[j];
                MappeableContainer cont = bitmaps[j].highLowContainer.getContainerAtIndex(indexJ);
                resIsEmpty = (res = res == null ? c1.and(cont) : res.and(cont)).isEmpty();
                if (resIsEmpty) break;
            }
            if (resIsEmpty || RoaringBufferFastAggregation.forEach(key2, res = res.repairAfterLazy(), cb)) continue;
            return false;
        }
        return true;
    }

    private static boolean forEach(char key, MappeableContainer container, OlapBitmapCallback cb) {
        int high = key << 16;
        if (container instanceof MappeableBitmapContainer) {
            MappeableBitmapContainer bitmapContainer = (MappeableBitmapContainer)container;
            return RoaringBufferFastAggregation.forEachBitmapContainer(cb, bitmapContainer, high);
        }
        if (container instanceof MappeableRunContainer) {
            MappeableRunContainer runContainer = (MappeableRunContainer)container;
            return RoaringBufferFastAggregation.forEachRunContainer(cb, runContainer, high);
        }
        if (container instanceof MappeableArrayContainer) {
            MappeableArrayContainer arrayContainer = (MappeableArrayContainer)container;
            return RoaringBufferFastAggregation.forEachArrayContainer(cb, arrayContainer, high);
        }
        throw new CdShouldNotBeHereProgrammingException(container.getClass().getName());
    }

    private static boolean forEachArrayContainer(OlapBitmapCallback cb, MappeableArrayContainer arrayContainer, int high) {
        CharBuffer content = arrayContainer.content;
        int cardinality = arrayContainer.cardinality;
        if (BufferUtil.isBackedBySimpleArray(content)) {
            char[] c = content.array();
            for (int k = 0; k < cardinality; ++k) {
                if (cb.onPoint(c[k] & 0xFFFF | high)) continue;
                return false;
            }
        } else {
            for (int k = 0; k < cardinality; ++k) {
                if (cb.onPoint(content.get(k) & 0xFFFF | high)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean forEachBitmapContainer(OlapBitmapCallback cb, MappeableBitmapContainer bitmapContainer, int high) {
        LongBuffer bitmap = bitmapContainer.bitmap;
        if (BufferUtil.isBackedBySimpleArray(bitmap)) {
            long[] b = bitmap.array();
            for (int x = 0; x < b.length; ++x) {
                long w = b[x];
                if (!cb.onBitmap(cb, x * 64 | high, w)) continue;
                return false;
            }
        } else {
            int l = bitmap.limit();
            for (int x = 0; x < l; ++x) {
                long w = bitmap.get(x);
                if (!cb.onBitmap(cb, x * 64 | high, w)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean forEachRunContainer(OlapBitmapCallback cb, MappeableRunContainer runContainer, int high) {
        for (int i = 0; i < runContainer.numberOfRuns(); ++i) {
            int end;
            int start = high | runContainer.getValue(i);
            if (cb.onRange(start, end = start + runContainer.getLength(i) + 1)) continue;
            return false;
        }
        return true;
    }

    public static class QuickForCjNonEmpty {
        private final Integer[] containerIndices;
        private final MappeableContainer[] containers;
        private final int minKey;

        public QuickForCjNonEmpty(ImmutableRoaringBitmap b1) {
            int maxKey = -1;
            int _minKey = Integer.MAX_VALUE;
            HashMap<Character, Integer> indices = new HashMap<Character, Integer>();
            for (int index1 = 0; index1 < b1.highLowContainer.size(); ++index1) {
                char key = b1.highLowContainer.getKeyAtIndex(index1);
                indices.put(Character.valueOf(key), index1);
                maxKey = Math.max(maxKey, key);
                _minKey = Math.min(_minKey, key);
            }
            this.minKey = _minKey;
            this.containerIndices = new Integer[maxKey - this.minKey + 1];
            this.containers = new MappeableContainer[b1.highLowContainer.size()];
            for (Map.Entry entry : indices.entrySet()) {
                Integer index;
                int key = ((Character)entry.getKey()).charValue() - this.minKey;
                this.containerIndices[key] = index = (Integer)entry.getValue();
                this.containers[index.intValue()] = b1.highLowContainer.getContainerAtIndex(index);
            }
        }

        public boolean and(ImmutableRoaringBitmap b2, OlapBitmapCallback cb) {
            for (int index2 = 0; index2 < b2.highLowContainer.size(); ++index2) {
                MappeableContainer c2;
                MappeableContainer c1;
                MappeableContainer and;
                Integer index1;
                char key2 = b2.highLowContainer.getKeyAtIndex(index2);
                int containerIndex = key2 - this.minKey;
                Integer n = index1 = containerIndex < this.containerIndices.length && containerIndex >= 0 ? this.containerIndices[containerIndex] : null;
                if (index1 == null || (and = (c1 = this.containers[index1]).and(c2 = b2.highLowContainer.getContainerAtIndex(index2))).isEmpty() || RoaringBufferFastAggregation.forEach(key2, and = and.repairAfterLazy(), cb)) continue;
                return false;
            }
            return true;
        }
    }
}

