/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import crazydev.common.system.CdRamUsageEstimator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.AppendableStorage;
import org.roaringbitmap.InvalidRoaringFormat;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class MutableRoaringArray
implements Cloneable,
PointableRoaringArray,
AppendableStorage<MappeableContainer> {
    static final short SERIAL_COOKIE_NO_RUNCONTAINER = 12346;
    static final short SERIAL_COOKIE = 12347;
    static final int NO_OFFSET_THRESHOLD = 4;
    private static final int INITIAL_CAPACITY = 4;
    private static long SHALLOW_SIZE_OF = -1L;
    char[] keys = null;
    MappeableContainer[] values = null;
    int size = 0;

    MutableRoaringArray() {
        this(4);
    }

    public MutableRoaringArray(int initialCapacity) {
        this(new char[initialCapacity], new MappeableContainer[initialCapacity], 0);
    }

    MutableRoaringArray(char[] keys, MappeableContainer[] values, int size) {
        this.keys = keys;
        this.values = values;
        this.size = size;
    }

    public long sizeOf() {
        long size = 0L;
        size += SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.sizeOf((char[])this.keys);
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.values);
        for (MappeableContainer container : this.values) {
            if (container == null) continue;
            size += container.sizeOf();
        }
        return size;
    }

    @Override
    public int advanceUntil(char x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || this.keys[lower] >= x) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && this.keys[lower + spansize] < x) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.keys[upper] == x) {
            return upper;
        }
        if (this.keys[upper] < x) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.keys[mid] == x) {
                return mid;
            }
            if (this.keys[mid] < x) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    @Override
    public void append(char key, MappeableContainer value) {
        if (this.size > 0 && key < this.keys[this.size - 1]) {
            throw new IllegalArgumentException("append only: " + key + " < " + this.keys[this.size - 1]);
        }
        this.extendArray(1);
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
    }

    void append(MutableRoaringArray appendage) {
        assert (this.size == 0 || appendage.size == 0 || this.keys[this.size - 1] < appendage.keys[0]);
        if (appendage.size != 0 && this.size != 0) {
            this.keys = Arrays.copyOf(this.keys, this.size + appendage.size);
            this.values = Arrays.copyOf(this.values, this.size + appendage.size);
            System.arraycopy(appendage.keys, 0, this.keys, this.size, appendage.size);
            System.arraycopy(appendage.values, 0, this.values, this.size, appendage.size);
            this.size += appendage.size;
        } else if (this.size == 0 && appendage.size != 0) {
            this.keys = Arrays.copyOf(appendage.keys, appendage.keys.length);
            this.values = Arrays.copyOf(appendage.values, appendage.values.length);
            this.size = appendage.size;
        }
    }

    @Override
    public Boolean validate() {
        for (int k = 0; k < this.size; ++k) {
            if (k > 0 && this.getKeyAtIndex(k - 1) >= this.getKeyAtIndex(k)) {
                return false;
            }
            MappeableContainer container = this.getContainerAtIndex(k);
            if (container == null) {
                return false;
            }
            if (container.validate().booleanValue()) continue;
            return false;
        }
        return true;
    }

    void appendCopiesAfter(PointableRoaringArray highLowContainer, char beforeStart) {
        int startLocation = highLowContainer.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(highLowContainer.size() - startLocation);
        for (int i = startLocation; i < highLowContainer.size(); ++i) {
            this.keys[this.size] = highLowContainer.getKeyAtIndex(i);
            this.values[this.size] = highLowContainer.getContainerAtIndex(i).clone();
            ++this.size;
        }
    }

    void appendCopiesUntil(PointableRoaringArray highLowContainer, char stoppingKey) {
        char stopKey = stoppingKey;
        MappeableContainerPointer cp = highLowContainer.getContainerPointer();
        while (cp.hasContainer() && cp.key() < stopKey) {
            this.extendArray(1);
            this.keys[this.size] = cp.key();
            this.values[this.size] = cp.getContainer().clone();
            ++this.size;
            cp.advance();
        }
    }

    void appendCopy(PointableRoaringArray highLowContainer, int startingIndex, int end) {
        this.extendArray(end - startingIndex);
        for (int i = startingIndex; i < end; ++i) {
            this.keys[this.size] = highLowContainer.getKeyAtIndex(i);
            this.values[this.size] = highLowContainer.getContainerAtIndex(i).clone();
            ++this.size;
        }
    }

    void appendCopy(char key, MappeableContainer value) {
        this.extendArray(1);
        this.keys[this.size] = key;
        this.values[this.size] = value.clone();
        ++this.size;
    }

    private int binarySearch(int begin, int end, char key) {
        return Util.unsignedBinarySearch(this.keys, begin, end, key);
    }

    private void clear() {
        this.keys = null;
        this.values = null;
        this.size = 0;
    }

    public void trim() {
        this.keys = Arrays.copyOf(this.keys, this.size);
        for (MappeableContainer c : this.values = Arrays.copyOf(this.values, this.size)) {
            c.trim();
        }
    }

    @Override
    public MutableRoaringArray clone() {
        try {
            MutableRoaringArray sa = (MutableRoaringArray)super.clone();
            sa.keys = Arrays.copyOf(this.keys, this.size);
            sa.values = Arrays.copyOf(this.values, this.size);
            for (int k = 0; k < this.size; ++k) {
                sa.values[k] = sa.values[k].clone();
            }
            sa.size = this.size;
            return sa;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    void copyRange(int begin, int end, int newBegin) {
        int range = end - begin;
        System.arraycopy(this.keys, begin, this.keys, newBegin, range);
        System.arraycopy(this.values, begin, this.values, newBegin, range);
    }

    public void deserialize(ByteBuffer bbf) {
        int k;
        boolean hasrun;
        this.clear();
        ByteBuffer buffer = bbf.order() == ByteOrder.LITTLE_ENDIAN ? bbf : bbf.slice().order(ByteOrder.LITTLE_ENDIAN);
        int cookie = buffer.getInt();
        if ((cookie & 0xFFFF) != 12347 && cookie != 12346) {
            throw new InvalidRoaringFormat("I failed to find one of the right cookies. " + cookie);
        }
        boolean hasRunContainers = (cookie & 0xFFFF) == 12347;
        int n = this.size = hasRunContainers ? (cookie >>> 16) + 1 : buffer.getInt();
        if (this.size > 65536) {
            throw new InvalidRoaringFormat("Size too large");
        }
        if (this.keys == null || this.keys.length < this.size) {
            this.keys = new char[this.size];
            this.values = new MappeableContainer[this.size];
        }
        byte[] bitmapOfRunContainers = null;
        boolean bl = hasrun = (cookie & 0xFFFF) == 12347;
        if (hasrun) {
            bitmapOfRunContainers = new byte[(this.size + 7) / 8];
            buffer.get(bitmapOfRunContainers);
        }
        char[] keys = new char[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = buffer.getChar();
            cardinalities[k] = '\u0001' + buffer.getChar();
            boolean bl2 = isBitmap[k] = cardinalities[k] > 4096;
            if (bitmapOfRunContainers == null || (bitmapOfRunContainers[k / 8] & 1 << (k & 7)) == 0) continue;
            isBitmap[k] = false;
        }
        if (!hasrun || this.size >= 4) {
            buffer.position(buffer.position() + this.size * 4);
        }
        for (k = 0; k < this.size; ++k) {
            MappeableContainer container;
            if (isBitmap[k]) {
                long[] array = new long[1024];
                buffer.asLongBuffer().get(array);
                container = new MappeableBitmapContainer(LongBuffer.wrap(array), cardinalities[k]);
                buffer.position(buffer.position() + 8192);
            } else if (bitmapOfRunContainers != null && (bitmapOfRunContainers[k / 8] & 1 << (k & 7)) != 0) {
                char nbrruns = buffer.getChar();
                int length = 2 * nbrruns;
                char[] array = new char[length];
                buffer.asCharBuffer().get(array);
                container = new MappeableRunContainer(CharBuffer.wrap(array), (int)nbrruns);
                buffer.position(buffer.position() + length * 2);
            } else {
                int cardinality = cardinalities[k];
                char[] array = new char[cardinality];
                buffer.asCharBuffer().get(array);
                container = new MappeableArrayContainer(CharBuffer.wrap(array), cardinality);
                buffer.position(buffer.position() + cardinality * 2);
            }
            this.keys[k] = keys[k];
            this.values[k] = container;
        }
    }

    private void extendArray(int k) {
        if (this.size + k > this.keys.length) {
            int newCapacity = this.keys.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.keys = Arrays.copyOf(this.keys, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }
    }

    @Override
    public int getCardinality(int i) {
        return this.getContainerAtIndex(i).getCardinality();
    }

    @Override
    public int getContainerIndex(char x) {
        return this.binarySearch(0, this.size, x);
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        return this.values[i];
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return this.getContainerPointer(0);
    }

    @Override
    public MappeableContainerPointer getContainerPointer(final int startIndex) {
        return new MappeableContainerPointer(){
            int k;
            final /* synthetic */ MutableRoaringArray this$0;
            {
                MutableRoaringArray mutableRoaringArray = this$0;
                Objects.requireNonNull(mutableRoaringArray);
                this.this$0 = mutableRoaringArray;
                this.k = startIndex;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return this.key() - o.key();
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return this.getContainer().getCardinality();
            }

            @Override
            @Nullable
            public MappeableContainer getContainer() {
                if (this.k >= this.this$0.size) {
                    return null;
                }
                return this.this$0.values[this.k];
            }

            @Override
            public boolean hasContainer() {
                return 0 <= this.k && this.k < this.this$0.size;
            }

            @Override
            public boolean isBitmapContainer() {
                return this.getContainer() instanceof MappeableBitmapContainer;
            }

            @Override
            public boolean isRunContainer() {
                return this.getContainer() instanceof MappeableRunContainer;
            }

            @Override
            public char key() {
                return this.this$0.keys[this.k];
            }

            @Override
            public void previous() {
                --this.k;
            }
        };
    }

    @Override
    public int getIndex(char x) {
        if (this.size == 0 || this.keys[this.size - 1] == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    @Override
    public char getKeyAtIndex(int i) {
        return this.keys[i];
    }

    @Override
    public boolean hasRunCompression() {
        for (int k = 0; k < this.size; ++k) {
            MappeableContainer ck = this.values[k];
            if (!(ck instanceof MappeableRunContainer)) continue;
            return true;
        }
        return false;
    }

    private int headerSize() {
        if (this.hasRunCompression()) {
            if (this.size < 4) {
                return 4 + (this.size + 7) / 8 + 4 * this.size;
            }
            return 4 + (this.size + 7) / 8 + 8 * this.size;
        }
        return 8 + 8 * this.size;
    }

    void insertNewKeyValueAt(int i, char key, MappeableContainer value) {
        this.extendArray(1);
        System.arraycopy(this.keys, i, this.keys, i + 1, this.size - i);
        System.arraycopy(this.values, i, this.values, i + 1, this.size - i);
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
    }

    void removeAtIndex(int i) {
        System.arraycopy(this.keys, i + 1, this.keys, i, this.size - i - 1);
        this.keys[this.size - 1] = '\u0000';
        System.arraycopy(this.values, i + 1, this.values, i, this.size - i - 1);
        this.values[this.size - 1] = null;
        --this.size;
    }

    private void removeIndexRange(int begin, int end) {
        if (end <= begin) {
            return;
        }
        int range = end - begin;
        System.arraycopy(this.keys, end, this.keys, begin, this.size - end);
        System.arraycopy(this.values, end, this.values, begin, this.size - end);
        for (int i = 1; i <= range; ++i) {
            this.keys[this.size - i] = '\u0000';
            this.values[this.size - i] = null;
        }
        this.size -= range;
    }

    void replaceKeyAndContainerAtIndex(int i, char key, MappeableContainer c) {
        this.keys[i] = key;
        this.values[i] = c;
    }

    void resize(int newLength) {
        Arrays.fill(this.keys, newLength, this.size, '\u0000');
        Arrays.fill(this.values, newLength, this.size, null);
        this.size = newLength;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int k;
        int startOffset;
        ByteBuffer buf = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        boolean hasrun = this.hasRunCompression();
        if (hasrun) {
            buf.putInt(0x303B | this.size - 1 << 16);
            int offset = buf.position();
            for (int i = 0; i < this.size; i += 8) {
                int runMarker = 0;
                for (int j = 0; j < 8 && i + j < this.size; ++j) {
                    if (!(this.values[i + j] instanceof MappeableRunContainer)) continue;
                    runMarker |= 1 << j;
                }
                buf.put((byte)runMarker);
            }
            int runMarkersLength = buf.position() - offset;
            startOffset = this.size < 4 ? 4 + 4 * this.size + runMarkersLength : 4 + 8 * this.size + runMarkersLength;
        } else {
            buf.putInt(12346);
            buf.putInt(this.size);
            startOffset = 8 + 4 * this.size + 4 * this.size;
        }
        for (k = 0; k < this.size; ++k) {
            buf.putChar(this.keys[k]);
            buf.putChar((char)(this.values[k].getCardinality() - 1));
        }
        if (!hasrun || this.size >= 4) {
            for (k = 0; k < this.size; ++k) {
                buf.putInt(startOffset);
                startOffset += this.values[k].getArraySizeInBytes(true);
            }
        }
        for (k = 0; k < this.size; ++k) {
            this.values[k].writeArray(buf, true);
        }
        if (buf != buffer) {
            buffer.position(buffer.position() + buf.position());
        }
    }

    @Override
    public int serializedSizeInBytes(boolean isForBitmapSerialize) {
        int count = this.headerSize();
        for (int k = 0; k < this.size; ++k) {
            count += this.values[k].getArraySizeInBytes(isForBitmapSerialize);
        }
        return count;
    }

    void setContainerAtIndex(int i, MappeableContainer c) {
        this.values[i] = c;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsForContainerAtIndex(int i, char x) {
        return this.getContainerAtIndex(i).contains(x);
    }
}

