/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.nio.ByteBuffer;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.WordStorage;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;

public abstract class MappeableContainer
implements Iterable<Character>,
Cloneable,
WordStorage<MappeableContainer> {
    public static MappeableContainer rangeOfOnes(int start, int last) {
        int arrayContainerOverRunThreshold = 2;
        int cardinality = last - start;
        if (cardinality <= 2) {
            return new MappeableArrayContainer(start, last);
        }
        return new MappeableRunContainer(start, last);
    }

    public abstract MappeableContainer add(int var1, int var2);

    @Override
    public abstract MappeableContainer add(char var1);

    @Override
    public abstract boolean isEmpty();

    public abstract boolean isFull();

    public abstract MappeableContainer and(MappeableArrayContainer var1);

    public abstract MappeableContainer and(MappeableBitmapContainer var1);

    protected MappeableContainer and(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.and((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.and((MappeableRunContainer)x);
        }
        return this.and((MappeableBitmapContainer)x);
    }

    protected abstract int andCardinality(MappeableArrayContainer var1);

    protected abstract int andCardinality(MappeableBitmapContainer var1);

    protected abstract int andCardinality(MappeableRunContainer var1);

    public int andCardinality(MappeableContainer x) {
        if (this.isEmpty()) {
            return 0;
        }
        if (x.isEmpty()) {
            return 0;
        }
        if (x instanceof MappeableArrayContainer) {
            return this.andCardinality((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return this.andCardinality((MappeableBitmapContainer)x);
        }
        return this.andCardinality((MappeableRunContainer)x);
    }

    public abstract MappeableContainer and(MappeableRunContainer var1);

    public abstract MappeableContainer andNot(MappeableArrayContainer var1);

    public abstract MappeableContainer andNot(MappeableBitmapContainer var1);

    public abstract MappeableContainer andNot(MappeableRunContainer var1);

    public abstract MappeableContainer clone();

    public abstract boolean contains(char var1);

    public abstract boolean intersects(int var1, int var2);

    public abstract MappeableContainer flip(char var1);

    public abstract int getArraySizeInBytes(boolean var1);

    public abstract int getCardinality();

    public abstract PeekableCharIterator getCharIterator();

    public abstract void forEach(char var1, IntConsumer var2);

    public abstract MappeableContainer iadd(int var1, int var2);

    public abstract MappeableContainer iand(MappeableArrayContainer var1);

    public abstract MappeableContainer iand(MappeableBitmapContainer var1);

    protected MappeableContainer iand(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.iand((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.iand((MappeableRunContainer)x);
        }
        return this.iand((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer iand(MappeableRunContainer var1);

    protected MappeableContainer iandNot(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.iandNot((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.iandNot((MappeableRunContainer)x);
        }
        return this.iandNot((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer iandNot(MappeableArrayContainer var1);

    public abstract MappeableContainer iandNot(MappeableRunContainer var1);

    public abstract MappeableContainer iandNot(MappeableBitmapContainer var1);

    public abstract MappeableContainer inot(int var1, int var2);

    public abstract boolean intersects(MappeableArrayContainer var1);

    public abstract boolean intersects(MappeableBitmapContainer var1);

    public boolean intersects(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.intersects((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return this.intersects((MappeableBitmapContainer)x);
        }
        return this.intersects((MappeableRunContainer)x);
    }

    public abstract boolean intersects(MappeableRunContainer var1);

    public abstract MappeableContainer ior(MappeableArrayContainer var1);

    public abstract MappeableContainer ior(MappeableBitmapContainer var1);

    protected MappeableContainer ior(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.ior((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.ior((MappeableRunContainer)x);
        }
        return this.ior((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer ior(MappeableRunContainer var1);

    protected abstract boolean isArrayBacked();

    public MappeableContainer lazyIOR(MappeableContainer x) {
        if (this instanceof MappeableArrayContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableArrayContainer)this).lazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableArrayContainer)this);
            }
            return ((MappeableRunContainer)x).lazyor((MappeableArrayContainer)this);
        }
        if (this instanceof MappeableRunContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableRunContainer)this).ilazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableRunContainer)this);
            }
            return this.ior((MappeableRunContainer)x);
        }
        if (x instanceof MappeableArrayContainer) {
            return ((MappeableBitmapContainer)this).ilazyor((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return ((MappeableBitmapContainer)this).ilazyor((MappeableBitmapContainer)x);
        }
        return ((MappeableBitmapContainer)this).ilazyor((MappeableRunContainer)x);
    }

    public MappeableContainer lazyOR(MappeableContainer x) {
        if (this instanceof MappeableArrayContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableArrayContainer)this).lazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableArrayContainer)this);
            }
            return ((MappeableRunContainer)x).lazyor((MappeableArrayContainer)this);
        }
        if (this instanceof MappeableRunContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableRunContainer)this).lazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableRunContainer)this);
            }
            return this.or((MappeableRunContainer)x);
        }
        if (x instanceof MappeableArrayContainer) {
            return ((MappeableBitmapContainer)this).lazyor((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return ((MappeableBitmapContainer)this).lazyor((MappeableBitmapContainer)x);
        }
        return ((MappeableBitmapContainer)this).lazyor((MappeableRunContainer)x);
    }

    public abstract MappeableContainer not(int var1, int var2);

    abstract int numberOfRuns();

    public abstract MappeableContainer or(MappeableArrayContainer var1);

    public abstract MappeableContainer or(MappeableBitmapContainer var1);

    protected MappeableContainer or(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.or((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.or((MappeableRunContainer)x);
        }
        return this.or((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer or(MappeableRunContainer var1);

    public abstract MappeableContainer repairAfterLazy();

    @Override
    public abstract MappeableContainer runOptimize();

    public abstract int serializedSizeInBytes();

    public abstract void trim();

    public abstract void writeArray(ByteBuffer var1, boolean var2);

    public abstract MappeableBitmapContainer toBitmapContainer();

    public abstract Boolean validate();

    public abstract Type getType();

    public abstract long sizeOf();

    public static MappeableContainer build(int typeOrdinal, ByteBuffer buffer) {
        return switch (typeOrdinal) {
            case 0 -> new MappeableArrayContainer(buffer);
            case 1 -> new MappeableRunContainer(buffer);
            case 2 -> new MappeableBitmapContainer(buffer);
            default -> throw new RuntimeException("Unsupported type ordinal : " + typeOrdinal);
        };
    }

    public static enum Type {
        ARRAY,
        RUN,
        BITMAP;

    }
}

