/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import crazydev.common.system.CdRamUsageEstimator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.roaringbitmap.CharIterator;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainerCharIterator;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.RawArrayContainerCharIterator;

public final class MappeableArrayContainer
extends MappeableContainer
implements Cloneable {
    private static long SHALLOW_SIZE_OF = -1L;
    private static long CHAR_BUFFER_SHALLOW_SIZE_OF = -1L;
    static final int DEFAULT_MAX_SIZE = 4096;
    private static final int DEFAULT_INIT_SIZE = 4;
    private static final int ARRAY_LAZY_LOWERBOUND = 1024;
    int cardinality = 0;
    CharBuffer content;

    public MappeableArrayContainer(ByteBuffer buffer) {
        this.content = buffer.asCharBuffer();
        this.cardinality = this.content.limit();
    }

    public MappeableArrayContainer() {
        this(4);
    }

    public MappeableArrayContainer(int capacity) {
        this.content = CharBuffer.allocate(capacity);
    }

    public MappeableArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun;
        this.content = CharBuffer.allocate(valuesInRange);
        char[] sarray = this.content.array();
        for (int i = 0; i < valuesInRange; ++i) {
            sarray[i] = (char)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    private MappeableArrayContainer(int newCard, CharBuffer newContent) {
        this.cardinality = newCard;
        CharBuffer tmp = newContent.duplicate();
        this.content = CharBuffer.allocate(Math.max(newCard, tmp.limit()));
        tmp.rewind();
        this.content.put(tmp);
    }

    public MappeableArrayContainer(CharBuffer array, int cardinality) {
        if (array.limit() != cardinality) {
            throw new RuntimeException("Mismatch between buffer and cardinality");
        }
        this.cardinality = cardinality;
        this.content = array;
    }

    @Override
    public long sizeOf() {
        long size = 0L;
        size += SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CHAR_BUFFER_SHALLOW_SIZE_OF != -1L ? CHAR_BUFFER_SHALLOW_SIZE_OF : (CHAR_BUFFER_SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)CharBuffer.allocate(0)));
        return size += (long)this.serializedSizeInBytes();
    }

    private static int getArraySizeInBytes(int cardinality) {
        return cardinality * 2;
    }

    static int serializedSizeInBytes(int cardinality) {
        return cardinality * 2 + 2;
    }

    public static MappeableArrayContainer empty() {
        return new MappeableArrayContainer();
    }

    @Override
    public MappeableContainer add(int begin, int end) {
        int indexend;
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (char)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = BufferUtil.unsignedBinarySearch(this.content, indexstart, this.cardinality, (char)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            MappeableBitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(newcardinality, this.content);
        if (!BufferUtil.isBackedBySimpleArray(answer.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        BufferUtil.arraycopy(this.content, indexend, answer.content, indexstart + rangelength, this.cardinality - indexend);
        char[] answerarray = answer.content.array();
        for (int k = 0; k < rangelength; ++k) {
            answerarray[k + indexstart] = (char)(begin + k);
        }
        answer.cardinality = newcardinality;
        return answer;
    }

    @Override
    public MappeableContainer add(char x) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            char[] sarray = this.content.array();
            if (this.cardinality == 0 || this.cardinality > 0 && x > sarray[this.cardinality - 1]) {
                if (this.cardinality >= 4096) {
                    return this.toBitmapContainer().add(x);
                }
                if (this.cardinality >= sarray.length) {
                    this.increaseCapacity();
                    sarray = this.content.array();
                }
                sarray[this.cardinality++] = x;
            } else {
                int loc = Util.unsignedBinarySearch(sarray, 0, this.cardinality, x);
                if (loc < 0) {
                    if (this.cardinality >= 4096) {
                        return this.toBitmapContainer().add(x);
                    }
                    if (this.cardinality >= sarray.length) {
                        this.increaseCapacity();
                        sarray = this.content.array();
                    }
                    System.arraycopy(sarray, -loc - 1, sarray, -loc, this.cardinality + loc + 1);
                    sarray[-loc - 1] = x;
                    ++this.cardinality;
                }
            }
        } else {
            int loc;
            if (this.cardinality == 0 || this.cardinality > 0 && x > this.content.get(this.cardinality - 1)) {
                if (this.cardinality >= 4096) {
                    return this.toBitmapContainer().add(x);
                }
                if (this.cardinality >= this.content.limit()) {
                    this.increaseCapacity();
                }
                this.content.put(this.cardinality++, x);
            }
            if ((loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x)) < 0) {
                if (this.cardinality >= 4096) {
                    MappeableBitmapContainer a = this.toBitmapContainer();
                    a.add(x);
                    return a;
                }
                if (this.cardinality >= this.content.limit()) {
                    this.increaseCapacity();
                }
                for (int k = this.cardinality; k > -loc - 1; --k) {
                    this.content.put(k, this.content.get(k - 1));
                }
                this.content.put(-loc - 1, x);
                ++this.cardinality;
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    @Override
    public Boolean validate() {
        if (this.cardinality <= 0) {
            return false;
        }
        if (this.cardinality > 4096) {
            return false;
        }
        for (int k = 1; k < this.cardinality; ++k) {
            if (this.content.get(k - 1) < this.content.get(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MappeableContainer.Type getType() {
        return MappeableContainer.Type.ARRAY;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    private int advance(CharIterator it) {
        if (it.hasNext()) {
            return it.next();
        }
        return -1;
    }

    @Override
    public MappeableArrayContainer and(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int desiredCapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        MappeableArrayContainer answer = new MappeableArrayContainer(desiredCapacity);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedIntersect2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer x) {
        return x.and(this);
    }

    @Override
    public MappeableContainer and(MappeableRunContainer value2) {
        return value2.and(this);
    }

    @Override
    public MappeableArrayContainer andNot(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int desiredCapacity = value1.getCardinality();
        MappeableArrayContainer answer = new MappeableArrayContainer(desiredCapacity);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedDifference(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedDifference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableArrayContainer andNot(MappeableBitmapContainer value2) {
        MappeableArrayContainer answer = new MappeableArrayContainer(this.content.limit());
        int pos = 0;
        char[] sarray = answer.content.array();
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            char[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                char v;
                sarray[pos] = v = c[k];
                pos += 1 - (int)value2.bitValue(v);
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                char v;
                sarray[pos] = v = this.content.get(k);
                pos += 1 - (int)value2.bitValue(v);
            }
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public MappeableContainer andNot(MappeableRunContainer x) {
        if (x.numberOfRuns() == 0) {
            return this.clone();
        }
        if (x.isFull()) {
            return MappeableArrayContainer.empty();
        }
        int write = 0;
        int read = 0;
        MappeableArrayContainer answer = new MappeableArrayContainer(this.cardinality);
        for (int i = 0; i < x.numberOfRuns() && read < this.cardinality; ++i) {
            char runStart = x.getValue(i);
            int runEnd = runStart + x.getLength(i);
            if (this.content.get(read) > runEnd) continue;
            int firstInRun = BufferUtil.iterateUntil(this.content, read, this.cardinality, runStart);
            int toWrite = firstInRun - read;
            BufferUtil.arraycopy(this.content, read, answer.content, write, toWrite);
            write += toWrite;
            read = BufferUtil.iterateUntil(this.content, firstInRun, this.cardinality, runEnd + 1);
        }
        BufferUtil.arraycopy(this.content, read, answer.content, write, this.cardinality - read);
        answer.cardinality = write += this.cardinality - read;
        return answer;
    }

    @Override
    public MappeableArrayContainer clone() {
        return new MappeableArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean contains(char x) {
        return BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    public static boolean contains(ByteBuffer buf, int position, char x, int cardinality) {
        return BufferUtil.unsignedBinarySearch(buf, position, 0, cardinality, x) >= 0;
    }

    private void emit(char val) {
        if (this.cardinality == this.content.limit()) {
            this.increaseCapacity(true);
        }
        this.content.put(this.cardinality++, val);
    }

    @Override
    public MappeableContainer flip(char x) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            char[] sarray = this.content.array();
            int loc = Util.unsignedBinarySearch(sarray, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= 4096) {
                    MappeableBitmapContainer a = this.toBitmapContainer();
                    a.add(x);
                    return a;
                }
                if (this.cardinality >= sarray.length) {
                    this.increaseCapacity();
                    sarray = this.content.array();
                }
                System.arraycopy(sarray, -loc - 1, sarray, -loc, this.cardinality + loc + 1);
                sarray[-loc - 1] = x;
                ++this.cardinality;
            } else {
                System.arraycopy(sarray, loc + 1, sarray, loc, this.cardinality - loc - 1);
                --this.cardinality;
            }
            return this;
        }
        int loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= 4096) {
                MappeableBitmapContainer a = this.toBitmapContainer();
                a.add(x);
                return a;
            }
            if (this.cardinality >= this.content.limit()) {
                this.increaseCapacity();
            }
            for (int k = this.cardinality; k > -loc - 1; --k) {
                this.content.put(k, this.content.get(k - 1));
            }
            this.content.put(-loc - 1, x);
            ++this.cardinality;
        } else {
            for (int k = loc + 1; k < this.cardinality; --k) {
                this.content.put(k - 1, this.content.get(k));
            }
            --this.cardinality;
        }
        return this;
    }

    @Override
    public int getArraySizeInBytes(boolean isForBitmapSerialize) {
        return MappeableArrayContainer.getArraySizeInBytes(this.cardinality);
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public PeekableCharIterator getCharIterator() {
        if (this.isArrayBacked()) {
            return new RawArrayContainerCharIterator(this);
        }
        return new MappeableArrayContainerCharIterator(this);
    }

    @Override
    public MappeableContainer iadd(int begin, int end) {
        int indexend;
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (char)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = BufferUtil.unsignedBinarySearch(this.content, indexstart, this.cardinality, (char)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            MappeableBitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        if (newcardinality >= this.content.limit()) {
            CharBuffer destination = CharBuffer.allocate(newcardinality);
            BufferUtil.arraycopy(this.content, 0, destination, 0, indexstart);
            if (BufferUtil.isBackedBySimpleArray(this.content)) {
                char[] destinationarray = destination.array();
                for (int k = 0; k < rangelength; ++k) {
                    destinationarray[k + indexstart] = (char)(begin + k);
                }
            } else {
                for (int k = 0; k < rangelength; ++k) {
                    destination.put(k + indexstart, (char)(begin + k));
                }
            }
            BufferUtil.arraycopy(this.content, indexend, destination, indexstart + rangelength, this.cardinality - indexend);
            this.content = destination;
        } else {
            BufferUtil.arraycopy(this.content, indexend, this.content, indexstart + rangelength, this.cardinality - indexend);
            if (BufferUtil.isBackedBySimpleArray(this.content)) {
                char[] contentarray = this.content.array();
                for (int k = 0; k < rangelength; ++k) {
                    contentarray[k + indexstart] = (char)(begin + k);
                }
            } else {
                for (int k = 0; k < rangelength; ++k) {
                    this.content.put(k + indexstart, (char)(begin + k));
                }
            }
        }
        this.cardinality = newcardinality;
        return this;
    }

    @Override
    public MappeableArrayContainer iand(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        if (!BufferUtil.isBackedBySimpleArray(value1.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        value1.cardinality = BufferUtil.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content.array());
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            char v = this.content.get(k);
            this.content.put(pos, v);
            pos += (int)value2.bitValue(v);
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableRunContainer value2) {
        PeekableCharIterator it = value2.getCharIterator();
        int removed = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            it.advanceIfNeeded(this.content.get(i));
            if (it.peekNext() == this.content.get(i)) {
                this.content.put(i - removed, this.content.get(i));
                continue;
            }
            ++removed;
        }
        this.cardinality -= removed;
        return this;
    }

    @Override
    public MappeableArrayContainer iandNot(MappeableArrayContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        this.cardinality = BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedDifference(this.content.array(), this.getCardinality(), value2.content.array(), value2.getCardinality(), this.content.array()) : BufferUtil.unsignedDifference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content.array());
        return this;
    }

    @Override
    public MappeableArrayContainer iandNot(MappeableBitmapContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        char[] c = this.content.array();
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            char v;
            c[pos] = v = c[k];
            pos += 1 - (int)value2.bitValue(v);
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public MappeableContainer iandNot(MappeableRunContainer value2) {
        PeekableCharIterator it = value2.getCharIterator();
        int removed = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            it.advanceIfNeeded(this.content.get(i));
            if (it.peekNext() != this.content.get(i)) {
                this.content.put(i - removed, this.content.get(i));
                continue;
            }
            ++removed;
        }
        this.cardinality -= removed;
        return this;
    }

    private void increaseCapacity() {
        this.increaseCapacity(false);
    }

    private void increaseCapacity(boolean allowIllegalSize) {
        int newCapacity = this.calculateCapacity();
        if (newCapacity > 4096 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        CharBuffer newContent = CharBuffer.allocate(newCapacity);
        this.content.rewind();
        newContent.put(this.content);
        this.content = newContent;
    }

    private int calculateCapacity() {
        int len = this.content.limit();
        int newCapacity = len == 0 ? 4 : (len < 64 ? len * 2 : (len < 1067 ? len * 3 / 2 : len * 5 / 4));
        return newCapacity;
    }

    private int calculateCapacity(int min) {
        int newCapacity = this.calculateCapacity();
        if (newCapacity < min) {
            newCapacity = min;
        }
        if (newCapacity > 4096) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840) {
            newCapacity = 4096;
        }
        return newCapacity;
    }

    @Override
    public MappeableContainer inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (char)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = BufferUtil.unsignedBinarySearch(this.content, startIndex, this.cardinality, (char)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        CharBuffer buffer = CharBuffer.allocate(newValuesInRange);
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.limit()) {
                if (newCardinality > 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                CharBuffer co = CharBuffer.allocate(newCardinality);
                this.content.rewind();
                co.put(this.content);
                this.content = co;
            }
            for (int pos = this.cardinality - 1; pos > lastIndex; --pos) {
                this.content.put(pos + cardinalityChange, this.content.get(pos));
            }
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                for (int i = startIndex + newValuesInRange; i < newCardinality; ++i) {
                    this.content.put(i, this.content.get(i - cardinalityChange));
                }
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public boolean intersects(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        return BufferUtil.unsignedIntersects(value1.content, value1.getCardinality(), value2.content, value2.getCardinality());
    }

    @Override
    public boolean intersects(MappeableBitmapContainer x) {
        return x.intersects(this);
    }

    @Override
    public boolean intersects(MappeableRunContainer x) {
        return x.intersects(this);
    }

    @Override
    public MappeableContainer ior(MappeableArrayContainer value2) {
        int totalCardinality = this.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            return this.toBitmapContainer().lazyIOR(value2).repairAfterLazy();
        }
        if (totalCardinality >= this.content.limit()) {
            int newCapacity = this.calculateCapacity(totalCardinality);
            CharBuffer destination = CharBuffer.allocate(newCapacity);
            this.cardinality = BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedUnion2by2(this.content.array(), 0, this.cardinality, value2.content.array(), 0, value2.cardinality, destination.array()) : BufferUtil.unsignedUnion2by2(this.content, 0, this.cardinality, value2.content, 0, value2.cardinality, destination.array());
            this.content = destination;
        } else {
            BufferUtil.arraycopy(this.content, 0, this.content, value2.cardinality, this.cardinality);
            this.cardinality = BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedUnion2by2(this.content.array(), value2.cardinality, this.cardinality, value2.content.array(), 0, value2.cardinality, this.content.array()) : BufferUtil.unsignedUnion2by2(this.content, value2.cardinality, this.cardinality, value2.content, 0, value2.cardinality, this.content.array());
        }
        return this;
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer x) {
        return x.or(this);
    }

    @Override
    public MappeableContainer ior(MappeableRunContainer value2) {
        return value2.or(this);
    }

    @Override
    protected boolean isArrayBacked() {
        return BufferUtil.isBackedBySimpleArray(this.content);
    }

    @Override
    public Iterator<Character> iterator() {
        return new Iterator<Character>(this){
            char pos;
            final /* synthetic */ MappeableArrayContainer this$0;
            {
                MappeableArrayContainer mappeableArrayContainer = this$0;
                Objects.requireNonNull(mappeableArrayContainer);
                this.this$0 = mappeableArrayContainer;
                this.pos = '\u0000';
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.this$0.cardinality;
            }

            @Override
            public Character next() {
                char c = this.pos;
                this.pos = (char)(c + '\u0001');
                return Character.valueOf(this.this$0.content.get(c));
            }

            @Override
            public void remove() {
                this.this$0.removeAtIndex(this.pos - '\u0001');
                this.pos = (char)(this.pos - '\u0001');
            }
        };
    }

    void loadData(MappeableBitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        if (!BufferUtil.isBackedBySimpleArray(this.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        Util.fillArray(bitmapContainer.bitmap.array(), this.content.array());
    }

    private void negateRange(CharBuffer buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange < lastRange && inPos <= lastIndex; ++valInRange) {
            if ((char)valInRange != this.content.get(inPos)) {
                buffer.put(outPos++, (char)valInRange);
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastRange) {
            buffer.put(outPos++, (char)valInRange);
            ++valInRange;
        }
        if (outPos != buffer.limit()) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.limit());
        }
        int i = startIndex;
        int len = buffer.limit();
        for (int k = 0; k < len; ++k) {
            char item = buffer.get(k);
            this.content.put(i++, item);
        }
    }

    @Override
    public MappeableContainer not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange >= lastOfRange) {
            return this.clone();
        }
        int startIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (char)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = BufferUtil.unsignedBinarySearch(this.content, startIndex, this.cardinality, (char)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) > 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(newCardinality);
        if (!BufferUtil.isBackedBySimpleArray(answer.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        char[] sarray = answer.content.array();
        for (int i = 0; i < startIndex; ++i) {
            sarray[i] = this.content.get(i);
        }
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange < lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((char)valInRange != this.content.get(inPos)) {
                sarray[outPos++] = (char)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastOfRange) {
            answer.content.put(outPos++, (char)valInRange);
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content.put(outPos++, this.content.get(i));
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    int numberOfRuns() {
        if (this.cardinality == 0) {
            return 0;
        }
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            char[] c = this.content.array();
            int numRuns = 1;
            char oldv = c[0];
            for (int i = 1; i < this.cardinality; ++i) {
                char newv = c[i];
                if (oldv + '\u0001' != newv) {
                    ++numRuns;
                }
                oldv = newv;
            }
            return numRuns;
        }
        int numRuns = 1;
        char previous = this.content.get(0);
        for (int i = 1; i < this.cardinality; ++i) {
            char val = this.content.get(i);
            if (val != previous + '\u0001') {
                ++numRuns;
            }
            previous = val;
        }
        return numRuns;
    }

    @Override
    public MappeableContainer or(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            return this.toBitmapContainer().lazyIOR(value2).repairAfterLazy();
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(totalCardinality);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedUnion2by2(value1.content.array(), 0, value1.getCardinality(), value2.content.array(), 0, value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedUnion2by2(value1.content, 0, value1.getCardinality(), value2.content, 0, value2.getCardinality(), answer.content.array());
        return answer;
    }

    MappeableContainer lazyor(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 1024) {
            return this.toBitmapContainer().lazyIOR(value2);
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(totalCardinality);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedUnion2by2(value1.content.array(), 0, value1.getCardinality(), value2.content.array(), 0, value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedUnion2by2(value1.content, 0, value1.getCardinality(), value2.content, 0, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer x) {
        return x.or(this);
    }

    @Override
    public MappeableContainer or(MappeableRunContainer value2) {
        return value2.or(this);
    }

    private MappeableContainer or(CharIterator it) {
        return this.or(it, false);
    }

    private MappeableContainer or(CharIterator it, boolean exclusive) {
        MappeableArrayContainer ac = new MappeableArrayContainer();
        int myItPos = 0;
        ac.cardinality = 0;
        int myHead = myItPos == this.cardinality ? -1 : (int)this.content.get(myItPos++);
        int hisHead = this.advance(it);
        while (myHead != -1 && hisHead != -1) {
            if (myHead < hisHead) {
                ac.emit((char)myHead);
                myHead = myItPos == this.cardinality ? -1 : (int)this.content.get(myItPos++);
                continue;
            }
            if (myHead > hisHead) {
                ac.emit((char)hisHead);
                hisHead = this.advance(it);
                continue;
            }
            if (!exclusive) {
                ac.emit((char)hisHead);
            }
            hisHead = this.advance(it);
            myHead = myItPos == this.cardinality ? -1 : (int)this.content.get(myItPos++);
        }
        while (myHead != -1) {
            ac.emit((char)myHead);
            myHead = myItPos == this.cardinality ? -1 : (int)this.content.get(myItPos++);
        }
        while (hisHead != -1) {
            ac.emit((char)hisHead);
            hisHead = this.advance(it);
        }
        if (ac.cardinality > 4096) {
            return ac.toBitmapContainer();
        }
        return ac;
    }

    void removeAtIndex(int loc) {
        System.arraycopy(this.content.array(), loc + 1, this.content.array(), loc, this.cardinality - loc - 1);
        --this.cardinality;
    }

    @Override
    public MappeableContainer repairAfterLazy() {
        return this;
    }

    @Override
    public MappeableContainer runOptimize() {
        int numRuns = this.numberOfRuns();
        int sizeAsRunContainer = MappeableRunContainer.getArraySizeInBytes(numRuns);
        if (this.getArraySizeInBytes(false) > sizeAsRunContainer) {
            return new MappeableRunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public int serializedSizeInBytes() {
        return MappeableArrayContainer.serializedSizeInBytes(this.cardinality);
    }

    @Override
    public MappeableBitmapContainer toBitmapContainer() {
        MappeableBitmapContainer bc = new MappeableBitmapContainer();
        bc.loadData(this);
        return bc;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{}".length() + "-123456789,".length() * this.cardinality);
        sb.append('{');
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append((int)this.content.get(i));
            sb.append(',');
        }
        sb.append((int)this.content.get(this.cardinality - 1));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void trim() {
        if (this.content.limit() == this.cardinality) {
            return;
        }
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            this.content = CharBuffer.wrap(Arrays.copyOf(this.content.array(), this.cardinality));
        } else {
            CharBuffer co = CharBuffer.allocate(this.cardinality);
            char[] x = co.array();
            for (int k = 0; k < this.cardinality; ++k) {
                x[k] = this.content.get(k);
            }
            this.content = co;
        }
    }

    @Override
    public void writeArray(ByteBuffer buffer, boolean isForBitmapSerialize) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        CharBuffer target = buffer.asCharBuffer();
        CharBuffer source = this.content.duplicate();
        source.position(0);
        source.limit(this.cardinality);
        target.put(source);
        int bytesWritten = 2 * this.cardinality;
        buffer.position(buffer.position() + bytesWritten);
    }

    @Override
    public void forEach(char msb, IntConsumer ic) {
        int high = msb << 16;
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            char[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                ic.accept(c[k] & 0xFFFF | high);
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                ic.accept(this.content.get(k) & 0xFFFF | high);
            }
        }
    }

    @Override
    public int andCardinality(MappeableArrayContainer value2) {
        if (BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(value2.content)) {
            return Util.unsignedLocalIntersect2by2Cardinality(this.content.array(), this.cardinality, value2.content.array(), value2.getCardinality());
        }
        return BufferUtil.unsignedLocalIntersect2by2Cardinality(this.content, this.cardinality, value2.content, value2.getCardinality());
    }

    @Override
    public int andCardinality(MappeableBitmapContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public int andCardinality(MappeableRunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public boolean intersects(int minimum, int supremum) {
        if (minimum < 0 || supremum < minimum || supremum > 65536) {
            throw new RuntimeException("This should never happen (bug).");
        }
        int pos = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (char)minimum);
        int index = pos >= 0 ? pos : -pos - 1;
        return index < this.cardinality && this.content.get(index) < supremum;
    }
}

