/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringBuffer;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import org.roaringbitmap.CharIterator;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringArray;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.buffer.PointableRoaringArray;

public class ImmutableRoaringBitmap
implements Iterable<Integer>,
Cloneable,
ImmutableBitmapDataProvider,
OlapBitmap {
    private static long SHALLOW_SIZE_OF = -1L;
    PointableRoaringArray highLowContainer = null;

    public ImmutableRoaringBitmap(N_PointableRoaringBuffer highLow) {
        this.highLowContainer = highLow;
    }

    protected ImmutableRoaringBitmap() {
    }

    public ImmutableRoaringBitmap(ByteBuffer bytes) {
        this.highLowContainer = new ImmutableRoaringArray(bytes);
    }

    public static int andCardinality(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        int answer = 0;
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                MappeableContainer c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                MappeableContainer c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                answer += c1.andCardinality(c2);
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return answer;
    }

    public Boolean validate() {
        return this.highLowContainer.validate();
    }

    public static ImmutableRoaringBitmap emptyBitmapMap() {
        return new MutableRoaringBitmap();
    }

    public static MutableRoaringBitmap flip(ImmutableRoaringBitmap bm, long rangeStart, long rangeEnd) {
        MutableRoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            throw new RuntimeException("Invalid range " + rangeStart + " -- " + rangeEnd);
        }
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        int hbStart = BufferUtil.highbits(rangeStart);
        char lbStart = BufferUtil.lowbits(rangeStart);
        char hbLast = BufferUtil.highbits(rangeEnd - 1L);
        char lbLast = BufferUtil.lowbits(rangeEnd - 1L);
        answer.getMappeableRoaringArray().appendCopiesUntil(bm.highLowContainer, (char)hbStart);
        char max = BufferUtil.maxLowBit();
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            char containerStart = hb == hbStart ? lbStart : (char)'\u0000';
            char containerLast = hb == hbLast ? lbLast : max;
            int i = bm.highLowContainer.getIndex((char)hb);
            int j = answer.getMappeableRoaringArray().getIndex((char)hb);
            assert (j < 0);
            if (i >= 0) {
                MappeableContainer c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast + '\u0001');
                if (c.isEmpty()) continue;
                answer.getMappeableRoaringArray().insertNewKeyValueAt(-j - 1, (char)hb, c);
                continue;
            }
            answer.getMappeableRoaringArray().insertNewKeyValueAt(-j - 1, (char)hb, MappeableContainer.rangeOfOnes(containerStart, containerLast + '\u0001'));
        }
        answer.getMappeableRoaringArray().appendCopiesAfter(bm.highLowContainer, hbLast);
        return answer;
    }

    public ImmutableRoaringBitmap clone() {
        try {
            ImmutableRoaringBitmap x = (ImmutableRoaringBitmap)super.clone();
            x.highLowContainer = this.highLowContainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("shouldn't happen with clone", e);
        }
    }

    @Override
    public boolean contains(int x) {
        char hb = BufferUtil.highbits(x);
        int index = this.highLowContainer.getContainerIndex(hb);
        return index >= 0 && this.highLowContainer.containsForContainerAtIndex(index, BufferUtil.lowbits(x));
    }

    public boolean intersects(long minimum, long supremum) {
        int pos;
        MutableRoaringBitmap.rangeSanityCheck(minimum, supremum);
        if (supremum <= minimum) {
            return false;
        }
        int minKey = (int)(minimum >>> 16);
        int supKey = (int)(supremum >>> 16);
        int length = this.highLowContainer.size();
        for (pos = 0; pos < length && minKey > this.highLowContainer.getKeyAtIndex(pos); ++pos) {
        }
        if (pos == length) {
            return false;
        }
        int offset = minKey == this.highLowContainer.getKeyAtIndex(pos) ? BufferUtil.lowbitsAsInteger(minimum) : 0;
        int limit = BufferUtil.lowbitsAsInteger(supremum);
        if (supKey == this.highLowContainer.getKeyAtIndex(pos)) {
            if (supKey > minKey) {
                offset = 0;
            }
            return this.highLowContainer.getContainerAtIndex(pos).intersects(offset, limit);
        }
        while (pos < length && supKey > this.highLowContainer.getKeyAtIndex(pos)) {
            MappeableContainer container = this.highLowContainer.getContainerAtIndex(pos);
            if (container.intersects(offset, 65536)) {
                return true;
            }
            offset = 0;
            ++pos;
        }
        return pos < length && supKey == this.highLowContainer.getKeyAtIndex(pos) && this.highLowContainer.getContainerAtIndex(pos).intersects(offset, limit);
    }

    @Override
    public long getLongCardinality() {
        long size = 0L;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += (long)this.highLowContainer.getCardinality(i);
        }
        return size;
    }

    @Override
    public int getCardinality() {
        return (int)this.getLongCardinality();
    }

    @Override
    public void forEach(IntConsumer ic) {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            this.highLowContainer.getContainerAtIndex(i).forEach(this.highLowContainer.getKeyAtIndex(i), ic);
        }
    }

    public MappeableContainerPointer getContainerPointer() {
        return this.highLowContainer.getContainerPointer();
    }

    @Override
    public PeekableIntIterator getIntIterator() {
        return new ImmutableRoaringIntIterator(this);
    }

    public boolean hasRunCompression() {
        return this.highLowContainer.hasRunCompression();
    }

    @Override
    public boolean isEmpty() {
        return this.highLowContainer.size() == 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(this){
            int hs;
            CharIterator iter;
            int pos;
            int x;
            final /* synthetic */ ImmutableRoaringBitmap this$0;
            {
                ImmutableRoaringBitmap immutableRoaringBitmap = this$0;
                Objects.requireNonNull(immutableRoaringBitmap);
                this.this$0 = immutableRoaringBitmap;
                this.hs = 0;
                this.pos = 0;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.this$0.highLowContainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < this.this$0.highLowContainer.size()) {
                    this.iter = this.this$0.highLowContainer.getContainerAtIndex(this.pos).getCharIterator();
                    this.hs = this.this$0.highLowContainer.getKeyAtIndex(this.pos) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = this.iter.nextAsInt() | this.hs;
                if (!this.iter.hasNext()) {
                    ++this.pos;
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot modify.");
            }
        }.init();
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        this.highLowContainer.serialize(buffer);
    }

    @Override
    public int serializedSizeInBytes() {
        return this.highLowContainer.serializedSizeInBytes(true);
    }

    public int serializedSizeInBytesForStats() {
        return this.highLowContainer.serializedSizeInBytesForStats();
    }

    public MutableRoaringBitmap toMutableRoaringBitmap() {
        MutableRoaringBitmap c = new MutableRoaringBitmap();
        MappeableContainerPointer mcp = this.highLowContainer.getContainerPointer();
        while (mcp.hasContainer()) {
            c.getMappeableRoaringArray().appendCopy(mcp.key(), mcp.getContainer());
            mcp.advance();
        }
        return c;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder("{}".length() + "-123456789,".length() * 256);
        PeekableIntIterator i = this.getIntIterator();
        answer.append('{');
        if (i.hasNext()) {
            answer.append((long)i.next() & 0xFFFFFFFFL);
        }
        while (i.hasNext()) {
            answer.append(',');
            if (answer.length() > 524288) {
                answer.append('.').append('.').append('.');
                break;
            }
            answer.append((long)i.next() & 0xFFFFFFFFL);
        }
        answer.append('}');
        return answer.toString();
    }

    @Override
    public int getContainerCount() {
        return this.highLowContainer.size();
    }

    @Override
    public long sizeOf() {
        long size = 0L;
        size += SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += ((N_PointableRoaringBuffer)this.highLowContainer).sizeOf();
    }

    @Override
    public long cardinality() {
        return this.getLongCardinality();
    }

    @Override
    public boolean isZero() {
        return this.isEmpty();
    }

    @Override
    public boolean isNoEmpty() {
        return !this.isEmpty();
    }

    @Override
    public boolean getBit(int i) {
        return this.contains(i);
    }

    @Override
    public OlapBitmap compact() {
        return this;
    }

    @Override
    public void setBit(int pos) {
        throw new CdShouldNotBeHereProgrammingException("immutable");
    }

    @Override
    public boolean apply(OlapBitmapCallback callback) {
        return OlapFactsBitmapRoaringBuffer.apply(this, callback);
    }

    private class ImmutableRoaringIntIterator
    implements PeekableIntIterator {
        private boolean wrap;
        private MappeableContainerPointer cp;
        private int iterations;
        private int hs;
        private PeekableCharIterator iter;
        private boolean ok;
        final /* synthetic */ ImmutableRoaringBitmap this$0;

        public ImmutableRoaringIntIterator(ImmutableRoaringBitmap immutableRoaringBitmap) {
            ImmutableRoaringBitmap immutableRoaringBitmap2 = immutableRoaringBitmap;
            Objects.requireNonNull(immutableRoaringBitmap2);
            this.this$0 = immutableRoaringBitmap2;
            this.iterations = 0;
            this.hs = 0;
            char index = this.findStartingContainerIndex();
            this.wrap = index != '\u0000';
            this.cp = immutableRoaringBitmap.highLowContainer.getContainerPointer(index);
            this.nextContainer();
        }

        char findStartingContainerIndex() {
            return '\u0000';
        }

        @Override
        public PeekableIntIterator clone() {
            try {
                ImmutableRoaringIntIterator x = (ImmutableRoaringIntIterator)super.clone();
                if (this.iter != null) {
                    x.iter = this.iter.clone();
                }
                if (this.cp != null) {
                    x.cp = this.cp.clone();
                }
                x.wrap = this.wrap;
                x.iterations = this.iterations;
                return x;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.ok;
        }

        @Override
        public int next() {
            int x = this.iter.nextAsInt() | this.hs;
            if (!this.iter.hasNext()) {
                this.cp.advance();
                this.nextContainer();
            }
            return x;
        }

        private void nextContainer() {
            int containerSize = this.this$0.highLowContainer.size();
            if (this.wrap || this.iterations < containerSize) {
                this.ok = this.cp.hasContainer();
                if (!this.ok && this.wrap && this.iterations < containerSize) {
                    this.cp = this.this$0.highLowContainer.getContainerPointer();
                    this.wrap = false;
                    this.ok = this.cp.hasContainer();
                }
                if (this.ok) {
                    this.iter = this.cp.getContainer().getCharIterator();
                    this.hs = this.cp.key() << 16;
                    ++this.iterations;
                }
            } else {
                this.ok = false;
            }
        }

        @Override
        public void advanceIfNeeded(int minval) {
            while (this.hasNext() && this.shouldAdvanceContainer(this.hs, minval)) {
                this.cp.advance();
                this.nextContainer();
            }
            if (this.ok && this.hs >>> 16 == minval >>> 16) {
                this.iter.advanceIfNeeded(BufferUtil.lowbits(minval));
                if (!this.iter.hasNext()) {
                    this.cp.advance();
                    this.nextContainer();
                }
            }
        }

        boolean shouldAdvanceContainer(int hs, int minval) {
            return hs >>> 16 < minval >>> 16;
        }

        @Override
        public int peekNext() {
            return this.iter.peekNext() | this.hs;
        }
    }
}

