/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class BitmapFastAggregation {
    public static boolean USE_NAIVE = true;

    private BitmapFastAggregation() {
    }

    public static MutableRoaringBitmap and(ImmutableRoaringBitmap ... bitmaps) {
        return BitmapFastAggregation.workAndShy(bitmaps);
    }

    public static MutableRoaringBitmap and(MutableRoaringBitmap ... bitmaps) {
        return BitmapFastAggregation.and(BitmapFastAggregation.convertToImmutable(bitmaps));
    }

    public static int andCardinality(ImmutableRoaringBitmap ... bitmaps) {
        switch (bitmaps.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return bitmaps[0].getCardinality();
            }
            case 2: {
                return ImmutableRoaringBitmap.andCardinality(bitmaps[0], bitmaps[1]);
            }
        }
        return BitmapFastAggregation.workShyAndCardinality(bitmaps);
    }

    private static ImmutableRoaringBitmap[] convertToImmutable(MutableRoaringBitmap[] array) {
        ImmutableRoaringBitmap[] answer = new ImmutableRoaringBitmap[array.length];
        System.arraycopy(array, 0, answer, 0, answer.length);
        return answer;
    }

    private static MutableRoaringBitmap naive_and(ImmutableRoaringBitmap bitmap1, ImmutableRoaringBitmap bitmap2) {
        MutableRoaringBitmap answer;
        if (bitmap1.highLowContainer.size() <= bitmap2.highLowContainer.size()) {
            answer = bitmap1.toMutableRoaringBitmap();
            answer.and(bitmap2);
        } else {
            answer = bitmap2.toMutableRoaringBitmap();
            answer.and(bitmap1);
        }
        return answer;
    }

    private static MutableRoaringBitmap workAndShy(ImmutableRoaringBitmap[] bitmaps) {
        if (bitmaps.length == 0 || bitmaps[0].isZero()) {
            return new MutableRoaringBitmap();
        }
        CharArrayList answerKey = new CharArrayList();
        ArrayList<MappeableContainer> answerContainers = new ArrayList<MappeableContainer>();
        Arrays.sort(bitmaps, Comparator.comparingInt(a -> a.highLowContainer.size()));
        int numBitmaps = bitmaps.length;
        int[] containersPos = new int[bitmaps.length];
        PointableRoaringArray firstContainer = bitmaps[0].highLowContainer;
        block0: for (int firstI = 0; firstI < firstContainer.size(); ++firstI) {
            char currentKey = firstContainer.getKeyAtIndex(firstI);
            boolean andOnContainer = true;
            for (int j = 1; j < numBitmaps; ++j) {
                PointableRoaringArray containerJ = bitmaps[j].highLowContainer;
                int posJ = containerJ.advanceUntil(currentKey, containersPos[j] - 1);
                if (posJ == containerJ.size()) break block0;
                containersPos[j] = posJ;
                char keyJ = containerJ.getKeyAtIndex(posJ);
                if (keyJ == currentKey) continue;
                if ((firstI = firstContainer.advanceUntil(keyJ, firstI)) >= firstContainer.size()) break block0;
                andOnContainer = false;
                --firstI;
                break;
            }
            if (!andOnContainer) continue;
            MappeableContainer c = firstContainer.getContainerAtIndex(firstI).clone();
            for (int i = 1; i < numBitmaps; ++i) {
                MappeableContainer temp = c.iand(bitmaps[i].highLowContainer.getContainerAtIndex(containersPos[i]));
                if (temp.isEmpty()) {
                    c = null;
                    break;
                }
                if (temp == c) continue;
                c = temp;
            }
            if (c == null) continue;
            answerKey.add(currentKey);
            answerContainers.add(c);
        }
        return MutableRoaringBitmap.bitmapFor(answerKey, answerContainers);
    }

    private static int workShyAndCardinality(ImmutableRoaringBitmap ... bitmaps) {
        long[] words = new long[1024];
        char[] keys = BufferUtil.intersectKeys(words, bitmaps);
        if (keys.length == 0) {
            return 0;
        }
        LongBuffer longBuffer = LongBuffer.wrap(words);
        int cardinality = 0;
        for (char key : keys) {
            Arrays.fill(words, -1L);
            MappeableContainer tmp = new MappeableBitmapContainer(longBuffer, -1);
            for (ImmutableRoaringBitmap bitmap : bitmaps) {
                MappeableContainer container;
                MappeableContainer and;
                int index = bitmap.highLowContainer.getIndex(key);
                if (index < 0 || (and = tmp.iand(container = bitmap.highLowContainer.getContainerAtIndex(index))) == tmp) continue;
                tmp = and;
            }
            cardinality += ((MappeableContainer)tmp).repairAfterLazy().getCardinality();
        }
        return cardinality;
    }

    public static MutableRoaringBitmap naive_or(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.naivelazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_or(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.lazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        return BitmapFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap or(MutableRoaringBitmap ... bitmaps) {
        return BitmapFastAggregation.naive_or(bitmaps);
    }
}

