/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.validation;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.property.CdProperty;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.contextual.OlapContextualErrorManager;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapValidatorContext<CODE extends CdErrorCode, ERROR extends OlapContextualError<CODE>, ERROR_MANAGER extends OlapContextualErrorManager<CODE, ERROR>> {
    protected final ERROR_MANAGER errorManager;

    public OlapValidatorContext(ERROR_MANAGER errorManager) {
        this.errorManager = errorManager;
    }

    public ERROR_MANAGER getErrorManager() {
        return this.errorManager;
    }

    public boolean hasErrors() {
        return ((OlapContextualErrorManager)this.errorManager).hasErrors();
    }

    public void addError(CODE errorCode, Serializable ... params) {
        ((OlapContextualErrorManager)this.errorManager).addError(errorCode, params);
    }

    public void addErrorWithContextual(IOlapContextual contextual, CdProperty property, CODE errorCode, Serializable ... params) {
        ((OlapContextualErrorManager)this.errorManager).addErrorWithContextual(contextual, property, errorCode, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorWithContextual(@Nullable IOlapContextual contextualPARENT, IOlapContextual contextual, CdProperty property, CODE errorCode, Serializable ... params) {
        if (contextualPARENT != null) {
            ((OlapContextualErrorManager)this.errorManager).pushContext(contextualPARENT);
        }
        try {
            ((OlapContextualErrorManager)this.errorManager).addErrorWithContextual(contextual, property, errorCode, params);
        }
        finally {
            if (contextualPARENT != null) {
                ((OlapContextualErrorManager)this.errorManager).popContext();
            }
        }
    }

    public void addErrorWithContextual(IOlapContextual contextual, CODE errorCode, Serializable ... params) {
        ((OlapContextualErrorManager)this.errorManager).addErrorWithContextual(contextual, errorCode, params);
    }

    public void addError(CdProperty property, CODE errorCode, Serializable ... params) {
        ((OlapContextualErrorManager)this.errorManager).addError(property, null, errorCode, params);
    }

    public void addError(CdProperty property, CdErrorLocation mdxErrorLocation, CODE errorCode, Serializable ... params) {
        ((OlapContextualErrorManager)this.errorManager).addError(property, mdxErrorLocation, errorCode, params);
    }

    public void addError(ERROR error) {
        ((OlapContextualErrorManager)this.errorManager).addError(error);
    }

    public void addError(CdProperty property, ERROR error) {
        ((OlapContextualErrorManager)this.errorManager).addError(property, error);
    }

    public OlapNameContext getNameContext() {
        return OlapDefaultNamesContext.SINGLETON;
    }
}

