/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.tidytable.sql;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.tidy.OlapResSerializableTidyTable;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceFactory;
import crazydev.iccube.tidytable.sql.SqlTidyTableColumn;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class SqlTidyTable
extends OlapResSerializableTidyTable {
    private final TidyTableClassID classID = TidyTableClassID.SQL_TABLE;
    private final List<SqlTidyTableColumn> columns;
    private final int rowCount;
    private final int tidyMaxRowCount;
    private final boolean tidyMaxRowCountReached;

    private SqlTidyTable() {
        this(Collections.emptyList(), 0, Integer.MAX_VALUE, false);
    }

    private SqlTidyTable(List<SqlTidyTableColumn> columns, int rowCount, int maxRowCount, boolean maxRowCountReached) {
        this.columns = columns;
        this.rowCount = rowCount;
        this.tidyMaxRowCount = maxRowCount;
        this.tidyMaxRowCountReached = maxRowCountReached;
    }

    public static SqlTidyTable create() {
        SqlTidyTable table = new SqlTidyTable();
        table.setNaN();
        return table;
    }

    public static SqlTidyTable create(List<SqlTidyTableColumn> columns, int rowCount, int maxRowCount, boolean maxRowCountReached) {
        SqlTidyTable table = new SqlTidyTable(columns, rowCount, maxRowCount, maxRowCountReached);
        table.setNaN();
        return table;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getMaxRowCount() {
        return this.tidyMaxRowCount;
    }

    public boolean isMaxRowCountReached() {
        return this.tidyMaxRowCountReached;
    }

    public List<SqlTidyTableColumn> getColumns() {
        return this.columns;
    }

    private void setNaN() {
        for (SqlTidyTableColumn column : this.columns) {
            column.setNaN();
        }
    }

    public IOlapSerializedTidyResource serializeAsJson(OlapEngineRequestContext context) throws IOException {
        return OlapSerializedTidyResourceFactory.create(OlapSerializedTidyResourceFactory.Prefix.sql, context, out -> {
            JsonWriter w = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            GsonBuilder gsonB = new GsonBuilder();
            w.setStrictness(Strictness.LENIENT);
            gsonB.serializeSpecialFloatingPointValues();
            Gson gson = gsonB.create();
            this.serializeTable(w, gson, context);
            w.close();
        });
    }

    public void serializeTable(JsonWriter w, Gson g, OlapEngineRequestContext context) throws IOException {
        w.beginObject();
        this.serialize(w, "classID", TidyTableClassID.SQL_TABLE.name());
        this.serialize(w, "rowCount", this.rowCount);
        this.serialize(w, "tidyMaxRowCount", this.tidyMaxRowCount);
        this.serialize(w, "tidyMaxRowCountReached", this.tidyMaxRowCountReached);
        if (this.rowCount > 0) {
            this.serializeColumns(w, g, context);
        }
        w.endObject();
    }

    private void serializeColumns(JsonWriter w, Gson g, OlapEngineRequestContext context) throws IOException {
        w.name("columns");
        w.beginArray();
        for (SqlTidyTableColumn column : this.columns) {
            context.assertNotCancelling("materialized-tidy:create-columns");
            this.serializeColumn(w, g, context, column);
        }
        w.endArray();
    }

    private void serializeColumn(JsonWriter w, Gson g, OlapEngineRequestContext context, SqlTidyTableColumn column) throws IOException {
        String cellsJ = g.toJson((Object)column);
        w.jsonValue(cellsJ);
    }
}

