/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.tidytable;

import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.tidytable.TidyTableNameCaption;
import org.jetbrains.annotations.Nullable;

public abstract class TidyTableColumn {
    private final TidyTableClassID classID;
    @Nullable
    private final String role;
    private final String name;
    private final String caption;
    private OlapScalarEntityTidyType type = OlapScalarEntityTidyType.UNKNOWN;
    @Nullable
    private OlapScalarEntityTidyType typeParam;

    public TidyTableColumn(TidyTableClassID classID, String name) {
        this.classID = classID;
        this.role = null;
        this.name = name;
        this.caption = name;
    }

    public TidyTableColumn(TidyTableClassID classID, @Nullable String role, TidyTableNameCaption name) {
        this.classID = classID;
        this.role = role;
        this.name = name.name;
        this.caption = name.caption;
    }

    public String getName() {
        return this.name;
    }

    public OlapScalarEntityTidyType getType() {
        return this.type;
    }

    public void inferType() {
        this.type = this.inferType(false);
        if (this.type == OlapScalarEntityTidyType.LIST) {
            this.typeParam = this.inferType(true);
        }
    }

    private OlapScalarEntityTidyType inferType(boolean forSubType) {
        OlapScalarEntityTidyType type = null;
        int rowCount = this.getRowCount();
        for (int rr = 0; rr < rowCount; ++rr) {
            OlapScalarEntityTidyType vType;
            OlapScalarEntityTidyType olapScalarEntityTidyType = vType = !forSubType ? this.getValueType(rr) : this.getValueTypeParam(rr);
            if (vType == null || vType == OlapScalarEntityTidyType.NULL) continue;
            if (vType == OlapScalarEntityTidyType.UNKNOWN) {
                type = OlapScalarEntityTidyType.UNKNOWN;
                break;
            }
            if (vType == OlapScalarEntityTidyType.MIXED) {
                type = OlapScalarEntityTidyType.MIXED;
                break;
            }
            if (type == null) {
                type = vType;
                continue;
            }
            if (type == vType) continue;
            type = OlapScalarEntityTidyType.MIXED;
            break;
        }
        return type == null ? OlapScalarEntityTidyType.NULL : type;
    }

    public abstract int getRowCount();

    @Nullable
    public abstract Object getValue(int var1);

    @Nullable
    public abstract OlapScalarEntityTidyType getValueType(int var1);

    @Nullable
    public abstract OlapScalarEntityTidyType getValueTypeParam(int var1);

    @Nullable
    public abstract void compact();

    public abstract void freeze();

    public String toString() {
        return this.name + " [" + String.valueOf((Object)this.classID) + "]";
    }
}

