/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.tenants;

import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantDefinitions;
import crazydev.iccube.tenants.OlapTenantHomeSetup;
import crazydev.iccube.tenants.OlapTenantUtils;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapTenantManager {
    private final Object globalLOCK = new Object();
    private final OlapRuntime runtime;
    private OlapTenantDefinitions tenantDefinitions;
    private int currentRevNumber = -1;
    @Nullable
    private OlapTenantHomeSetup homeSetup;

    public OlapTenantManager(OlapRuntime runtime) {
        this(runtime, null);
    }

    public OlapTenantManager(OlapRuntime runtime, @Nullable File tenants) {
        this.runtime = runtime;
        try {
            if (tenants != null) {
                File file = new File(tenants, "icCubeTenants.icc-tenants");
                this.tenantDefinitions = (OlapTenantDefinitions)CdXmlUtils.unmarshall((String)"UTF-8", (File)file, (Class[])new Class[]{OlapTenantDefinitions.class});
            } else {
                this.tenantDefinitions = new OlapTenantDefinitions();
            }
            this.currentRevNumber = 0;
        }
        catch (JAXBException | IOException ex) {
            throw new RuntimeException("invalid tenants definition", ex);
        }
    }

    public void set(OlapTenantHomeSetup homeSetup) {
        this.homeSetup = homeSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRevisionNumber() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.currentRevNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapTenantDefinition> getTenantDefinitions() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.tenantDefinitions.getTenantDefinitions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTenantDefinitions(OlapTenantDefinitions definitions) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.tenantDefinitions = definitions;
            ++this.currentRevNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTenantNamesForUX() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.tenantDefinitions.getTenantNamesForUX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapTenantDefinition> getSortedTenantDefinitionsForUX() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.tenantDefinitions.getSortedTenantDefinitionsForUX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapTenantDefinition getTenantDefinitionByUUID(String uuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.tenantDefinitions.getTenantDefinitionByUUID(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapTenantDefinition getTenantDefinitionByName(String name) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.tenantDefinitions.getTenantDefinitionByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupTenantHomeDirectory(OlapDirectoriesResolved directories, OlapTenantDefinition tenant, boolean deleteExisting) throws OlapDirectoriesResolvedNotSuperAdminException {
        Object object = this.globalLOCK;
        synchronized (object) {
            File offline;
            directories.assertRoot();
            File home = OlapTenantUtils.getHomeDirectory(directories, tenant);
            OlapLoggers.GENERAL.info((Object)("[tenant] setup (reset) tenant [" + tenant.getName() + "] home directory [" + deleteExisting + "] : " + home.getAbsolutePath()));
            if (home.exists() && !deleteExisting) {
                OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] home directory : nop"));
                return false;
            }
            if (home.exists()) {
                OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] delete its home directory."));
                if (!CdVFileSystemUtils.deleteQuietly((File)home)) {
                    OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] could not delete its home directory."));
                    return false;
                }
            }
            if (!home.mkdir()) {
                OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] could not create its home directory."));
                return false;
            }
            OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] setup its home directory."));
            OlapTenant tenant_ = new OlapTenant(tenant.getName(), tenant.getDirectory());
            OlapDirectoriesResolved tenantDirectories = directories.create(tenant_);
            File backup = tenantDirectories.getBackupDirectory();
            if (!backup.mkdir()) {
                return false;
            }
            File builder = tenantDirectories.getBuilderDirectory();
            if (!builder.mkdir()) {
                return false;
            }
            File cubes = tenantDirectories.getCubesDirectory();
            if (!cubes.mkdir()) {
                return false;
            }
            File docsRepository = tenantDirectories.getDocsRepositoryDirectory();
            if (!docsRepository.mkdir()) {
                return false;
            }
            if (this.homeSetup != null) {
                this.homeSetup.setupDocsRepository(tenantDirectories, true);
            }
            if (!(offline = tenantDirectories.getOfflineDirectory()).mkdir()) {
                return false;
            }
            File scheduler = tenantDirectories.getSchedulerDirectory();
            if (!scheduler.mkdir()) {
                return false;
            }
            File webPub = tenantDirectories.getWebPubDirectory();
            if (!webPub.mkdir()) {
                return false;
            }
            this.runtime.setUpWebPubDirectory(webPub);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean repairTenantHomeDirectory(OlapDirectoriesResolved directories, OlapTenantDefinition tenant, boolean installDashboardApp) throws OlapDirectoriesResolvedNotSuperAdminException {
        Object object = this.globalLOCK;
        synchronized (object) {
            File offline;
            directories.assertRoot();
            File home = OlapTenantUtils.getHomeDirectory(directories, tenant);
            OlapLoggers.GENERAL.info((Object)("[tenant] repair tenant [" + tenant.getName() + "] home directory [" + installDashboardApp + "] : " + home.getAbsolutePath()));
            if (!home.exists() && !home.mkdir()) {
                OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] could not create its home directory."));
                return false;
            }
            OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] repair its home directory."));
            OlapTenant tenant_ = new OlapTenant(tenant.getName(), tenant.getDirectory());
            OlapDirectoriesResolved tenantDirectories = directories.create(tenant_);
            File backup = tenantDirectories.getBackupDirectory();
            if (!backup.exists() && !backup.mkdir()) {
                return false;
            }
            File builder = tenantDirectories.getBuilderDirectory();
            if (!builder.exists() && !builder.mkdir()) {
                return false;
            }
            File cubes = tenantDirectories.getCubesDirectory();
            if (!cubes.exists() && !cubes.mkdir()) {
                return false;
            }
            File docsRepository = tenantDirectories.getDocsRepositoryDirectory();
            if (!docsRepository.exists() && !docsRepository.mkdir()) {
                return false;
            }
            if (this.homeSetup != null) {
                this.homeSetup.setupDocsRepository(tenantDirectories, installDashboardApp);
            }
            if (!(offline = tenantDirectories.getOfflineDirectory()).exists() && !offline.mkdir()) {
                return false;
            }
            File scheduler = tenantDirectories.getSchedulerDirectory();
            if (!scheduler.exists() && !scheduler.mkdir()) {
                return false;
            }
            File webPub = tenantDirectories.getWebPubDirectory();
            if (!webPub.exists() && !webPub.mkdir()) {
                return false;
            }
            this.runtime.setUpWebPubDirectory(webPub);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTenantHomeDirectory(OlapDirectoriesResolved directories, OlapTenantDefinition tenant) throws OlapDirectoriesResolvedNotSuperAdminException {
        Object object = this.globalLOCK;
        synchronized (object) {
            directories.assertRoot();
            File home = OlapTenantUtils.getHomeDirectory(directories, tenant);
            OlapLoggers.GENERAL.info((Object)("[tenant] delete tenant [" + tenant.getName() + "] home directory : " + home.getAbsolutePath()));
            if (home.exists()) {
                OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] delete its home directory."));
                if (!CdVFileSystemUtils.deleteQuietly((File)home)) {
                    OlapLoggers.GENERAL.info((Object)("[tenant] tenant [" + tenant.getName() + "] could not delete its home directory."));
                    return false;
                }
            }
            return true;
        }
    }
}

