/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.runtime;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class OlapRuntimeDashboardsVersion {
    public final String version;
    @Nullable
    public final String timestamp;

    public OlapRuntimeDashboardsVersion(String version, @Nullable String timestamp) {
        this.version = version;
        this.timestamp = timestamp;
    }

    @Nullable
    public static OlapRuntimeDashboardsVersion parse(List<String> lines) {
        String version = null;
        String timestamp = null;
        for (String line : lines) {
            Matcher matcher;
            Pattern regexp;
            if (line.contains("name=\"ic3_build_version\"") && line.contains("name=\"ic3_build_timestamp\"")) {
                regexp = Pattern.compile("content=\"([^<>]*?)\" name=\"ic3_build_version\".*content=\"([^<>]*?)\" name=\"ic3_build_timestamp\"");
                matcher = regexp.matcher(line);
                if (!matcher.find()) continue;
                version = matcher.group(1);
                timestamp = matcher.group(2);
                continue;
            }
            if (line.contains("ic3_build_version =")) {
                regexp = Pattern.compile("\"(.*?)\"");
                matcher = regexp.matcher(line);
                if (!matcher.find()) continue;
                version = matcher.group(1);
                continue;
            }
            if (!line.contains("ic3_build_timestamp =") || !(matcher = (regexp = Pattern.compile("\"(.*?)\"")).matcher(line)).find()) continue;
            timestamp = matcher.group(1);
        }
        if (version != null) {
            return new OlapRuntimeDashboardsVersion(version, timestamp);
        }
        return null;
    }

    public String getVersionWithTimestamp() {
        if (this.timestamp != null) {
            return this.version + " (" + this.timestamp + ")";
        }
        return this.version;
    }

    public String getVersionWithTimestampEx() {
        if (this.timestamp != null) {
            return this.version + "+" + this.timestamp;
        }
        return this.version;
    }

    public String toString() {
        return this.getVersionWithTimestamp();
    }
}

