/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.runtime;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.directories.impl.OlapCubesDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapRolesDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapUsersDirectoryConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntime;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDevelopmentRuntime
extends OlapRuntime {
    public static final String IC_CUBE_DEV_RUNTIME_KIND = "icCube.dev.runtimeKind";
    private static boolean deleteDataDirectoryForUnitTest = true;
    protected final Kind runtimeKind = Kind.fromSystemProperty();
    @Nullable
    private File dataDirectory;

    public static void setRunMode(Kind runtimeKind) {
        System.setProperty(IC_CUBE_DEV_RUNTIME_KIND, runtimeKind.val);
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("linux");
    }

    public static boolean isMacOs() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac os x");
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win");
    }

    public static boolean isMpo() {
        String user = System.getProperty("user.name");
        return "mpo".equals(user) || "mpolizzi".equals(user);
    }

    public static boolean isDad() {
        String user = System.getProperty("user.name");
        return "david".equals(user) || "dad".equals(user);
    }

    @Override
    public boolean isForPing() {
        return false;
    }

    @Override
    public File getInstallDirectory() {
        return null;
    }

    @Override
    public File getInstallBinDirectory() {
        return null;
    }

    @Override
    public File getInstallCubesDirectory() {
        return null;
    }

    @Override
    public File getInstallMdxQueriesDirectory() {
        return null;
    }

    @Override
    public File getInstallPluginsDirectory() {
        return null;
    }

    @Override
    public File getInstallUxDirectory() {
        return null;
    }

    @Override
    public File getInstallHelpDirectory() {
        return null;
    }

    @Override
    public boolean requiresLoginPage() {
        return false;
    }

    @Override
    @Nullable
    public File getDataFileSystemRoot(@Nullable File root) {
        if (Kind.UNIT_TEST == this.runtimeKind) {
            return super.getDataFileSystemRoot(root);
        }
        if (Kind.UNIT_TEST_EX == this.runtimeKind) {
            return new File(this.getDataDirectory(), "cubes");
        }
        if (Kind.JCR_UNIT_TEST == this.runtimeKind) {
            return super.getDataFileSystemRoot(root);
        }
        if (Kind.PERFORMANCE_TEST == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isMpo() && OlapDevelopmentRuntime.isLinux()) {
                return new File(this.getDataDirectory(), "cubes");
            }
            throw new RuntimeException("PERFORMANCE_TEST: missing definition for getDataFileSystemRoot()");
        }
        if (Kind.NON_REGRESSION_TEST == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isDad()) {
                return new File(this.getDataDirectory(), "user-data");
            }
            return new File(this.getDataDirectory(), "cubes");
        }
        if (Kind.LIVEDEMO == this.runtimeKind) {
            return super.getDataFileSystemRoot(root);
        }
        if (Kind.MULTI_TENANT == this.runtimeKind) {
            return super.getDataFileSystemRoot(root);
        }
        if (Kind.DEMO3 == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isDad()) {
                return new File(this.getDataDirectory(), "user-data");
            }
            return new File(this.getDataDirectory(), "cubes");
        }
        if (Kind.INSANE_SCHEMA_COUNT == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isDad()) {
                return new File(this.getDataDirectory(), "user-data");
            }
            return new File(this.getDataDirectory(), "cubes");
        }
        return super.getDataFileSystemRoot(root);
    }

    @Override
    public File getLogFileSystemRoot(File root) {
        return super.getLogFileSystemRoot(root);
    }

    @Override
    public String getDataDirectory() {
        if (this.dataDirectory != null) {
            return this.dataDirectory.getAbsolutePath();
        }
        if (Kind.UNIT_TEST == this.runtimeKind || Kind.UNIT_TEST_EX == this.runtimeKind) {
            File out = this.getOutDirectory();
            this.dataDirectory = new File(out, "unit-tests");
            if (deleteDataDirectoryForUnitTest && this.dataDirectory.exists()) {
                CdVFileSystem vfs = this.getVfs();
                vfs.empty(this.dataDirectory);
                try {
                    if (!vfs.isEmpty(this.dataDirectory)) {
                        if (!OlapDevelopmentRuntime.isWindows()) {
                            throw new RuntimeException("could not properly empty the directory : " + this.dataDirectory.getAbsolutePath());
                        }
                        OlapLoggers.SERVER.warn((Object)("could not empty directory : " + this.dataDirectory.getAbsolutePath()));
                    }
                }
                catch (IOException ex) {
                    if (!OlapDevelopmentRuntime.isWindows()) {
                        throw new RuntimeException("could not check is-empty-directory : " + this.dataDirectory.getAbsolutePath(), ex);
                    }
                    OlapLoggers.SERVER.warn((Object)("could not check is-empty-directory : " + this.dataDirectory.getAbsolutePath()), (Throwable)ex);
                }
            }
            if (OlapDevelopmentRuntime.isWindows()) {
                deleteDataDirectoryForUnitTest = false;
            }
            return this.dataDirectory.getAbsolutePath();
        }
        if (Kind.JCR_UNIT_TEST == this.runtimeKind) {
            File out = this.getOutDirectory();
            this.dataDirectory = new File(out, "docs-unit-tests");
            return this.dataDirectory.getAbsolutePath();
        }
        if (Kind.PERFORMANCE_TEST == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isMpo() && OlapDevelopmentRuntime.isLinux()) {
                this.dataDirectory = new File("/home/mpo/icCube/envs/performance");
                return this.dataDirectory.getAbsolutePath();
            }
            throw new RuntimeException("define the non-regression data-directory");
        }
        if (Kind.NON_REGRESSION_TEST == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isMpo() && OlapDevelopmentRuntime.isLinux()) {
                this.dataDirectory = new File("/home/mpo/icCube/envs/non-regression");
            } else if (OlapDevelopmentRuntime.isDad()) {
                this.dataDirectory = OlapDevelopmentRuntime.isMacOs() ? new File("/Users/david/Development/non-regression") : new File("D:/development/iccube/iccube-files/no-regression/");
            } else {
                throw new RuntimeException("define the non-regression data-directory");
            }
            return this.dataDirectory.getAbsolutePath();
        }
        if (Kind.LIVEDEMO == this.runtimeKind) {
            this.dataDirectory = new File("/home/mpo/icCube/envs/livedemo");
            return this.dataDirectory.getAbsolutePath();
        }
        if (Kind.MULTI_TENANT == this.runtimeKind) {
            this.dataDirectory = new File("/home/mpo/icCube/envs/multi-tenant");
            return this.dataDirectory.getAbsolutePath();
        }
        if (Kind.DEMO3 == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isMpo()) {
                this.dataDirectory = OlapDevelopmentRuntime.isLinux() ? new File("/home/mpo/icCube/envs/demo3") : new File("c://icCube/demo3");
            } else if (OlapDevelopmentRuntime.isDad()) {
                this.dataDirectory = OlapDevelopmentRuntime.isLinux() ? new File("//Users/david/Development/demo3") : new File("D:/development/iccube/iccube-files/demo3/");
            } else {
                throw new RuntimeException("define the demo3 data-directory");
            }
            return this.dataDirectory.getAbsolutePath();
        }
        if (Kind.INSANE_SCHEMA_COUNT == this.runtimeKind) {
            if (OlapDevelopmentRuntime.isMpo() && OlapDevelopmentRuntime.isLinux()) {
                this.dataDirectory = new File("/home/mpo/icCube/envs/insane-schema-count");
            } else if (OlapDevelopmentRuntime.isDad()) {
                this.dataDirectory = OlapDevelopmentRuntime.isLinux() ? new File("/media/david/disk2T/icCube/insane-schema-count") : new File("C:/development/iccube/insane/");
            } else {
                throw new RuntimeException("define the insane-schema-count data-directory");
            }
            return this.dataDirectory.getAbsolutePath();
        }
        return "${user.home}/.icCube-idea";
    }

    @Override
    public void setUpCubesDirectory(OlapDirectoriesConfiguration directories) {
        if (Kind.UNIT_TEST == this.runtimeKind || Kind.UNIT_TEST_EX == this.runtimeKind) {
            OlapCubesDirectoryConfiguration directory;
            File initialDataDirectory;
            File initialCubes;
            String examples = System.getProperty("icCube.dev.tst-examples-directories");
            if (OlapDevelopmentRuntime.isWindows()) {
                this.setUpExamplesCubesDirectory(directories, new HashSet<String>());
            } else if (CdStringUtils.isNotNullAndNotBlank((String)examples)) {
                HashSet<String> folders = new HashSet<String>(Arrays.asList(examples.split(";")));
                this.setUpExamplesCubesDirectory(directories, folders);
            }
            String tst = System.getProperty("icCube.dev.tst-data-directory");
            if (CdStringUtils.isNotNullAndNotBlank((String)tst) && (initialCubes = new File(initialDataDirectory = new File(tst), "cubes")).exists()) {
                try {
                    OlapCubesDirectoryConfiguration directory2 = directories.getCubesDirectory();
                    OlapLoggers.SERVER.info((Object)("/cubes (dev: icCube.dev.tst-data-directory) directory [" + directory2.asFile().getAbsolutePath() + "] setup using the content of [" + initialCubes.getAbsolutePath() + "]"));
                    CdVFileSystemUtils.copyDirectory((File)initialCubes, (File)directories.getCubesDirectory().asFile());
                }
                catch (ClosedByInterruptException ignored) {
                    OlapLoggers.GENERAL.warn((Object)"interrupted : setUpCubesDirectory() [1]");
                }
                catch (IOException ex) {
                    throw new RuntimeException("cubes directory setup error", ex);
                }
            }
            if (!(directory = directories.getCubesDirectory()).wasCreated()) {
                return;
            }
            File from = new File(this.getInstallCubesDirectory(), "/../cubes_unit_tests");
            try {
                OlapLoggers.SERVER.info((Object)("[directory] /cubes (dev) directory [" + directory.asFile().getAbsolutePath() + "] setup using the content of [" + from.getAbsolutePath() + "]"));
                CdVFileSystemUtils.copyDirectory((File)from, (File)directory.asFile());
            }
            catch (ClosedByInterruptException ignored) {
                OlapLoggers.GENERAL.warn((Object)"interrupted : setUpCubesDirectory() [2]");
            }
            catch (IOException ignored) {
                OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /cubes directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]."), (Throwable)ignored);
            }
        } else if (Kind.JCR_UNIT_TEST == this.runtimeKind || Kind.PERFORMANCE_TEST == this.runtimeKind || Kind.NON_REGRESSION_TEST == this.runtimeKind || Kind.LIVEDEMO == this.runtimeKind || Kind.MULTI_TENANT == this.runtimeKind || Kind.DEMO3 == this.runtimeKind || Kind.INSANE_SCHEMA_COUNT == this.runtimeKind) {
            // empty if block
        }
    }

    private void setUpExamplesCubesDirectory(OlapDirectoriesConfiguration directories, final Set<String> folders) {
        OlapCubesDirectoryConfiguration directory = directories.getCubesDirectory();
        if (!directory.wasCreated()) {
            return;
        }
        File from = this.getInstallCubesDirectory();
        try {
            OlapLoggers.SERVER.info((Object)("[directory] /cubes (dev: examples[" + String.valueOf(folders) + "]) directory [" + directory.asFile().getAbsolutePath() + "] setup using the content of [" + from.getAbsolutePath() + "]"));
            File examples = new File(from, "examples");
            File[] files = examples.listFiles(new FileFilter(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean accept(File pathname) {
                    if (pathname.getName().endsWith(".DS_Store")) {
                        return false;
                    }
                    if (OlapDevelopmentRuntime.isWindows()) {
                        return true;
                    }
                    return folders.contains(pathname.getName());
                }
            });
            if (files != null && files.length > 0) {
                OlapLoggers.SERVER.info((Object)("/cubes (dev: examples[" + String.valueOf(folders) + "]) : " + files.length));
                for (File file : files) {
                    File to = new File(directory.asFile(), file.getName());
                    CdVFileSystemUtils.copyDirectory((File)file, (File)to);
                }
            }
        }
        catch (ClosedByInterruptException ignored) {
            OlapLoggers.GENERAL.warn((Object)"interrupted : setUpExamplesCubesDirectory()");
        }
        catch (IOException ex) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /cubes directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]."), (Throwable)ex);
        }
    }

    @Override
    public void setUpRolesDirectory(OlapDirectoriesConfiguration directories) {
        if (Kind.UNIT_TEST == this.runtimeKind || Kind.UNIT_TEST_EX == this.runtimeKind) {
            String tst = System.getProperty("icCube.dev.tst-data-directory");
            if (CdStringUtils.isNotNullAndNotBlank((String)tst)) {
                File initialDataDirectory = new File(tst);
                File initialRoles = new File(initialDataDirectory, "roles");
                if (initialRoles.exists()) {
                    try {
                        CdVFileSystemUtils.copyDirectory((File)initialRoles, (File)directories.getRolesDirectory().asFile());
                    }
                    catch (ClosedByInterruptException ignored) {
                        OlapLoggers.GENERAL.warn((Object)"interrupted : setUpRolesDirectory()");
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("roles directory setup error", ex);
                    }
                } else {
                    this._setUpRolesDirectory(directories);
                }
            } else {
                this._setUpRolesDirectory(directories);
            }
        } else if (Kind.JCR_UNIT_TEST == this.runtimeKind) {
            super.setUpRolesDirectory(directories);
        } else if (Kind.PERFORMANCE_TEST == this.runtimeKind) {
            super.setUpRolesDirectory(directories);
        } else if (Kind.NON_REGRESSION_TEST == this.runtimeKind) {
            super.setUpRolesDirectory(directories);
        } else if (Kind.LIVEDEMO == this.runtimeKind) {
            super.setUpRolesDirectory(directories);
        } else if (Kind.MULTI_TENANT == this.runtimeKind) {
            super.setUpRolesDirectory(directories);
        } else if (Kind.DEMO3 == this.runtimeKind) {
            super.setUpRolesDirectory(directories);
        } else {
            super.setUpRolesDirectory(directories);
        }
    }

    private void _setUpRolesDirectory(OlapDirectoriesConfiguration directories) {
        OlapRolesDirectoryConfiguration directory = directories.getRolesDirectory();
        if (!directory.wasCreated()) {
            return;
        }
        File from = new File(this.getInstallBinDirectory(), "icCubeRoles.icc-roles");
        try {
            CdVFileSystem vfs = this.getVfs();
            OlapLoggers.SERVER.info((Object)("[directory] /roles directory setup using [" + from.getAbsolutePath() + "]"));
            File to = new File(directory.asFile(), "icCubeRoles.icc-roles");
            vfs.copyForDirectoryInitOnStartup(from, to);
        }
        catch (ClosedByInterruptException ignored) {
            OlapLoggers.GENERAL.warn((Object)"interrupted : _setUpRolesDirectory()");
        }
        catch (IOException ignored) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /roles directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]."), (Throwable)ignored);
        }
    }

    @Override
    public void setUpUsersDirectory(OlapDirectoriesConfiguration directories) {
        if (Kind.UNIT_TEST == this.runtimeKind || Kind.UNIT_TEST_EX == this.runtimeKind) {
            String tst = System.getProperty("icCube.dev.tst-data-directory");
            if (CdStringUtils.isNotNullAndNotBlank((String)tst)) {
                File initialDataDirectory = new File(tst);
                File initialUsers = new File(initialDataDirectory, "users");
                if (initialUsers.exists()) {
                    try {
                        CdVFileSystemUtils.copyDirectory((File)initialUsers, (File)directories.getUsersDirectory().asFile());
                    }
                    catch (ClosedByInterruptException ignored) {
                        OlapLoggers.GENERAL.warn((Object)"interrupted : setUpUsersDirectory()");
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("users directory setup error", ex);
                    }
                } else {
                    this._setUpUsersDirectory(directories);
                }
            } else {
                this._setUpUsersDirectory(directories);
            }
        } else if (Kind.JCR_UNIT_TEST == this.runtimeKind) {
            super.setUpUsersDirectory(directories);
        } else if (Kind.PERFORMANCE_TEST == this.runtimeKind) {
            super.setUpUsersDirectory(directories);
        } else if (Kind.NON_REGRESSION_TEST == this.runtimeKind) {
            super.setUpUsersDirectory(directories);
        } else if (Kind.LIVEDEMO == this.runtimeKind) {
            super.setUpUsersDirectory(directories);
        } else if (Kind.MULTI_TENANT == this.runtimeKind) {
            super.setUpUsersDirectory(directories);
        } else if (Kind.DEMO3 == this.runtimeKind) {
            super.setUpUsersDirectory(directories);
        } else if (Kind.INSANE_SCHEMA_COUNT == this.runtimeKind) {
            super.setUpUsersDirectory(directories);
        } else {
            super.setUpUsersDirectory(directories);
        }
    }

    private void _setUpUsersDirectory(OlapDirectoriesConfiguration directories) {
        OlapUsersDirectoryConfiguration directory = directories.getUsersDirectory();
        if (!directory.wasCreated()) {
            return;
        }
        File from = new File(this.getInstallBinDirectory(), "icCubeUsers.icc-users");
        try {
            CdVFileSystem vfs = this.getVfs();
            OlapLoggers.SERVER.info((Object)("[directory] /users directory setup using [" + from.getAbsolutePath() + "]"));
            File to = new File(directory.asFile(), "icCubeUsers.icc-users");
            vfs.copyForDirectoryInitOnStartup(from, to);
        }
        catch (ClosedByInterruptException ignored) {
            OlapLoggers.GENERAL.warn((Object)"interrupted : _setUpUsersDirectory()");
        }
        catch (IOException ignored) {
            OlapLoggers.SERVER.warn((Object)("unexpected error during the setup of the /users directory [" + directory.asFile().getAbsolutePath() + "] [install:" + from.getAbsolutePath() + "]."), (Throwable)ignored);
        }
    }

    public File getEtcDirectory() {
        File install = this.getInstallDirectory();
        if (install == null) {
            throw new RuntimeException("Missing install directory !");
        }
        File etc = new File(install, "etc");
        if (!etc.exists()) {
            throw new RuntimeException("Missing /etc directory !");
        }
        return etc;
    }

    public static enum Kind {
        UNIT_TEST("unit-test"),
        UNIT_TEST_EX("unit-test-ex"),
        JCR_UNIT_TEST("jcr-unit-test"),
        NON_REGRESSION_TEST("non-regression-test"),
        PERFORMANCE_TEST("performance-test"),
        LIVEDEMO("livedemo"),
        MULTI_TENANT("multi-tenant"),
        DEMO3("demo3"),
        INSANE_SCHEMA_COUNT("insane-schema-count"),
        DEFAULT("");

        private String val;

        private Kind(String val) {
            this.val = val;
        }

        static Kind fromSystemProperty() {
            String runMode = System.getProperty(OlapDevelopmentRuntime.IC_CUBE_DEV_RUNTIME_KIND);
            if (Kind.UNIT_TEST.val.equals(runMode)) {
                return UNIT_TEST;
            }
            if (Kind.UNIT_TEST_EX.val.equals(runMode)) {
                return UNIT_TEST_EX;
            }
            if (Kind.JCR_UNIT_TEST.val.equals(runMode)) {
                return JCR_UNIT_TEST;
            }
            if (Kind.NON_REGRESSION_TEST.val.equals(runMode)) {
                return NON_REGRESSION_TEST;
            }
            if (Kind.PERFORMANCE_TEST.val.equals(runMode)) {
                return PERFORMANCE_TEST;
            }
            if (Kind.LIVEDEMO.val.equals(runMode)) {
                return LIVEDEMO;
            }
            if (Kind.MULTI_TENANT.val.equals(runMode)) {
                return MULTI_TENANT;
            }
            if (Kind.DEMO3.val.equals(runMode)) {
                return DEMO3;
            }
            if (Kind.INSANE_SCHEMA_COUNT.val.equals(runMode)) {
                return INSANE_SCHEMA_COUNT;
            }
            return DEFAULT;
        }
    }
}

