/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.roaring;

import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.PeekableIntIterator;

public class RoaringUtil {
    public static boolean isAndEmpty(ImmutableBitmapDataProvider ... bitmaps) {
        return RoaringUtil.apply(bitmaps, value -> false);
    }

    public static boolean apply(@Nullable ImmutableBitmapDataProvider[] bitmaps, IntPredicate callback) {
        int i;
        if (bitmaps == null || bitmaps.length == 0) {
            return true;
        }
        if (bitmaps.length == 1) {
            PeekableIntIterator iter = bitmaps[0].getIntIterator();
            while (iter.hasNext()) {
                if (callback.test(iter.next())) continue;
                return false;
            }
            return true;
        }
        PeekableIntIterator[] iters = new PeekableIntIterator[bitmaps.length];
        for (i = 0; i < bitmaps.length; ++i) {
            iters[i] = bitmaps[i].getIntIterator();
        }
        i = 0;
        int currentI = -1;
        int currentBit = 0;
        int lengthMinusOne = iters.length - 1;
        while (true) {
            int nextI;
            PeekableIntIterator iter = iters[i];
            iter.advanceIfNeeded(currentBit);
            if (!iter.hasNext()) {
                return true;
            }
            int next = iter.next();
            int n = nextI = i >= lengthMinusOne ? 0 : i + 1;
            if (next > currentBit) {
                currentBit = next;
                currentI = i;
            } else if (nextI == currentI && !callback.test(currentBit)) {
                return false;
            }
            i = nextI;
        }
    }

    @FunctionalInterface
    public static interface IntPredicate {
        public boolean test(int var1);
    }
}

