/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.riskpro;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderLinkXmlDefinition;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcSimilarTo;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcStatementDataTable;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryDataSource;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryLineDataTable;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderCube;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.builder.model.impl.OlapBuilderPerspective;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderMultiLevelDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderParentChildDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderStatisticalDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderParentChildHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchyLevel;
import crazydev.iccube.builder.type.MemberPropertyConsistencyCheckType;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.enums.OlapMemberOrderKind;
import crazydev.iccube.riskpro.RPAccount;
import crazydev.iccube.riskpro.RPCube;
import crazydev.iccube.riskpro.RPDimTable;
import crazydev.iccube.riskpro.RPDimension;
import crazydev.iccube.riskpro.RPHierarchy;
import crazydev.iccube.riskpro.RPHierarchyNode;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class RPSchema {
    static final String PREFIX_DIM_TABLE = "DIM_";
    static final String PREFIX_HIERARCHY_TABLE = "HIERARCHY_";
    List<RPCube> cubes;
    RPHierarchy accountsHierarchy;
    List<RPHierarchy> hierarchies;
    Map<String, RPDimTable> dimTables;
    final List<RPAccount> accounts = new ArrayList<RPAccount>();
    final AtomicLong accountOrderId = new AtomicLong(0L);
    final AtomicLong accountId = new AtomicLong(0L);
    final Map<String, IOlapBuilderDataTableDef> xmlTables = new HashMap<String, IOlapBuilderDataTableDef>();
    final List<String> invisibleMembers = new ArrayList<String>();

    public void fixManualExport(@Nullable String export) {
        if ("HVaR".equals(export)) {
            this.cubes.forEach(cube -> {
                cube.measures = cube.measures.stream().filter(measure -> !measure.columnName.equals("DOL_WACC_BAS_CUR") && !measure.columnName.equals("MVO_BAS_CUR") && !measure.columnName.equals("MVO_EV_CUR")).toList();
            });
        } else if ("Solve".equals(export)) {
            this.cubes.forEach(cube -> {
                cube.measures = cube.measures.stream().filter(measure -> !measure.columnName.equals("CREDIT_GAIN_LOSS_BAS_CUR") && !measure.columnName.equals("CREDIT_GAIN_LOSS_EV_CUR")).toList();
            });
        }
    }

    public String toXml(CdBabylonService babylon, Class[] meta, String name, String group, @Nullable String baseCurrency, @Nullable String msSqlJdbcURL, long solveId) throws Exception {
        OlapBuilderSchema schema = this.toSchema(babylon, name, group, baseCurrency, msSqlJdbcURL, solveId);
        OlapBuilderSchemaDefFactory schemaFactory = new OlapBuilderSchemaDefFactory(schema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            CdXmlUtils.marshall((Writer)writer, (Object)schemaFactory, (Class[])meta);
        }
        return out.toString(StandardCharsets.UTF_8);
    }

    public OlapBuilderSchema toSchema(CdBabylonService babylon, String name, String group, @Nullable String baseCurrency, @Nullable String msSqlJdbcURL, long solveId) {
        OlapBuilderJdbcDataSource dbDS;
        OlapBuilderSchema schema = new OlapBuilderSchema();
        schema.setName(name);
        schema.setGroup(group);
        schema.setDescription("Generation date : " + String.valueOf(new Date()));
        schema.setMembersUpperLowerCaseStrategy(MembersUpperLowerStrategyType.FIRST);
        schema.setMemberPropertyConsistencyCheck(MemberPropertyConsistencyCheckType.ACTIVE);
        OlapBuilderInMemoryDataSource xmlDS = new OlapBuilderInMemoryDataSource("XML");
        if (msSqlJdbcURL != null) {
            dbDS = new OlapBuilderJdbcDataSource();
            dbDS.setName("DB");
            dbDS.setSimilarTo(OlapBuilderJdbcSimilarTo.SQL_SERVER);
            dbDS.setDriverType(OlapBuilderDriverType.SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL);
            dbDS.setServerName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            dbDS.setDbName(msSqlJdbcURL);
        } else {
            dbDS = new OlapBuilderJdbcDataSource("DB", OlapBuilderDriverType.POSTGRES, "localhost", null, "riskpro", "postgres", "postgres", false);
        }
        this.createDimensionTables(solveId, xmlDS, dbDS);
        this.createFactsTables(solveId, dbDS);
        schema.addDataSource(xmlDS);
        schema.addDataSource(dbDS);
        for (IOlapBuilderDimensionDef dimension : this.createDimensions(babylon)) {
            schema.addDimension(dimension);
        }
        for (IOlapBuilderCubeDef cube : this.cubes.stream().map(c -> this.createCube(schema, (RPCube)c)).toList()) {
            schema.addCube(cube);
        }
        this.createStatistics(schema);
        this.createPerspective(schema);
        this.createScript(schema, baseCurrency != null ? baseCurrency : "EUR");
        return schema;
    }

    private void createScript(OlapBuilderSchema schema, String baseCurrency) {
        StringBuilder sb = new StringBuilder();
        MutableBoolean withCtCurrency = new MutableBoolean();
        MutableBoolean withEvCurrency = new MutableBoolean();
        this.cubes.forEach(cube -> cube.dimensions.forEach(dimension -> {
            if (dimension.dimensionName.equals("EventCurrencyId")) {
                withEvCurrency.setTrue();
            } else if (dimension.dimensionName.equals("ContractCurrencyId")) {
                withCtCurrency.setTrue();
            }
        }));
        String ec = withEvCurrency.isTrue() ? "WHEN PatternMatches(\".*EC$\", [Measures].currentMember.name) THEN RpSumCurrencies( [Currency (Event)].[Currency (Event)], ([Statistics].[StatisticsMC].[Value]) )\n" : "";
        String cc = withCtCurrency.isTrue() ? "WHEN PatternMatches(\".*CC$\", [Measures].currentMember.name) THEN RpSumCurrencies( [Currency (Ctr.)].[Currency (Ctr.)], ([Statistics].[StatisticsMC].[Value]) )\n" : "";
        sb.append("DROP *\n\nCREATE NATIVE FUNCTION RpJavaFormat( String locale, double amount, String curr ) AS\n/* JAVA : String\n\n    import crazydev.common.utils.CdLocaleUtils;\n\n    return String.format(CdLocaleUtils.fromName(locale, Locale.getDefault()), \"%,.2f\", amount) + \" \" + curr;\n\n*/\n\nCREATE FUNCTION RpBC() as \"$base_currency$\"\n\nCREATE FUNCTION RpIfEmpty( x, y ) as IIF( x is null, y, null )\n\nCREATE FUNCTION RpNextMembers( h) as IIF( h.currentMember.nextMember is null\n    , null\n    , { h.currentMember.nextMember : null }\n)\n\ncreate function RpIndex( _set, _index) as FLOOR( _index/100 * _set.count,1)-1\n\ncreate function RpQuantile( _set, _value, _i ) as  Vector(_set,_value,EXCLUDEEMPTY)->sort()->get( RpIndex( _set, _i) )\n\ncreate function RpVaR( _set, _value, _i ) as _value - Vector(_set,_value,EXCLUDEEMPTY)->sort()->get( RpIndex( _set, (1-_i)*100 ) )\n\nCREATE FUNCTION RpSumCurrenciesEx( _noEmptyCurrencies, _value) as \n    IIF( count(_noEmptyCurrencies) = 1, asCurrency(_value, {_noEmptyCurrencies}(0) ) , null)\n\nCREATE FUNCTION RpSumCurrencies( _currHier, _value) as\n    IIF( _currHier.currentMember.isDefault,\n         RpSumCurrenciesEx( Head( nonEmpty( _currHier.lastLevel.members, _value), 2), _value),\n         asCurrency( _value, _currHier.currentMember)\n   )\n\nCREATE FUNCTION withFV( _v, _curr ) as _v.withFormattedValue(\n    RpJavaFormat(UserLocale(), _v , _curr)\n)\n\nCREATE FUNCTION asBaseCurrency(Value _v) as IIF(\n    _v is NULL, NULL, withFV( _v , RpBC() )\n)\n\nCREATE FUNCTION asCurrency(Value _v, _currency) as IIF(\n    _v is NULL, NULL, withFV( _v , _currency.name )\n)\n\nCREATE MEMBER [Statistics].[StatisticsMC].[ValueMC] as\n    CASE\n        $ec$\n        $cc$\n        WHEN PatternMatches(\".*BC$\", [Measures].currentMember.name) THEN asBaseCurrency( [Statistics].[StatisticsMC].[Value] )\n        ELSE asBaseCurrency( [Statistics].[StatisticsMC].[Value] )\n    END\n    ,SOLVE_ORDER = 2147483647, FORMAT_STRING = \"$Embedded$\"\n\n".replace("$base_currency$", baseCurrency).replace("$ec$", ec).replace("$cc$", cc));
        schema.getCubes().forEach(cube -> {
            String cn = CdMdxUtils.escape((String)cube.getName());
            sb.append(String.format("CREATE MEMBER [Statistics].[StatisticsMC].[ValueMC %s] as [Statistics].[StatisticsMC].[ValueMC]\n    ,SOLVE_ORDER = 2147483647, NON_EMPTY_BEHAVIOR = [%s]\n\n", cn, cn));
        });
        schema.setScript(new OlapBuilderScript(sb.toString()));
    }

    private void createPerspective(OlapBuilderSchema schema) {
        if (!this.invisibleMembers.isEmpty()) {
            schema.addPerspective(new OlapBuilderPerspective("$Equity$", this.invisibleMembers.stream().map(m -> "-" + m + "\n").collect(Collectors.joining()), true));
        }
    }

    private void createStatistics(OlapBuilderSchema schema) {
        schema.addDimension(new OlapBuilderStatisticalDimension("Statistics", "Value", "Statistics", "StatisticsMC"));
    }

    private List<IOlapBuilderDimensionDef> createDimensions(CdBabylonService babylon) {
        HashSet done = new HashSet();
        ArrayList<IOlapBuilderDimensionDef> xmlDimensions = new ArrayList<IOlapBuilderDimensionDef>();
        this.cubes.forEach(cube -> cube.dimensions.forEach(dimension -> {
            if (!done.contains(dimension.dimensionName)) {
                xmlDimensions.add(this.createDimension(babylon, (RPDimension)dimension));
                done.add(dimension.dimensionName);
            }
        }));
        return xmlDimensions;
    }

    private IOlapBuilderDimensionDef createDimension(CdBabylonService babylon, RPDimension dimension) {
        HashMap<String, RPHierarchy> hierarchyTables = new HashMap<String, RPHierarchy>();
        this.hierarchies.forEach(hierarchy -> hierarchyTables.put(hierarchy.name, (RPHierarchy)hierarchy));
        if (this.accountsHierarchy != null) {
            hierarchyTables.put("ACCOUNT_ID", this.accountsHierarchy);
        }
        IOlapBuilderDataTableDef xmlTable = this.getXmlTable("dimension", dimension.dimensionName);
        if ("EMDate".equals(dimension.type)) {
            return this.createTimeDimension(babylon, dimension, xmlTable);
        }
        OlapBuilderMultiLevelDimension xmlDimension = new OlapBuilderMultiLevelDimension();
        xmlDimension.setName(dimension.caption);
        xmlDimension.setDataTableId(xmlTable.getId());
        if (dimension.columnName.equals("CONTRACT_ID")) {
            xmlDimension.setUnknownMemberName("$ Unknown $");
        }
        OlapBuilderMultiLevelHierarchy xmlHierarchy = new OlapBuilderMultiLevelHierarchy();
        xmlHierarchy.setName(dimension.caption);
        xmlHierarchy.setDefault(true);
        xmlDimension.addHierarchy(xmlHierarchy);
        if (dimension.aggregable) {
            xmlHierarchy.setHasAllLevel(true);
            xmlHierarchy.setAllLevelName("All-Level");
            xmlHierarchy.setAllMemberName("All");
        }
        if (dimension.dataTable) {
            RPDimTable dimTable = this.getRPDimTable(dimension.columnName);
            OlapBuilderHierarchyLevel xmlLevel = new OlapBuilderHierarchyLevel();
            xmlLevel.setName(dimension.caption);
            xmlLevel.setKeyColsRef(this.getKeyColumnRefs(xmlTable, dimension.dimensionName, dimTable.keyColumnName));
            xmlLevel.setNameColRef(this.getColumnRef(xmlTable, dimension.dimensionName, dimension.dimensionName + "_NAME"));
            xmlLevel.setOrderKind(OlapMemberOrderKind.ASC);
            xmlLevel.setOrderMembersByType(OlapMemberOrderByType.BY_COLUMN);
            xmlLevel.setOrderMembersColumn(this.getColumnDef(xmlTable, dimension.dimensionName, dimension.dimensionName + "_RANK"));
            xmlHierarchy.addLevel(xmlLevel);
        } else {
            RPHierarchy hierarchyTable = (RPHierarchy)hierarchyTables.get(dimension.columnName);
            if (hierarchyTable != null) {
                if ("ACCOUNT_ID".equals(dimension.columnName)) {
                    return this.createAccountDimension(dimension, xmlTable);
                }
                int levelCount = hierarchyTable.nodes.getFirst().levels.size();
                for (int ll = 0; ll < levelCount; ++ll) {
                    OlapBuilderHierarchyLevel xmlLevel = new OlapBuilderHierarchyLevel();
                    if (ll < levelCount - 1) {
                        xmlLevel.setName(dimension.caption + "_" + ll);
                        xmlLevel.setKeyColsRef(this.getKeyColumnRefs(xmlTable, dimension.dimensionName, "LEVEL_" + ll));
                        xmlLevel.setNameColRef(this.getColumnRef(xmlTable, dimension.dimensionName, "LEVEL_" + ll));
                        xmlLevel.clearUniques();
                    } else {
                        xmlLevel.setName(dimension.caption);
                        xmlLevel.setKeyColsRef(this.getKeyColumnRefs(xmlTable, dimension.dimensionName, dimension.columnName));
                        xmlLevel.setNameColRef(this.getColumnRef(xmlTable, dimension.dimensionName, "LEVEL_" + ll));
                        xmlLevel.clearUniques();
                    }
                    xmlHierarchy.addLevel(xmlLevel);
                }
            } else {
                OlapBuilderHierarchyLevel xmlLevel = new OlapBuilderHierarchyLevel();
                xmlLevel.setName(dimension.caption);
                xmlLevel.setKeyColsRef(this.getKeyColumnRefs(xmlTable, dimension.dimensionName, dimension.columnName));
                if (!dimension.columnName.equals("CONTRACT_ID")) {
                    xmlLevel.setNameColRef(this.getColumnRef(xmlTable, dimension.dimensionName, dimension.columnName));
                } else {
                    xmlLevel.setNameColRef(this.getColumnRef(xmlTable, dimension.dimensionName, "CONTRACT_NAME"));
                }
                xmlHierarchy.addLevel(xmlLevel);
            }
        }
        return xmlDimension;
    }

    private IOlapBuilderDimensionDef createTimeDimension(CdBabylonService babylon, RPDimension dimension, IOlapBuilderDataTableDef xmlTable) {
        OlapBuilderTimeWizardDimension dimensionT = new OlapBuilderTimeWizardDimension();
        dimensionT.setName(dimension.caption);
        dimensionT.setDataTableId_(xmlTable.getId());
        dimensionT.setTimeWizardColumnRef(this.getColumnRef(xmlTable, dimension.dimensionName, dimension.columnName));
        dimensionT.setIndexingByRange(false);
        dimensionT.setUnknownMemberName("No Date");
        OlapBuilderTimeWizardHierarchy hierarchyT = new OlapBuilderTimeWizardHierarchy();
        hierarchyT.setName(dimensionT.getName());
        hierarchyT.setDefault(true);
        hierarchyT.setHasAllLevel(true);
        List<OlapLevelType> levels = List.of(OlapLevelType.YEAR, OlapLevelType.MONTH, OlapLevelType.DAY);
        levels.forEach(type -> hierarchyT.addLevel(new OlapBuilderTimeWizardHierarchyLevel(babylon.translate((Enum)type), (OlapLevelType)((Object)type))));
        dimensionT.addHierarchy(hierarchyT);
        return dimensionT;
    }

    private IOlapBuilderDimensionDef createAccountDimension(RPDimension dimension, IOlapBuilderDataTableDef xmlTable) {
        OlapBuilderParentChildDimension xmlDimension = new OlapBuilderParentChildDimension();
        xmlDimension.setName(dimension.caption);
        xmlDimension.setDataTableId(xmlTable.getId());
        OlapBuilderParentChildHierarchy xmlHierarchy = new OlapBuilderParentChildHierarchy();
        xmlHierarchy.setName(dimension.caption);
        xmlHierarchy.setDefault(true);
        if (dimension.aggregable) {
            xmlHierarchy.setFirstLevelIsAll();
            xmlHierarchy.setAddAllMemberName("All");
            xmlHierarchy.setLevelNamePattern(dimension.dimensionName + ".$");
        }
        xmlHierarchy.setMemberNameColumn(this.getColumnRef(xmlTable, dimension.dimensionName, dimension.columnName + "_NAME"));
        xmlHierarchy.setNodeIdColumn(this.getColumnRef(xmlTable, dimension.dimensionName, dimension.columnName));
        xmlHierarchy.setParentNodeIdColumn(this.getColumnRef(xmlTable, dimension.dimensionName, dimension.columnName + "_PARENT"));
        xmlHierarchy.setOrderKind(OlapMemberOrderKind.ASC);
        xmlHierarchy.setOrderMembersByType(OlapMemberOrderByType.BY_COLUMN);
        xmlHierarchy.setOrderMembersColumnRef(this.getColumnRef(xmlTable, dimension.dimensionName, dimension.columnName + "_ORDER"));
        xmlDimension.addHierarchy(xmlHierarchy);
        return xmlDimension;
    }

    private List<OlapBuilderDataColumnRef> getKeyColumnRefs(IOlapBuilderDataTableDef xmlTable, String dimension, String name) {
        IOlapBuilderDataColumnDef column = xmlTable.lookupSelectedColumn(name);
        if (column == null) {
            throw new RuntimeException("internal error : missing key column [" + name + "] from table for dimension [" + dimension + "]");
        }
        return List.of(new OlapBuilderDataColumnRef(column.getName()));
    }

    private OlapBuilderDataColumnRef getColumnRef(IOlapBuilderDataTableDef xmlTable, String dimension, String name) {
        IOlapBuilderDataColumnDef column = xmlTable.lookupSelectedColumn(name);
        if (column == null) {
            throw new RuntimeException("internal error : missing column [" + name + "] from table for dimension [" + dimension + "]");
        }
        return new OlapBuilderDataColumnRef(column.getName());
    }

    private IOlapBuilderDataColumnDef getColumnDef(IOlapBuilderDataTableDef xmlTable, String dimension, String name) {
        IOlapBuilderDataColumnDef column = xmlTable.lookupSelectedColumn(name);
        if (column == null) {
            throw new RuntimeException("internal error : missing column [" + name + "] from table for dimension [" + dimension + "]");
        }
        return column;
    }

    private IOlapBuilderCubeDef createCube(OlapBuilderSchema schema, RPCube cube) {
        IOlapBuilderDataTableDef xmlTable = this.getXmlTable("cube", cube.name);
        OlapBuilderFacts xmlFacts = new OlapBuilderFacts();
        xmlFacts.setMeasureGroupName(cube.caption);
        xmlFacts.setDataTableId(xmlTable.getId());
        cube.measures.forEach(measure -> {
            OlapBuilderMeasure xmlMeasure = new OlapBuilderMeasure();
            xmlMeasure.setColumnRef(this.getColumnRef(xmlTable, cube.name, measure.columnName));
            xmlMeasure.setName(measure.caption);
            xmlMeasure.setAggregationType(measure.aggregable ? OlapAggregationType.SUM : OlapAggregationType.NONE);
            Object cellProperties = "";
            if (CdStringUtils.isNotNullAndNotBlank((String)measure.folder)) {
                cellProperties = (String)cellProperties + "DISPLAY_FOLDER=\"\\" + measure.folder + "\"";
            }
            if (!((String)cellProperties).isEmpty()) {
                xmlMeasure.setCellProperties((String)cellProperties);
            }
            xmlFacts.addMeasure(xmlMeasure);
        });
        HashMap cubeDimensions = new HashMap();
        cube.dimensions.forEach(dimension -> cubeDimensions.put(dimension.caption, dimension));
        ArrayList<OlapBuilderLinkXmlDefinition> links = new ArrayList<OlapBuilderLinkXmlDefinition>();
        for (IOlapBuilderDimensionDef dimension2 : schema.getDimensions()) {
            List<OlapBuilderDataColumnRef> toColumns;
            List<OlapBuilderDataColumnRef> fromColumns;
            RPDimension cubeDimension = (RPDimension)cubeDimensions.get(dimension2.getName());
            if (cubeDimension == null) {
                links.add(new OlapBuilderLinkXmlDefinition(dimension2.getId(), dimension2.getName(), new OlapBuilderDataViewLinks(OlapBuilderDataViewLinksType.NOT_MAPPED)));
                continue;
            }
            Object defaultHierarchy = dimension2.getDefaultHierarchy();
            if (defaultHierarchy == null) {
                throw new RuntimeException("internal error : cannot link " + dimension2.getName() + " : missing default hierarchy");
            }
            if (defaultHierarchy instanceof OlapBuilderParentChildHierarchy) {
                OlapBuilderParentChildHierarchy pc = (OlapBuilderParentChildHierarchy)defaultHierarchy;
                fromColumns = List.of();
                toColumns = List.of(new OlapBuilderDataColumnRef(cubeDimension.columnName));
                links.add(new OlapBuilderLinkXmlDefinition(dimension2.getId(), dimension2.getName(), OlapBuilderDataViewLinks.createFromColumnsRef(OlapBuilderDataViewLinksType.ALL_LEVELS, fromColumns, toColumns)));
                continue;
            }
            fromColumns = null;
            if (!defaultHierarchy.isTimeWizard()) {
                List<IOlapBuilderHierarchyLevelDef> levels = defaultHierarchy.getLevels();
                if (levels == null || levels.isEmpty()) {
                    throw new RuntimeException("internal error : cannot link " + dimension2.getName() + " : missing levels");
                }
                IOlapBuilderHierarchyLevelDef lastLevel = levels.getLast();
                fromColumns = OlapBuilderDataColumnRef.asRef(lastLevel.getKeyColumns());
            }
            toColumns = List.of(new OlapBuilderDataColumnRef(cubeDimension.columnName));
            links.add(new OlapBuilderLinkXmlDefinition(dimension2.getId(), dimension2.getName(), OlapBuilderDataViewLinks.createFromColumnsRef(OlapBuilderDataViewLinksType.LAST_LEVEL, fromColumns, toColumns)));
        }
        xmlFacts.setLinks(links);
        OlapBuilderCube xmlCube = new OlapBuilderCube();
        xmlCube.setName(cube.caption);
        xmlCube.addFacts(xmlFacts);
        return xmlCube;
    }

    private IOlapBuilderDataTableDef getXmlTable(String reason, String name) {
        IOlapBuilderDataTableDef xmlTable = this.xmlTables.get(name);
        if (xmlTable == null) {
            throw new RuntimeException("internal error: missing table for " + reason + " " + name);
        }
        return xmlTable;
    }

    private void createDimensionTables(long solveId, OlapBuilderInMemoryDataSource xmlDS, OlapBuilderJdbcDataSource dbDS) {
        HashMap<String, RPHierarchy> hierarchyTables = new HashMap<String, RPHierarchy>();
        this.hierarchies.forEach(hierarchy -> hierarchyTables.put(hierarchy.name, (RPHierarchy)hierarchy));
        if (this.accountsHierarchy != null) {
            hierarchyTables.put("ACCOUNT_ID", this.accountsHierarchy);
        }
        this.cubes.forEach(cube -> cube.dimensions.forEach(dimension -> {
            if (!dimension.storedOnFactTable) {
                throw new RuntimeException("internal error : " + String.valueOf(cube) + "." + String.valueOf(dimension) + " not storedOnFactTable");
            }
        }));
        this.cubes.forEach(cube -> cube.dimensions.forEach(dimension -> {
            if (!this.xmlTables.containsKey(dimension.dimensionName)) {
                if (dimension.dataTable) {
                    OlapBuilderInMemoryLineDataTable xmlTable = this.createDimTableFromJson((RPDimension)dimension);
                    xmlDS.addTable(xmlTable);
                    this.xmlTables.put(dimension.dimensionName, xmlTable);
                } else {
                    RPHierarchy hierarchyTable = (RPHierarchy)hierarchyTables.get(dimension.columnName);
                    if (hierarchyTable != null) {
                        OlapBuilderInMemoryLineDataTable xmlTable = this.createDimTableFromJson((RPDimension)dimension, hierarchyTable);
                        xmlDS.addTable(xmlTable);
                        this.xmlTables.put(dimension.dimensionName, xmlTable);
                    }
                }
            }
        }));
        HashMap dbDimensions = new HashMap();
        this.cubes.forEach(cube -> cube.dimensions.forEach(dimension -> {
            if (!dimension.dataTable && !hierarchyTables.containsKey(dimension.columnName)) {
                List shared = dbDimensions.computeIfAbsent(dimension.dimensionName, k -> new ArrayList());
                shared.add(cube);
            }
        }));
        for (Map.Entry entry : dbDimensions.entrySet()) {
            String dimensionName = (String)entry.getKey();
            List sharedDimensions = (List)entry.getValue();
            OlapBuilderJdbcStatementDataTable xmlTable = this.createDimTableFromDB(solveId, dbDS, sharedDimensions, dimensionName);
            dbDS.addTable(xmlTable);
            this.xmlTables.put(dimensionName, xmlTable);
        }
    }

    private OlapBuilderJdbcStatementDataTable createDimTableFromDB(long solveId, OlapBuilderJdbcDataSource dbDS, List<RPCube> sharedDimensions, String dimensionName) {
        MutableObject dimensionREF = new MutableObject();
        sharedDimensions.forEach(c -> {
            if (dimensionREF.get() == null) {
                c.dimensions.forEach(d -> {
                    if (d.dimensionName.equals(dimensionName)) {
                        dimensionREF.setValue(d);
                    }
                });
            }
        });
        RPDimension dimension = (RPDimension)dimensionREF.get();
        if (dimension == null) {
            throw new RuntimeException("internal error : missing dimension " + dimensionName);
        }
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        columns.add(new OlapBuilderDataColumn(RPSchema.columnType(dimension.type), dimension.type, dimension.columnName, "String".equals(dimension.type) ? "-" : null));
        if (dimension.columnName.equals("CONTRACT_ID")) {
            columns.add(new OlapBuilderDataColumn(RPSchema.columnType("String"), "String", "CONTRACT_NAME"));
        }
        String statement = columns.size() == 1 && "EMDate".equals(((IOlapBuilderDataColumnDef)columns.getFirst()).getTableType()) ? this.createSqlForDimTableFromDB_date(solveId, dbDS, sharedDimensions, (IOlapBuilderDataColumnDef)columns.getFirst()) : this.createSqlForDimTableFromDB(solveId, dbDS, sharedDimensions, columns);
        OlapBuilderJdbcStatementDataTable table = new OlapBuilderJdbcStatementDataTable(PREFIX_DIM_TABLE + dimensionName, statement);
        for (IOlapBuilderDataColumnDef column : columns) {
            table.addColumn(column);
        }
        return table;
    }

    private String createSqlForDimTableFromDB_date(long solveId, OlapBuilderJdbcDataSource dbDS, List<RPCube> sharedDimensions, IOlapBuilderDataColumnDef column) {
        String colName = RPSchema.jdbcColumnName(dbDS, column.getName());
        StringBuilder min = new StringBuilder();
        min.append("select min(IC3_DATE) IC3_DATE from (");
        for (int cc = 0; cc < sharedDimensions.size(); ++cc) {
            if (cc > 0) {
                min.append("\n  union all");
            }
            min.append("\n").append(" select min(" + colName + ") as IC3_DATE").append(" from ").append(RPSchema.jdbcTableName(dbDS, sharedDimensions.get((int)cc).dbTable)).append(" where ").append(colName).append(" > 0").append(" and ").append(RPSchema.jdbcColumnName(dbDS, "SLV_JOB_ID")).append(" = ").append(solveId);
        }
        min.append("\n) as combined");
        StringBuilder max = new StringBuilder();
        max.append("select max(IC3_DATE) as IC3_DATE from (");
        for (int cc = 0; cc < sharedDimensions.size(); ++cc) {
            if (cc > 0) {
                max.append("\n  union all");
            }
            max.append("\n").append(" select max(" + colName + ") as IC3_DATE").append(" from ").append(RPSchema.jdbcTableName(dbDS, sharedDimensions.get((int)cc).dbTable)).append(" where ").append(colName).append(" > 0").append(" and ").append(RPSchema.jdbcColumnName(dbDS, "SLV_JOB_ID")).append(" = ").append(solveId);
        }
        max.append("\n) as combined");
        StringBuilder sb = new StringBuilder();
        sb.append("select [dbo].[PR_JULIAN_RP_TO_DATE](IC3_DATE) as " + colName + " from (").append("\n").append((CharSequence)min).append("\nunion all").append("\n").append((CharSequence)max).append("\n) as combined");
        return sb.toString();
    }

    private String createSqlForDimTableFromDB(long solveId, OlapBuilderJdbcDataSource dbDS, List<RPCube> sharedDimensions, List<IOlapBuilderDataColumnDef> columns) {
        List<String> colNames = columns.stream().map(c -> RPSchema.jdbcColumnName(dbDS, c)).toList();
        if (sharedDimensions.size() == 1) {
            return "select distinct " + String.join((CharSequence)",", colNames) + " from " + RPSchema.jdbcTableName(dbDS, sharedDimensions.getFirst().dbTable) + " where " + colNames.getFirst() + " is not null and " + RPSchema.jdbcColumnName(dbDS, "SLV_JOB_ID") + " = " + solveId;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct ").append(String.join((CharSequence)",", colNames)).append(" from (");
        for (int cc = 0; cc < sharedDimensions.size(); ++cc) {
            if (cc > 0) {
                sb.append("\n  union all");
            }
            sb.append("\n").append("  select distinct ").append(String.join((CharSequence)",", colNames)).append(" from ").append(RPSchema.jdbcTableName(dbDS, sharedDimensions.get((int)cc).dbTable)).append(" where ").append(colNames.getFirst()).append(" is not null").append(" and ").append(RPSchema.jdbcColumnName(dbDS, "SLV_JOB_ID")).append(" = ").append(solveId);
        }
        sb.append("\n) as combined");
        return sb.toString();
    }

    private OlapBuilderInMemoryLineDataTable createDimTableFromJson(RPDimension dimension) {
        String dimensionName = dimension.dimensionName;
        RPDimTable dim = this.getRPDimTable(dimension.columnName);
        OlapBuilderInMemoryLineDataTable table = new OlapBuilderInMemoryLineDataTable(PREFIX_DIM_TABLE + dimensionName);
        String columnSeparator = "\t";
        table.setColumnSeparator("\t");
        table.addColumn(new OlapBuilderDataColumn(RPSchema.columnType(dim.keyType), "STRING", dim.keyColumnName));
        table.addColumn(new OlapBuilderDataColumn(RPSchema.columnType("Integer"), "STRING", dimensionName + "_RANK"));
        table.addColumn(new OlapBuilderDataColumn(RPSchema.columnType("String"), "STRING", dimensionName + "_NAME"));
        if (dim.values.isEmpty()) {
            throw new RuntimeException("internal error: missing dimension [" + dimensionName + "] from dimTables with no values");
        }
        String header = table.getAllColumns().stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.joining("\t"));
        StringBuilder content = new StringBuilder(header);
        dim.values.forEach(value -> {
            content.append("\n");
            content.append(value.id).append("\t").append(value.rank).append("\t").append(RPSchema.escapeColumnSeparator("\t", value.name));
        });
        table.setDataAsString(content.toString());
        return table;
    }

    private OlapBuilderInMemoryLineDataTable createDimTableFromJson(RPDimension dimension, RPHierarchy hierarchy) {
        if (hierarchy.levelNames != null) {
            throw new RuntimeException("internal error: levelNames [" + String.valueOf(hierarchy.levelNames) + "] not supported for hierarchy " + dimension.dimensionName);
        }
        if (hierarchy.nodes.isEmpty()) {
            throw new RuntimeException("internal error: empty nodes not supported for hierarchy " + dimension.dimensionName);
        }
        int levelCount = hierarchy.nodes.getFirst().levels.size();
        hierarchy.nodes.forEach(node -> {
            if (node.levels.size() != levelCount) {
                throw new RuntimeException("internal error: nodes level count mismatch not supported for hierarchy " + dimension.dimensionName);
            }
        });
        String dimensionName = dimension.dimensionName;
        OlapBuilderInMemoryLineDataTable table = new OlapBuilderInMemoryLineDataTable(PREFIX_HIERARCHY_TABLE + dimensionName);
        String columnSeparator = "\t";
        table.setColumnSeparator("\t");
        if ("ACCOUNT_ID".equals(dimension.columnName)) {
            return this.createAccountDimTableFromJson(table, "\t", dimension, hierarchy);
        }
        for (int ll = 0; ll < levelCount; ++ll) {
            table.addColumn(new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "STRING", "LEVEL_" + ll));
            if (ll != levelCount - 1) continue;
            table.addColumn(new OlapBuilderDataColumn(RPSchema.columnType(dimension.type), "STRING", dimension.columnName));
        }
        String header = table.getAllColumns().stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.joining("\t"));
        StringBuilder content = new StringBuilder(header);
        hierarchy.nodes.forEach(node -> {
            content.append("\n");
            for (int ll = 0; ll < levelCount; ++ll) {
                if (ll > 0) {
                    content.append("\t");
                }
                content.append(RPSchema.escapeColumnSeparator("\t", node.levels.get(ll)));
                if (ll != levelCount - 1) continue;
                content.append("\t").append(node.id);
            }
            if (!node.visible) {
                this.registerInvisibleMember(dimension.caption, node.levels);
            }
        });
        table.setDataAsString(content.toString());
        return table;
    }

    private OlapBuilderInMemoryLineDataTable createAccountDimTableFromJson(OlapBuilderInMemoryLineDataTable table, String columnSeparator, RPDimension dimension, RPHierarchy hierarchy) {
        table.addColumn(new OlapBuilderDataColumn(RPSchema.columnType(dimension.type), "STRING", dimension.columnName + "_ORDER"));
        table.addColumn(new OlapBuilderDataColumn(RPSchema.columnType(dimension.type), "STRING", dimension.columnName + "_PARENT"));
        table.addColumn(new OlapBuilderDataColumn(RPSchema.columnType(dimension.type), "STRING", dimension.columnName));
        table.addColumn(new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "STRING", dimension.columnName + "_NAME"));
        String header = table.getAllColumns().stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.joining(columnSeparator));
        StringBuilder content = new StringBuilder(header);
        this.createAccounts(dimension, hierarchy);
        for (RPAccount account : this.accounts) {
            this.populateAccountDimTable(content, columnSeparator, account);
        }
        table.setDataAsString(content.toString());
        return table;
    }

    private void populateAccountDimTable(StringBuilder content, String columnSeparator, RPAccount account) {
        content.append("\n").append(account.orderId).append(columnSeparator).append(account.parent != null ? Long.valueOf(account.parent.id) : "").append(columnSeparator).append(account.id).append(columnSeparator).append(account.name);
        for (RPAccount child : account.children) {
            this.populateAccountDimTable(content, columnSeparator, child);
        }
    }

    private void createAccounts(RPDimension dimension, RPHierarchy hierarchy) {
        hierarchy.nodes.forEach(node -> this.createAccount(dimension, (RPHierarchyNode)node));
    }

    private void createAccount(RPDimension dimension, RPHierarchyNode node) {
        if (!dimension.type.equals("Long")) {
            throw new RuntimeException("internal error : unexpected accounts type [" + dimension.type + "]");
        }
        int levelCount = node.levels.size();
        RPAccount current = null;
        for (int ll = 0; ll < levelCount; ++ll) {
            String level = node.levels.get(ll);
            if (ll > 1 && level.equals(node.levels.get(ll - 1))) {
                current.id = node.id;
                if (node.visible) break;
                this.registerInvisibleMember(dimension.caption, node.levels.subList(0, ll));
                break;
            }
            if (current == null) {
                for (RPAccount account : this.accounts) {
                    if (!account.name.equals(level)) continue;
                    current = account;
                    break;
                }
                if (current == null) {
                    current = new RPAccount(null, level, this.accountOrderId.getAndIncrement());
                    this.accounts.add(current);
                }
            } else {
                boolean found = false;
                for (RPAccount account : current.children) {
                    if (!account.name.equals(level)) continue;
                    current = account;
                    found = true;
                    break;
                }
                if (!found) {
                    current = new RPAccount(current, level, this.accountOrderId.getAndIncrement());
                    current.children.add(current);
                }
            }
            if (ll == levelCount - 1) {
                current.id = node.id;
                if (node.visible) break;
                this.registerInvisibleMember(dimension.caption, node.levels);
                break;
            }
            current.id = this.accountId.decrementAndGet();
        }
    }

    private RPDimTable getRPDimTable(String dimensionName) {
        RPDimTable table = this.dimTables.get(dimensionName);
        if (table == null) {
            throw new RuntimeException("internal error: missing dimension [" + dimensionName + "] from dimTables");
        }
        return table;
    }

    private void createFactsTables(long solveId, OlapBuilderJdbcDataSource dbDS) {
        this.cubes.forEach(cube -> {
            List<IOlapBuilderDataColumnDef> columns = this.createFactsTableColumns((RPCube)cube);
            List<String> colNames = columns.stream().map(c -> RPSchema.jdbcColumnName(dbDS, c)).toList();
            String statement = "select " + String.join((CharSequence)",", colNames) + " from " + RPSchema.jdbcTableName(dbDS, cube.dbTable) + " where " + RPSchema.jdbcColumnName(dbDS, "SLV_JOB_ID") + " = " + solveId;
            OlapBuilderJdbcStatementDataTable xmlTable = new OlapBuilderJdbcStatementDataTable(cube.dbTable, statement);
            for (IOlapBuilderDataColumnDef column : columns) {
                xmlTable.addColumn(column);
            }
            dbDS.addTable(xmlTable);
            this.xmlTables.put(cube.name, xmlTable);
        });
    }

    private List<IOlapBuilderDataColumnDef> createFactsTableColumns(RPCube cube) {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        cube.dimensions.forEach(dimension -> columns.add(new OlapBuilderDataColumn(RPSchema.columnType(dimension.type), dimension.type, dimension.columnName, "String".equals(dimension.type) ? "-" : null)));
        cube.measures.forEach(measure -> columns.add(new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "Double", measure.columnName)));
        return columns;
    }

    private static String jdbcTableName(OlapBuilderJdbcDataSource dbDS, String name) {
        if (dbDS.isSqlServer()) {
            return "[dbo].[" + name + "]";
        }
        return "public." + name;
    }

    private static String jdbcColumnName(OlapBuilderJdbcDataSource dbDS, String name) {
        if (dbDS.isSqlServer()) {
            return "[" + name + "]";
        }
        return name;
    }

    private static String jdbcColumnName(OlapBuilderJdbcDataSource dbDS, IOlapBuilderDataColumnDef columnDef) {
        String name = columnDef.getName();
        if (dbDS.isSqlServer()) {
            if ("EMDate".equals(columnDef.getTableType())) {
                return "IIF( [" + name + "] < 0, null, [dbo].[PR_JULIAN_RP_TO_DATE]( [" + name + "] )) as [" + name + "]";
            }
            return "[" + name + "]";
        }
        return name;
    }

    private static OlapBuilderInputType columnType(String type) {
        return switch (type) {
            case "String" -> OlapBuilderInputType.STRING;
            case "Integer", "int" -> OlapBuilderInputType.INTEGER;
            case "Long", "long" -> OlapBuilderInputType.LONG;
            case "EMDate" -> OlapBuilderInputType.DATETIME;
            default -> throw new RuntimeException("internal error : missing table type for [" + type + "]");
        };
    }

    private static String escapeColumnSeparator(String separator, String value) {
        return value.replace(separator, " ");
    }

    private void registerInvisibleMember(String dimension, List<String> levels) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(CdMdxUtils.escape((String)dimension)).append("]").append(".[").append(CdMdxUtils.escape((String)dimension)).append("]");
        for (String level : levels) {
            sb.append(".[").append(CdMdxUtils.escape((String)level)).append("]");
            if (!level.startsWith("Equity-#$-")) continue;
            this.invisibleMembers.add(sb.toString());
        }
    }
}

