/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.task;

import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatusPhase;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeTask<REQUEST extends IcCubeRequest> {
    protected final String uid;
    protected final REQUEST request;
    @Nullable
    private final IcCubeSchemaAccessLock lock;

    protected IcCubeTask(REQUEST request, String uid, @Nullable IcCubeSchemaAccessLock lock) {
        this.uid = uid;
        this.request = request;
        this.lock = lock;
    }

    public String getTaskUid() {
        return this.uid;
    }

    public String getRequestClientUUID() {
        return ((IcCubeRequest)this.request).getClientUUID();
    }

    public Date getRequestStartDate() {
        return ((IcCubeRequest)this.request).getStartDate();
    }

    public REQUEST getRequest() {
        return this.request;
    }

    @Nullable
    public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
        return null;
    }

    public String getLockInfo() {
        if (this.lock == null) {
            return "none";
        }
        String info = this.lock.getLockInfo();
        return info;
    }

    @Nullable
    public IcCubeSchemaAccessLock getLock() {
        return this.lock;
    }

    public final boolean isAllSchema() {
        return this.lock != null && this.lock.isAllSchema();
    }

    @Nullable
    public final String getSchema() {
        return this.lock != null ? this.lock.getSchema() : null;
    }

    public final boolean isSchemaWriteAccess() {
        return this.lock != null && this.lock.isWrite();
    }

    public final boolean isSchemaReadAccess() {
        return this.lock != null && this.lock.isRead();
    }

    public final boolean isSchemaNoneAccess() {
        return this.lock != null && this.lock.isNone();
    }
}

