/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.task;

import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchemaAccessLock {
    private final boolean allSchema;
    @Nullable
    private final String schema;
    private final IcCubeSchemaAccessLockMode mode;

    private IcCubeSchemaAccessLock(boolean allSchema, String schema, IcCubeSchemaAccessLockMode mode) {
        this.allSchema = allSchema;
        this.schema = schema;
        this.mode = mode;
        if (allSchema) {
            if (schema != null) {
                throw new RuntimeException("internal error: inconsistent schema read/write lock (1)");
            }
        } else if (schema == null) {
            throw new RuntimeException("internal error: inconsistent schema read/write lock (2)");
        }
    }

    @Nullable
    public static IcCubeSchemaAccessLock create(@Nullable String schema, IcCubeSchemaAccessLockMode mode) {
        return IcCubeSchemaAccessLock.create(false, schema, mode);
    }

    @Nullable
    public static IcCubeSchemaAccessLock create(boolean allSchema, @Nullable String schema, IcCubeSchemaAccessLockMode mode) {
        if (allSchema) {
            return new IcCubeSchemaAccessLock(allSchema, schema, mode);
        }
        if (schema != null) {
            return new IcCubeSchemaAccessLock(false, schema, mode);
        }
        return null;
    }

    public boolean isAllSchema() {
        return this.allSchema;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    public boolean isWrite() {
        return this.mode == IcCubeSchemaAccessLockMode.WRITE;
    }

    public boolean isRead() {
        return this.mode == IcCubeSchemaAccessLockMode.READ;
    }

    public boolean isNone() {
        return this.mode == IcCubeSchemaAccessLockMode.NONE;
    }

    public String mode() {
        return this.mode.name();
    }

    public String getLockInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.mode);
        if (this.allSchema) {
            sb.append(":*");
        } else if (this.schema != null) {
            sb.append(":").append(this.schema);
        }
        return sb.toString();
    }
}

