/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.status;

import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.request.status.IcCubeTablePartitionRequestStatus;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubeTableRequestStatus {
    private final String tableName;
    private final Kind kind;
    private final int partitionCount;
    private final Date timestampStarted;
    private final Map<String, IcCubeTablePartitionRequestStatus> partitions = new LinkedHashMap<String, IcCubeTablePartitionRequestStatus>();
    @Nullable
    private Date timestampReadingCompleted;
    @Nullable
    private Date timestampProcessingCompleted;
    private long rowCount;

    public IcCubeTableRequestStatus(String tableName, Kind kind, int partitionCount, Date timestamp) {
        this.tableName = tableName;
        this.kind = kind;
        this.partitionCount = partitionCount;
        this.timestampStarted = timestamp;
        this.rowCount = -1L;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, IcCubeTablePartitionRequestStatus> getPartitions() {
        return this.partitions;
    }

    public int getCompletedPartitionCount() {
        int count = 0;
        for (IcCubeTablePartitionRequestStatus partition : this.partitions.values()) {
            if (!partition.isProcessingCompleted()) continue;
            ++count;
        }
        return count;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public boolean isOngoing() {
        return !this.isProcessingCompleted();
    }

    public boolean isReadingCompleted() {
        return this.timestampReadingCompleted != null;
    }

    public boolean isProcessingCompleted() {
        return this.timestampProcessingCompleted != null;
    }

    public boolean isMultiPartition() {
        return this.partitions.size() > 1;
    }

    public void onPartitionReadStarted(String partitionName, Date timestamp) {
        if (this.isProcessingCompleted()) {
            return;
        }
        this.partitions.put(partitionName, new IcCubeTablePartitionRequestStatus(partitionName, timestamp));
    }

    public void onPartitionRead(String partitionName, Date timestamp, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
        if (this.isProcessingCompleted()) {
            return;
        }
        IcCubeTablePartitionRequestStatus partition = this.partitions.get(partitionName);
        if (partition == null) {
            return;
        }
        partition.onReadProgress(timestamp, readRowCount, readRowCountPerSec, processingQueuedTaskCount, processingQueueTaskSize);
    }

    public void onPartitionReadCompleted(String partitionName, Date timestamp, long rowCount) {
        if (this.isProcessingCompleted()) {
            return;
        }
        IcCubeTablePartitionRequestStatus partition = this.partitions.get(partitionName);
        if (partition == null) {
            return;
        }
        partition.onReadCompleted(timestamp, rowCount);
    }

    public void onPartitionProcessingCompleted(String partitionName, Date timestamp) {
        if (this.isProcessingCompleted()) {
            return;
        }
        IcCubeTablePartitionRequestStatus partition = this.partitions.get(partitionName);
        if (partition == null) {
            return;
        }
        partition.onProcessingCompleted(timestamp);
    }

    public void onTableReadCompleted(OlapBuilderContext context, Date timestamp, long rowCount) {
        this.timestampReadingCompleted = timestamp;
        Logger logger = context.getLoggers().builderTable();
        if (logger.isDebugEnabled()) {
            long elapsedMS = timestamp.getTime() - this.timestampStarted.getTime();
            logger.debug((Object)String.format("table [%s] reading completed in : %s [ %s total rows ]", this.getTableName(), CdTimeUtils.formatMillis((long)elapsedMS), CdStringUtils.formatNice((long)rowCount)));
        }
    }

    public void onTableProcessingCompleted(OlapBuilderContext context, Date timestamp, long rowCount) {
        this.timestampProcessingCompleted = timestamp;
        Logger logger = context.getLoggers().builderTable();
        if (logger.isDebugEnabled()) {
            long elapsedMS = timestamp.getTime() - this.timestampStarted.getTime();
            logger.debug((Object)String.format("table [%s] processing completed in : %s [ %s total rows ]", this.getTableName(), CdTimeUtils.formatMillis((long)elapsedMS), CdStringUtils.formatNice((long)rowCount)));
        }
        this.rowCount = rowCount;
    }

    public long getReadingElapsedMS() {
        Date timestamp = this.timestampReadingCompleted;
        if (timestamp == null) {
            return -1L;
        }
        return timestamp.getTime() - this.timestampStarted.getTime();
    }

    public long getProcessingElapsedMS() {
        Date timestamp = this.timestampProcessingCompleted;
        if (timestamp == null) {
            return -1L;
        }
        return timestamp.getTime() - this.timestampStarted.getTime();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public static enum Kind {
        DIMENSION,
        FACTS;

    }
}

