/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.status;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class IcCubeRequestStatuses {
    public static final int MAX_HISTORICAL_REQUEST_COUNT = 32;
    private final String requestTypeName;
    private final boolean monitored;
    private final Map<String, IcCubeRequestStatus> statusesByUuid = new HashMap<String, IcCubeRequestStatus>();
    private final LinkedList<String> uuids = new LinkedList();

    public IcCubeRequestStatuses(String requestTypeName, boolean monitored) {
        this.requestTypeName = requestTypeName;
        this.monitored = monitored;
    }

    public boolean isUiMonitored() {
        return this.monitored;
    }

    public void add(IcCubeRequest request, IcCubeRequestStatus status) {
        if (!request.getInternalTypeName().equals(this.requestTypeName)) {
            throw new CdProgrammingException("internal error : inconsistent request type [" + request.getInternalTypeName() + "] [expected:" + this.requestTypeName + "]");
        }
        if (this.statusesByUuid.size() > 32) {
            this.removeOldestIncrLoadDeActivated();
        }
        if (this.statusesByUuid.size() > 32) {
            String oldest = this.uuids.removeFirst();
            this.statusesByUuid.remove(oldest);
        }
        this.statusesByUuid.put(request.getClientUUID(), status);
        this.uuids.addLast(request.getClientUUID());
    }

    private void removeOldestIncrLoadDeActivated() {
        String uuidToDelete = null;
        for (String uuid : this.uuids) {
            IcCubeRequestStatus status = this.statusesByUuid.get(uuid);
            if (status == null || !status.isIncrLoadDeActivated()) continue;
            uuidToDelete = uuid;
            break;
        }
        if (uuidToDelete != null) {
            this.statusesByUuid.remove(uuidToDelete);
        }
    }

    @Nullable
    public IcCubeRequestStatus getRequestStatus(String uuid) {
        return this.statusesByUuid.get(uuid);
    }

    @Nullable
    public IcCubeRequestStatus getLatestStatusForCompletedRequests(File schemaFactoryFile) {
        ArrayList<IcCubeRequestStatus> status = new ArrayList<IcCubeRequestStatus>(this.statusesByUuid.values());
        Collections.sort(status, new Comparator<IcCubeRequestStatus>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(IcCubeRequestStatus o1, IcCubeRequestStatus o2) {
                return o1.getCompletionDate().compareTo(o2.getCompletionDate());
            }
        });
        for (int idx = status.size() - 1; idx >= 0; --idx) {
            IcCubeRequestStatus requestStatus = (IcCubeRequestStatus)status.get(idx);
            if (!requestStatus.isAttachedToSchemaFactory(schemaFactoryFile) || requestStatus.isIncrLoadDeActivated()) continue;
            return requestStatus;
        }
        return null;
    }

    Collection<IcCubeRequestStatus> getAllStatus() {
        return this.statusesByUuid.values();
    }
}

