/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.status;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.cluster.master.request.M_CancellingRequestManager;
import crazydev.iccube.cluster.master.request.M_TimeoutRequestManager;
import crazydev.iccube.common.IOlapContext;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.stats.OlapSchemaTableStats;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.request.IcCubeRequestCategory;
import crazydev.iccube.request.request.IcCubeRequestCompletionFuture;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.request.IcCubeRequestReply;
import crazydev.iccube.request.status.IcCubeActiveRequestManager;
import crazydev.iccube.request.status.IcCubeActiveRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStateEx;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatuses;
import crazydev.iccube.request.task.IcCubeTask;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubeRequestStatusManager {
    private final Object globalLOCK = new Object();
    private final IcCubeActiveRequestManager activeRequests;
    private final Map<String, IcCubeRequestStatuses> completedRequestsByType = new HashMap<String, IcCubeRequestStatuses>();
    private final AtomicLong uxRequestCount = new AtomicLong();
    private final AtomicLong gwtRequestCount = new AtomicLong();
    private final AtomicLong gviRequestCount = new AtomicLong();
    private final AtomicLong xmlaRequestCount = new AtomicLong();
    private final AtomicLong otherRequestCount = new AtomicLong();
    private final AtomicLong totalLoadRequestCount = new AtomicLong();
    private final AtomicLong totalLoadRequestTime = new AtomicLong();
    private final AtomicLong totalMdxRequestCount = new AtomicLong();
    private final AtomicLong totalMdxRequestTime = new AtomicLong();
    private final AtomicLong totalOtherRequestCount = new AtomicLong();
    private final AtomicLong totalOtherRequestTime = new AtomicLong();
    private boolean shuttingDown;

    public IcCubeRequestStatusManager(boolean sessionLess, M_CancellingRequestManager cancelRequestManager, M_TimeoutRequestManager timeoutRequestManager) {
        this.activeRequests = new IcCubeActiveRequestManager(sessionLess, cancelRequestManager, timeoutRequestManager);
        timeoutRequestManager.attach(this);
    }

    public boolean hasRequestWithTimeout() {
        return this.activeRequests.hasRequestWithTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRequestTimeout(String requestUuid, int timeoutS) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status != null) {
                status.setTimeout(timeoutS);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestTimeoutKey(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            return status != null ? status.getTimeoutKey() : "<n/a>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestTimeout(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status != null) {
                boolean timeout = status.isTimeout();
                return timeout;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(@Nullable String requestUuid) {
        if (requestUuid == null) {
            return false;
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            return status != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequestEx(String ic3_clt_req_uuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(ic3_clt_req_uuid);
            if (status != null) {
                OlapLoggers.REQUESTS.info((Object)("[request] cancelling the request (ic3_clt_req_uuid) [" + status.getRequestUUID() + "]"));
                status.cancel(null);
                this.cancelPrintingJobRequests(status, null);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status != null) {
                OlapLoggers.REQUESTS.info((Object)("[request] cancelling the request [" + status.getRequestUUID() + "]"));
                status.cancel(null);
                this.cancelPrintingJobRequests(status, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequestOnTimeout(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status != null) {
                OlapLoggers.REQUESTS.info((Object)("[request] cancelling the request on timeout [" + status.getRequestUUID() + "]"));
                status.cancelOnTimeout();
                this.cancelPrintingJobRequests(status, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequestOnInterruptedException(String requestUuid) {
        OlapLoggers.REQUESTS.info((Object)("[request] cancelling (on-interrupted-exception) the request [" + requestUuid + "]"));
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status != null) {
                OlapLoggers.REQUESTS.info((Object)("[request] cancelling (on-interrupted-exception) the active request [" + status.getRequestUUID() + "]"));
                status.cancelOnInterruptedException();
                this.cancelPrintingJobRequests(status, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelGviRequests(String cancelUUID, String sessionUUID, long timestamp, String windowUid, @Nullable String widgetUid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapLoggers.REQUESTS.info((Object)String.format("[request] cancel the GVI requests [cancelUUID:%s][sessionUUID:%s][timestamp:%s][windowUid:%s][widgetUid:%s]", cancelUUID, sessionUUID, timestamp, windowUid, widgetUid));
            List<IcCubeRequestStatus> allStatus = this.getActiveGviRequestStatus(cancelUUID, sessionUUID, timestamp, windowUid, widgetUid);
            if (allStatus != null) {
                for (IcCubeRequestStatus status : allStatus) {
                    IcCubeActiveRequestManager.GviInfo gviInfo = status.getGviInfo();
                    if (gviInfo != null) {
                        OlapLoggers.REQUESTS.info((Object)String.format("[request] cancel the GVI request [requestUUUID:%s][sessionUUID:%s][clientUUID:%s][timestamp:%s][windowUid:%s][widgetUid:%s]", status.getRequestUUID(), gviInfo.sessionUUID, gviInfo.clientUUID, gviInfo.timestamp, gviInfo.windowUid, gviInfo.widgetUid));
                    } else {
                        OlapLoggers.REQUESTS.info((Object)("[request] cancel the request [requestUUUID:" + status.getRequestUUID() + "]"));
                    }
                    if (status.isGviCancelActiveRequests()) {
                        OlapLoggers.REQUESTS.info((Object)("[request] cancel the request [requestUUUID:" + status.getRequestUUID() + "] *** IGNORED ***"));
                        continue;
                    }
                    status.cancel("GVI_CANCEL");
                    this.cancelPrintingJobRequests(status, "GVI_CANCEL");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoCancelGviRequests(String cancelUUID, String sessionUUID, long timestamp, String windowUid, String widgetUid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapLoggers.REQUESTS.info((Object)String.format("[request] auto-cancel the GVI requests [cancelUUID:%s][sessionUUID:%s][timestamp:%s][windowUid:%s][widgetUid:%s]", cancelUUID, sessionUUID, timestamp, windowUid, widgetUid));
            List<IcCubeRequestStatus> allStatus = this.getActiveAutoCancelGviRequestStatus(cancelUUID, sessionUUID, timestamp, windowUid, widgetUid);
            if (allStatus != null) {
                for (IcCubeRequestStatus status : allStatus) {
                    IcCubeActiveRequestManager.GviInfo gviInfo = status.getGviInfo();
                    if (gviInfo != null) {
                        OlapLoggers.REQUESTS.info((Object)String.format("[request] auto-cancel the GVI request [requestUUUID:%s][sessionUUID:%s][clientUUID:%s][timestamp:%s][windowUid:%s][widgetUid:%s]", status.getRequestUUID(), gviInfo.sessionUUID, gviInfo.clientUUID, gviInfo.timestamp, gviInfo.windowUid, gviInfo.widgetUid));
                    } else {
                        OlapLoggers.REQUESTS.info((Object)("[request] auto-cancel the GVI request [requestUUUID:" + status.getRequestUUID() + "]"));
                    }
                    status.cancel("GVI_AUTO_CANCEL");
                    this.cancelPrintingJobRequests(status, "GVI_AUTO_CANCEL");
                }
            }
        }
    }

    private void cancelPrintingJobRequests(IcCubeRequestStatus status, @Nullable String info) {
        List<IcCubeRequestStatus> requests;
        String printing = status.getPrintingJob();
        if (printing != null) {
            OlapLoggers.REQUESTS.info((Object)("[request] cancelling print job [" + printing + "] active requests"));
        }
        if ((requests = this.getActiveDependentRequestStatus(printing)) != null) {
            for (IcCubeRequestStatus request : requests) {
                OlapLoggers.REQUESTS.info((Object)("[request] cancelling print job [" + printing + "] active request: " + request.getRequestUUID()));
                request.cancel(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllRequests() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.completedRequestsByType.clear();
            this.uxRequestCount.set(0L);
            this.gwtRequestCount.set(0L);
            this.gviRequestCount.set(0L);
            this.xmlaRequestCount.set(0L);
            this.otherRequestCount.set(0L);
            this.totalLoadRequestCount.set(0L);
            this.totalLoadRequestTime.set(0L);
            this.totalMdxRequestCount.set(0L);
            this.totalMdxRequestTime.set(0L);
            this.totalOtherRequestCount.set(0L);
            this.totalOtherRequestTime.set(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int killAllRequests(String callingRequestUUID, boolean excludeLoadRequests) {
        int count = 0;
        Object object = this.globalLOCK;
        synchronized (object) {
            for (IcCubeRequestStatus status : this.activeRequests.status()) {
                String requestUUID = status.getRequestUUID();
                if (callingRequestUUID.equals(requestUUID) || excludeLoadRequests && status.isSchemaLifeCycle()) continue;
                OlapLoggers.REQUESTS.info((Object)("[request] cancelling (kill-all) the request [" + requestUUID + "]"));
                status.cancel(null);
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShutdownStarted() {
        OlapLoggers.REQUEST.info((Object)"[request-manager] shutdown started (cancel all active requests)");
        Object object = this.globalLOCK;
        synchronized (object) {
            this.shuttingDown = true;
            this.activeRequests.cancelAllRequests((uuid, status) -> status.cancel("shutdown"));
        }
        OlapLoggers.REQUEST.info((Object)"[request-manager] all active requests cancelled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestReceived(String sessionUUID, String userName, @Nullable OlapTenant userTenant, IcCubeRequest request, @Nullable String printJobUUID) {
        if (this.shuttingDown) {
            throw new RuntimeException("request rejected: shutting down");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            this.activeRequests.addRequest(sessionUUID, userName, userTenant, request, printJobUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestProcessingStarted(IcCubeRequest request) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus(request);
            status.onRequestProcessingStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcCubeRequestCompletionFuture onRequestTasksGenerated(IcCubeRequest request, List<? extends IcCubeTask> tasks) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus(request);
            status.onRequestTasksGenerated(tasks);
            return status.getCompletionFuture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskSubmitted(IcCubeTask task, Future<?> future) {
        Object object = this.globalLOCK;
        synchronized (object) {
            Object request = task.getRequest();
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus((IcCubeRequest)request);
            status.onTaskSubmitted(task, future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableReadStarted(String requestUuid, boolean facts, String tableName, int partitionCount, Date timestamp) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onTableReadStarted(facts, tableName, partitionCount, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionReadStarted(String requestUuid, boolean facts, String tableName, String partitionName, Date timestamp) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onTablePartitionReadStarted(facts, tableName, partitionName, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionReadProgress(String requestUuid, boolean facts, String tableName, String partitionName, Date timestamp, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onTablePartitionReadProgress(facts, tableName, partitionName, timestamp, readRowCount, readRowCountPerSec, processingQueuedTaskCount, processingQueueTaskSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionReadCompleted(String requestUuid, boolean facts, String tableName, String partitionName, Date timestamp, long rowCount) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onTablePartitionReadCompleted(facts, tableName, partitionName, timestamp, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableReadCompleted(OlapBuilderContext context, String requestUuid, boolean facts, String tableName, Date timestamp, long rowCount) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onTableReadCompleted(context, facts, tableName, timestamp, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableProcessingCompleted(OlapBuilderContext context, String requestUuid, boolean facts, String tableName, Date timestamp, long rowCount) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onTableProcessingCompleted(context, facts, tableName, timestamp, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionProcessingCompleted(String requestUuid, boolean facts, String tableName, String partitionName, Date timestamp) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onTablePartitionProcessingCompleted(facts, tableName, partitionName, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestProgress(String requestUuid, String messageTag, Serializable ... params) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestProgress(messageTag, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestProgressPhase(String requestUuid, String messageTag, Serializable ... params) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestProgressPhase(messageTag, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestSchemaResolved(String requestUuid, @Nullable String name) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestSchemaResolved(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestPrintingJobAdded(String requestUuid, String jobUUID) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestPrintingJobAdded(jobUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestDetailAdded(String requestUuid, String name, String value) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestDetailAdded(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestMdxDetailAdded(String requestUuid, String name, String schema, String mdx) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestMdxDetailAdded(name, schema, mdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestSqlDetailAdded(String requestUuid, String name, String schema, String jdbcDataSource, String mdx) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestSqlDetailAdded(name, schema, jdbcDataSource, mdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestAttachedToSchemaDefFactory(String requestUuid, File schemaFactoryFile) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestAttachedToSchemaFactory(schemaFactoryFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestLoadSchemaStatus(String requestUuid, OlapSchemaLifeCycleStatus loadStatus) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status != null) {
                status.onRequestLoadSchemaStatus(loadStatus);
            }
        }
    }

    public void onRequestError(String requestUuid, CdError error) {
        this.onRequestErrors(requestUuid, Arrays.asList(error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestBackupError(String requestUuid, CdError error) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestBackupError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestErrors(String requestUuid, List<? extends CdError> errors) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(requestUuid);
            if (status == null) {
                return;
            }
            status.onRequestErrors(errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestUnexpectedException(IcCubeRequest request, Exception exception) {
        Logger logger = request.getLogger();
        logger.info((Object)(request.getLoggerInfo() + " : unexpected exception ( " + request.getClientUUID() + " )"), (Throwable)exception);
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus(request);
            status.onRequestUnexpectedException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestSetupSchedulingException(IcCubeRequest request, Exception exception) {
        Logger logger = request.getLogger();
        logger.error((Object)(request.getLoggerInfo() + " : request scheduling setup error"), (Throwable)exception);
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus(request);
            status.onRequestSetupSchedulingException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskException(IcCubeRequest request, Exception exception) {
        Logger logger = request.getLogger();
        logger.error((Object)(request.getLoggerInfo() + " : task processing error"), (Throwable)exception);
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus(request);
            status.onRequestTaskException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMergeToRequestCompleted(IcCubeRequest request, String mergeToRequestUUID) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus mergeToStatus = this.getRequestStatus(mergeToRequestUUID);
            if (mergeToStatus != null) {
                IcCubeRequestStatus status = this.getExistingActiveRequestStatus(request);
                status.onMergeToRequestCompleted(mergeToStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskBusy(IcCubeTask task) {
        Object request = task.getRequest();
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStateEx completionState = ((IcCubeRequest)request).getCompletionState();
            if (completionState != null && completionState.state.isCompleted()) {
                return;
            }
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus((IcCubeRequest)request);
            status.onRequestTaskBusy(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskDone(IcCubeTask task) {
        Object request = task.getRequest();
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus((IcCubeRequest)request);
            status.onRequestTaskDone(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcCubeRequestStateEx onRequestProcessingCompleted(String sessionUUID, IcCubeRequest request, @Nullable IcCubeRequestReply reply) {
        IcCubeRequestStateEx completionState;
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getExistingActiveRequestStatus(request);
            completionState = status.onRequestProcessingCompleted(reply);
            request.setCompletionState(completionState);
            OlapRequestId requestId = request.getRequestId();
            OlapChattyRequest chattyRequest = request.isChattyRequest();
            OlapRequestVerbosity verbosity = request.getVerbosity();
            OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
            this.activeRequests.removeRequest(requestInfo, sessionUUID, request.getClientUUID());
            if (request.isUiMonitored()) {
                String requestTypeName = request.getInternalTypeName();
                IcCubeRequestStatuses terminated = this.completedRequestsByType.get(requestTypeName);
                if (terminated == null) {
                    terminated = new IcCubeRequestStatuses(requestTypeName, request.isUiMonitored());
                    this.completedRequestsByType.put(requestTypeName, terminated);
                }
                terminated.add(request, status);
            }
            IcCubeRequestCategory category = request.getCategory();
            switch (category) {
                case UX: {
                    this.uxRequestCount.incrementAndGet();
                    break;
                }
                case GWT: {
                    this.gwtRequestCount.incrementAndGet();
                    break;
                }
                case GVI: {
                    this.gviRequestCount.incrementAndGet();
                    break;
                }
                case XMLA: {
                    this.xmlaRequestCount.incrementAndGet();
                    break;
                }
                case OTHER: {
                    this.otherRequestCount.incrementAndGet();
                    break;
                }
            }
            IcCubeRequestKind kind = request.getKind();
            switch (kind) {
                case LOAD: {
                    this.totalLoadRequestCount.incrementAndGet();
                    this.totalLoadRequestTime.addAndGet(this.getElapsedTimeMs(status));
                    break;
                }
                case MDX: {
                    this.totalMdxRequestCount.incrementAndGet();
                    this.totalMdxRequestTime.addAndGet(this.getElapsedTimeMs(status));
                    break;
                }
                default: {
                    this.totalOtherRequestCount.incrementAndGet();
                    this.totalOtherRequestTime.addAndGet(this.getElapsedTimeMs(status));
                }
            }
        }
        Logger logger = request.getLogger();
        if (this.hasErrors(request.getClientUUID())) {
            logger.error((Object)(request.getLoggerInfo() + " : (" + request.getClientUUID() + ") has generated some errors"));
        }
        for (CdError error : this.getErrors(request.getClientUUID())) {
            logger.error((Object)("  - " + error.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
        }
        return completionState;
    }

    public void syncForSchemaLoad(IOlapContext context, Logger logger, String requestUuid, String schema, int waitS, int cancelS) {
        int busyRequestCount = this.waitForAllBusyRequests(logger, context, schema, requestUuid, waitS);
        if (busyRequestCount > 0) {
            this.cancelAllBusyRequests(logger, schema, requestUuid);
            busyRequestCount = this.waitForAllBusyRequests(logger, context, schema, requestUuid, cancelS);
            if (busyRequestCount > 0) {
                logger.error((Object)("[tasks] schema [" + schema + "] sync. load wait on error : could not cancel " + busyRequestCount + " request(s)"));
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_SCHEMA_CANCEL_REQUEST_TIMEOUT, new Serializable[0]);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] schema [" + schema + "] sync. load wait completed [cancelling:" + context.isCancelling() + "]"));
        }
    }

    private int waitForAllBusyRequests(Logger logger, IOlapContext context, String schema, String requestUuid, int timeoutS) {
        int busyRequestCount = this.busyRequestCount(schema, requestUuid);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] schema [" + schema + "] sync. load is waiting for " + timeoutS + " seconds : " + busyRequestCount + " request(s)"));
        }
        if (busyRequestCount <= 0) {
            return 0;
        }
        long endMS = System.currentTimeMillis() + (long)(timeoutS * 1000);
        try {
            while (!context.isCancelling() && busyRequestCount > 0 && System.currentTimeMillis() < endMS) {
                Thread.sleep(1000L);
                busyRequestCount = this.busyRequestCount(schema, requestUuid);
            }
            busyRequestCount = this.busyRequestCount(schema, requestUuid);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[tasks] schema [" + schema + "] sync. load waiting done [request-count:" + busyRequestCount + "] [cancelling:" + context.isCancelling() + "]"));
            }
            return busyRequestCount;
        }
        catch (InterruptedException ex) {
            logger.warn((Object)("[tasks] schema [" + schema + "] sync. load (waiting) interrupted"));
            return 0;
        }
    }

    private void cancelAllBusyRequests(Logger logger, String schema, String requestUuid) {
        List<IcCubeRequestStatus> requests = this.busyRequests(schema, requestUuid);
        if (requests != null) {
            for (IcCubeRequestStatus request : requests) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] schema [" + schema + "] sync. load is cancelling the request [" + request.getRequestUUID() + "]"));
                }
                request.cancel("schema load");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int busyRequestCount(String schema, String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.busyRequestCount(schema, requestUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IcCubeRequestStatus> busyRequests(String schema, String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.busyRequests(schema, requestUuid);
        }
    }

    private long getElapsedTimeMs(IcCubeRequestStatus status) {
        long elapsedTimeMs = status.getElapsedTimeMs();
        return elapsedTimeMs != -1L ? elapsedTimeMs : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getRequestStatus(requestUuid);
            if (status == null) {
                return false;
            }
            return status.hasErrors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CdError> getErrors(String uuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getRequestStatus(uuid);
            if (status == null) {
                return Collections.emptyList();
            }
            return status.getAllErrors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CdError> getBackupErrors(String uuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getRequestStatus(uuid);
            if (status == null) {
                return Collections.emptyList();
            }
            return status.getAllBackupErrors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IcCubeActiveRequestStatus getActiveRequestStatus_(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.activeRequests.getRequest(requestUuid);
            return status != null ? new IcCubeActiveRequestStatus(status) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IcCubeRequestStatus getActiveRequestStatus(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.getRequest(requestUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<IcCubeRequestStatus> getActiveGviRequestStatus(String cancelUUID, String sessionUUID, long timestamp, String windowUid, @Nullable String widgetUid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            List<IcCubeRequestStatus> reqs = this.activeRequests.getGviRequests(cancelUUID, sessionUUID, timestamp, windowUid, widgetUid);
            if (reqs != null && !reqs.isEmpty()) {
                return reqs;
            }
            return reqs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<IcCubeRequestStatus> getActiveAutoCancelGviRequestStatus(String cancelUUID, String sessionUUID, long timestamp, String windowUid, String widgetUid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.getAutoCancelGviRequests(cancelUUID, sessionUUID, timestamp, windowUid, widgetUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IcCubeRequestStatus getExistingActiveRequestStatus(IcCubeRequest request) {
        String clientUUID = request.getClientUUID();
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.getActiveRequestStatus(clientUUID);
            if (status == null) {
                throw new CdProgrammingException("internal error: missing request [" + clientUUID + "] status");
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IcCubeRequestStatus getRequestStatus(@Nullable String requestUuid) {
        if (requestUuid == null) {
            return null;
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeRequestStatus status = this.activeRequests.getRequest(requestUuid);
            if (status == null) {
                IcCubeRequestStatuses completed;
                Iterator<IcCubeRequestStatuses> iterator = this.completedRequestsByType.values().iterator();
                while (iterator.hasNext() && (status = (completed = iterator.next()).getRequestStatus(requestUuid)) == null) {
                }
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<IcCubeRequestStatus> getActiveDependentRequestStatus(@Nullable String printingJobUUID) {
        if (printingJobUUID == null) {
            return null;
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.getDependentRequests(printingJobUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getOneActiveRequestUuid__() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.getOneActiveRequestUuid__();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount(@Nullable String excludeUUID) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.size(excludeUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IcCubeRequestStatus> getAllActiveLoadingSchemaRequestStatus(@Nullable OlapTenant tenant) {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<IcCubeRequestStatus> statuses = new ArrayList<IcCubeRequestStatus>();
            Collection<IcCubeRequestStatus> requests = this.activeRequests.status();
            for (IcCubeRequestStatus request : requests) {
                if (!request.isLoadSchema() || !Objects.equals(tenant, request.getUserTenant())) continue;
                statuses.add(request);
            }
            return statuses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IcCubeRequestStatus> getAllSortedActiveRequestStatus(@Nullable String excludeUUID) {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<IcCubeRequestStatus> statuses = new ArrayList<IcCubeRequestStatus>();
            Collection<IcCubeRequestStatus> requests = this.activeRequests.status();
            for (IcCubeRequestStatus request : requests) {
                if (excludeUUID != null && excludeUUID.equals(request.getRequestUUID())) continue;
                statuses.add(request);
            }
            statuses.sort((o1, o2) -> o2.getStartDate().compareTo(o1.getStartDate()));
            return statuses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IcCubeRequestStatus> getAllSortedCompletedRequestStatus() {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<IcCubeRequestStatus> statuses = new ArrayList<IcCubeRequestStatus>();
            for (IcCubeRequestStatuses completed : this.completedRequestsByType.values()) {
                if (!completed.isUiMonitored()) continue;
                statuses.addAll(completed.getAllStatus());
            }
            statuses.sort((o1, o2) -> o2.getStartDate().compareTo(o1.getStartDate()));
            return statuses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LatestErrors getLatestErrorsForSchemaDefFactory(File schemaFactory) {
        Object object = this.globalLOCK;
        synchronized (object) {
            ArrayList<IcCubeRequestStatus> latestStatusesWithErrors = new ArrayList<IcCubeRequestStatus>();
            for (IcCubeRequestStatuses terminated : this.completedRequestsByType.values()) {
                IcCubeRequestStatus latest = terminated.getLatestStatusForCompletedRequests(schemaFactory);
                if (latest == null) continue;
                latestStatusesWithErrors.add(latest);
            }
            if (latestStatusesWithErrors.isEmpty()) {
                return null;
            }
            Collections.sort(latestStatusesWithErrors, new Comparator<IcCubeRequestStatus>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public int compare(IcCubeRequestStatus o1, IcCubeRequestStatus o2) {
                    return o1.getCompletionDate().compareTo(o2.getCompletionDate());
                }
            });
            IcCubeRequestStatus latest = (IcCubeRequestStatus)latestStatusesWithErrors.get(latestStatusesWithErrors.size() - 1);
            List<CdError> errors = latest.getAllErrors(schemaFactory);
            if (errors == null || errors.isEmpty()) {
                return null;
            }
            return new LatestErrors(latest.getStartDate(), errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CdError> getErrorForActiveRequestForSchemaDefFactory(File schemaFactory) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.activeRequests.getErrorsForSchemaDefFactory(schemaFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaTableStats createTableStats(String requestUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            try {
                IcCubeRequestStatus status = this.getRequestStatus(requestUuid);
                if (status == null) {
                    return null;
                }
                return status.createTableStats();
            }
            catch (Exception ex) {
                OlapLoggers.BUILDER.warn((Object)"[stats] Could not create the table stats", (Throwable)ex);
                return null;
            }
        }
    }

    public long getUxRequestCount() {
        return this.uxRequestCount.get();
    }

    public long getGwtRequestCount() {
        return this.gwtRequestCount.get();
    }

    public long getGviRequestCount() {
        return this.gviRequestCount.get();
    }

    public long getXmlaRequestCount() {
        return this.xmlaRequestCount.get();
    }

    public long getOtherRequestCount() {
        return this.otherRequestCount.get();
    }

    public long getTotalLoadRequestCount() {
        return this.totalLoadRequestCount.get();
    }

    public long getTotalMdxRequestCount() {
        return this.totalMdxRequestCount.get();
    }

    public long getTotalOtherRequestCount() {
        return this.totalOtherRequestCount.get();
    }

    public long getTotalLoadRequestTime() {
        return this.totalLoadRequestTime.get();
    }

    public long getTotalMdxRequestTime() {
        return this.totalMdxRequestTime.get();
    }

    public long getTotalOtherRequestTime() {
        return this.totalOtherRequestTime.get();
    }

    public static class LatestErrors {
        private final Date startDate;
        private final List<CdError> errors;

        LatestErrors(Date startDate, List<CdError> errors) {
            this.startDate = startDate;
            this.errors = errors;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public List<CdError> getErrors() {
            return this.errors;
        }
    }
}

