/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.status;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdCommonErrorCode;
import crazydev.common.exception.CdError;
import crazydev.common.exception.ICdException;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.cluster.master.request.M_CancellingRequestManager;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.schema.stats.OlapSchemaTableStats;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.request.IcCubeRequestCompletionFuture;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.request.IcCubeRequestReply;
import crazydev.iccube.request.request.IcCubeRequestType;
import crazydev.iccube.request.status.IcCubeActiveRequestManager;
import crazydev.iccube.request.status.IcCubeRequestState;
import crazydev.iccube.request.status.IcCubeRequestStateEx;
import crazydev.iccube.request.status.IcCubeTablePartitionRequestStatus;
import crazydev.iccube.request.status.IcCubeTableRequestStatus;
import crazydev.iccube.request.task.IcCubeTask;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Nullable;

public class IcCubeRequestStatus {
    private final Object globalLOCK = new Object();
    private final M_CancellingRequestManager cancelRequestManager;
    private final IcCubeRequestKind requestKind;
    private final IcCubeRequestType requestType;
    private final boolean schemaLifeCycle;
    private final String userName;
    @Nullable
    private final OlapTenant userTenant;
    private final String requestUuid;
    private final String requestUserFriendlyTypeName;
    private final Date requestStartDate;
    @Nullable
    private IcCubeActiveRequestManager.GviInfo gviInfo;
    private final IcCubeRequestCompletionFuture completionFuture;
    private final List<Future> taskFutures;
    private final List<Detail> details = new ArrayList<Detail>();
    private final Map<String, IcCubeTableRequestStatus> dimsTableInfos = new LinkedHashMap<String, IcCubeTableRequestStatus>();
    private final Map<String, IcCubeTableRequestStatus> factsTableInfos = new LinkedHashMap<String, IcCubeTableRequestStatus>();
    private final List<CdError> errors = new ArrayList<CdError>();
    private final List<CdError> backupErrors = new ArrayList<CdError>();
    @Nullable
    private Integer timeoutMS;
    @Nullable
    private Date completionDate;
    @Nullable
    private String schema;
    @Nullable
    private String printingJob;
    @Nullable
    private String fromPrintingJob;
    private IcCubeRequestState state;
    private volatile boolean stateCancelling;
    private boolean stateOnTimeout;
    @Nullable
    private String stateExtraInfo;
    @Nullable
    private String progressInformationTag = "created";
    @Nullable
    private Serializable[] progressInformationParams = null;
    @Nullable
    private String progressPhaseTag = "...";
    @Nullable
    private Serializable[] progressPhaseParams = null;
    @Nullable
    private File schemaFactory;
    @Nullable
    private OlapSchemaLifeCycleStatus loadSchemaStatus;
    private boolean onUnexpectedException;
    private boolean onSetupSchedulingException;
    private boolean onTaskException;

    public IcCubeRequestStatus(M_CancellingRequestManager cancelRequestManager, String userName, @Nullable OlapTenant userTenant, IcCubeRequest request, IcCubeRequestState state, @Nullable String fromPrintingJob) {
        this.cancelRequestManager = cancelRequestManager;
        this.requestKind = request.getKind();
        this.requestType = request.getRequestType();
        this.schemaLifeCycle = request.isSchemaLifeCycle();
        this.userTenant = userTenant;
        this.userName = userName;
        this.fromPrintingJob = fromPrintingJob;
        this.requestUuid = request.getClientUUID();
        this.requestUserFriendlyTypeName = request.getUserFriendlyTypeName();
        this.requestStartDate = request.getStartDate();
        this.completionFuture = new IcCubeRequestCompletionFuture();
        this.taskFutures = new ArrayList<Future>();
        this.schema = request.getSchema();
        this.state = state;
    }

    private static void getTableProcessingDetails(List<Detail> details, Map<String, IcCubeTableRequestStatus> tableInfos, boolean ongoing, SimpleDateFormat dateFormat) {
        for (IcCubeTableRequestStatus tableStatus : tableInfos.values()) {
            if (ongoing != tableStatus.isOngoing()) continue;
            String tableKind = tableStatus.getKind() == IcCubeTableRequestStatus.Kind.DIMENSION ? "dim" : "facts";
            String tableName = tableStatus.getTableName();
            Map<String, IcCubeTablePartitionRequestStatus> partitions = tableStatus.getPartitions();
            if (tableStatus.isMultiPartition()) {
                details.add(new Detail("(" + tableKind + ") Table : " + tableName, "completed partitions : " + tableStatus.getCompletedPartitionCount() + " / " + tableStatus.getPartitionCount()));
            }
            for (IcCubeTablePartitionRequestStatus partitionStatus : partitions.values()) {
                if (ongoing != partitionStatus.isOngoing()) continue;
                StringBuilder sb = new StringBuilder();
                for (IcCubeTablePartitionRequestStatus.Info partitionInfo : partitionStatus.getInfos()) {
                    sb.append(partitionInfo.asString(dateFormat));
                }
                if (tableStatus.isMultiPartition()) {
                    String partitionName = partitionStatus.getPartitionName();
                    details.add(new Detail("(" + tableKind + ") Table : " + tableName + " [ " + String.valueOf(partitionName) + " ]", sb.toString()));
                    continue;
                }
                details.add(new Detail("(" + tableKind + ") Table : " + tableName, sb.toString()));
            }
        }
    }

    private static void getTableProcessingDetailsUX(List<Detail> details, Map<String, IcCubeTableRequestStatus> tableInfos) {
        for (IcCubeTableRequestStatus tableStatus : tableInfos.values()) {
            if (!tableStatus.isOngoing()) continue;
            String tableName = tableStatus.getTableName();
            Map<String, IcCubeTablePartitionRequestStatus> partitions = tableStatus.getPartitions();
            if (tableStatus.isMultiPartition()) {
                details.add(new Detail(tableName, "completed partitions: " + tableStatus.getCompletedPartitionCount() + " / " + tableStatus.getPartitionCount()));
            }
            for (IcCubeTablePartitionRequestStatus partitionStatus : partitions.values()) {
                if (!partitionStatus.isOngoing()) continue;
                String partitionInfoS = "...";
                IcCubeTablePartitionRequestStatus.Info partitionInfo = partitionStatus.getLastInfo();
                if (partitionInfo != null) {
                    partitionInfoS = partitionInfo.asString();
                }
                if (tableStatus.isMultiPartition()) {
                    String partitionName = partitionStatus.getPartitionName();
                    details.add(new Detail(tableName + " [" + String.valueOf(partitionName) + "]", partitionInfoS));
                    continue;
                }
                details.add(new Detail(tableName, partitionInfoS));
            }
        }
    }

    public IcCubeRequestCompletionFuture getCompletionFuture() {
        return this.completionFuture;
    }

    public boolean isBusy() {
        return this.completionFuture.isBusy();
    }

    public IcCubeRequestKind getRequestKind() {
        return this.requestKind;
    }

    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public OlapTenant getUserTenant() {
        return this.userTenant;
    }

    public String getRequestUUID() {
        return this.requestUuid;
    }

    public boolean isLoadSchema() {
        return this.requestKind == IcCubeRequestKind.LOAD;
    }

    public boolean isSchemaLifeCycle() {
        return this.schemaLifeCycle;
    }

    @Nullable
    public File getSchemaFactory() {
        return this.schemaFactory;
    }

    public String getRequestUserFriendlyTypeName() {
        return this.requestUserFriendlyTypeName;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    public String getSchemaEx() {
        return this.schema != null ? this.schema : "n/a";
    }

    @Nullable
    public String getPrintingJob() {
        return this.printingJob;
    }

    @Nullable
    public String getFromPrintingJob() {
        return this.fromPrintingJob;
    }

    public boolean isGviCancelActiveRequests() {
        return IcCubeRequestType.GVI_CANCEL_ACTIVE_REQUESTS == this.requestType;
    }

    public Date getStartDate() {
        return this.requestStartDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Date getCompletionDate() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.completionDate;
        }
    }

    public String getStartDateServerTime() {
        return CdTimeUtils.formatServerTime((Date)this.requestStartDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getCompletionDateServerTime() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.completionDate == null ? null : CdTimeUtils.formatServerTime((Date)this.completionDate);
        }
    }

    public String getStartDateServerTimeForRequest() {
        return CdTimeUtils.formatServerTimeForRequest((Date)this.requestStartDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getCompletionDateServerTimeFoRequest() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.completionDate == null ? null : CdTimeUtils.formatServerTimeForRequest((Date)this.completionDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElapsedTimeMs() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.completionDate == null) {
                return -1L;
            }
            long start = this.getStartDate().getTime();
            long end = this.completionDate.getTime();
            return end - start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcCubeRequestState getState() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalizedState(OlapBabylonService babylon) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return babylon.translateEnum(IcCubeRequestState.class, this.state.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLocalizedProgressInformation(OlapBabylonService babylonService) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.progressInformationTag == null) {
                return null;
            }
            String info = this.progressInformationParams == null ? babylonService.translate(this.progressInformationTag, new Serializable[0]) : babylonService.translate(this.progressInformationTag, this.progressInformationParams);
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaTableStats createTableStats() {
        Object object = this.globalLOCK;
        synchronized (object) {
            List<OlapSchemaTableStats.Info> dimInfos = this.createTableStats(this.dimsTableInfos);
            List<OlapSchemaTableStats.Info> factsInfos = this.createTableStats(this.factsTableInfos);
            return new OlapSchemaTableStats(dimInfos, factsInfos);
        }
    }

    private List<OlapSchemaTableStats.Info> createTableStats(Map<String, IcCubeTableRequestStatus> tables) {
        ArrayList<OlapSchemaTableStats.Info> infos = new ArrayList<OlapSchemaTableStats.Info>();
        for (IcCubeTableRequestStatus table : tables.values()) {
            String name = table.getTableName();
            long rowCount = table.getRowCount();
            long processingMS = table.getProcessingElapsedMS();
            long readingMS = table.getReadingElapsedMS();
            infos.add(new OlapSchemaTableStats.Info(name, rowCount, readingMS, processingMS));
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Detail> getTableProcessingDetails() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.dimsTableInfos.isEmpty() && this.factsTableInfos.isEmpty()) {
                return Collections.emptyList();
            }
            boolean ongoing = this.completionDate == null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            ArrayList<Detail> details = new ArrayList<Detail>();
            IcCubeRequestStatus.getTableProcessingDetails(details, this.dimsTableInfos, ongoing, dateFormat);
            IcCubeRequestStatus.getTableProcessingDetails(details, this.factsTableInfos, ongoing, dateFormat);
            return details;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Detail> getAllDetails() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return new ArrayList<Detail>(this.details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Detail> getAllDetails(int lastN) {
        Object object = this.globalLOCK;
        synchronized (object) {
            int from;
            ArrayList<Detail> infos = new ArrayList<Detail>();
            int size = this.details.size();
            for (int dd = from = Math.max(size - lastN, 0); dd < size; ++dd) {
                infos.add(this.details.get(dd));
            }
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhase(CdBabylonService babylon) {
        Object info;
        Object object = this.globalLOCK;
        synchronized (object) {
            info = this.progressPhaseTag == null ? "..." : (this.progressPhaseParams == null ? babylon.translate(this.progressPhaseTag, new Serializable[0]) : babylon.translate(this.progressPhaseTag, this.progressPhaseParams));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        info = dateFormat.format(new Date()) + " : " + (String)info;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestProgressPhase(String tag, Serializable ... params) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.progressPhaseTag = tag;
            this.progressPhaseParams = params;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getPhaseDetails(CdBabylonService babylon) {
        ArrayList<Detail> details = new ArrayList<Detail>();
        Object object = this.globalLOCK;
        synchronized (object) {
            if (!this.dimsTableInfos.isEmpty() || !this.factsTableInfos.isEmpty()) {
                boolean ongoing;
                boolean bl = ongoing = this.completionDate == null;
                if (ongoing) {
                    IcCubeRequestStatus.getTableProcessingDetailsUX(details, this.dimsTableInfos);
                    IcCubeRequestStatus.getTableProcessingDetailsUX(details, this.factsTableInfos);
                }
            }
        }
        if (details.isEmpty()) {
            return null;
        }
        ArrayList<String> detailS = new ArrayList<String>();
        for (int ii = 0; ii < details.size(); ++ii) {
            Detail detail = (Detail)details.get(ii);
            detailS.add(detail.getName() + ": " + detail.getValue());
        }
        return detailS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelling() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.state.isCancelling();
        }
    }

    public boolean isCancellingX() {
        return this.stateCancelling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return !this.errors.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CdError> getAllErrors() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.errors.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<CdError>(this.errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CdError> getAllErrors(File schemaFactoryFile) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.isAttachedToSchemaFactory(schemaFactoryFile)) {
                return new ArrayList<CdError>(this.errors);
            }
            return new ArrayList<CdError>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CdError> getAllBackupErrors() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.backupErrors.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<CdError>(this.backupErrors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttachedToSchemaFactory(File schemaFactory) {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.schemaFactory != null && this.schemaFactory.equals(schemaFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIncrLoadDeActivated() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.loadSchemaStatus != null && this.loadSchemaStatus.getLoadStatus() == OlapSchemaLoadStatus.INCREMENTAL_LOAD_DEACTIVATED;
        }
    }

    @Nullable
    public String getMdx() {
        if (this.details != null && !this.details.isEmpty()) {
            int detailsSIZE = this.details.size();
            for (int ii = 0; ii < detailsSIZE; ++ii) {
                Detail detail = this.details.get(ii);
                if (!(detail instanceof MdxDetail)) continue;
                MdxDetail mdxDetail = (MdxDetail)detail;
                return mdxDetail.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTimeout() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.timeoutMS != null && this.timeoutMS != -1) {
                long elapsedMS = System.currentTimeMillis() - this.requestStartDate.getTime();
                boolean bl = elapsedMS >= (long)this.timeoutMS.intValue();
                return bl;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(int timeoutS) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.timeoutMS = timeoutS != -1 ? Integer.valueOf(timeoutS * 1000) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeoutKey() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.timeoutMS != null) {
                return String.valueOf(this.timeoutMS);
            }
            return "<null>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(boolean onTimeout, @Nullable String info) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (!this.state.isCancellingOrCompleted()) {
                this.cancelRequestManager.cancelRequest(this.requestUuid);
                this.state = IcCubeRequestState.CANCELLING;
                this.stateCancelling = true;
                this.stateOnTimeout = onTimeout;
                this.stateExtraInfo = info;
                for (Future taskFuture : this.taskFutures) {
                    taskFuture.cancel(true);
                }
            }
        }
    }

    public void cancel(@Nullable String info) {
        this.cancel(false, info);
    }

    public void cancelOnTimeout() {
        this.cancel(true, null);
    }

    public void cancelOnInterruptedException() {
        this.cancel(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestProcessingStarted() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (!this.state.isCancellingOrCompleted()) {
                this.progressInformationTag = "processing";
                this.progressInformationParams = null;
                this.state = IcCubeRequestState.PROCESSING_STARTED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTasksGenerated(List<? extends IcCubeTask> tasks) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.completionFuture.onRequestTasksGenerated(tasks);
            if (!this.state.isCancellingOrCompleted()) {
                this.progressInformationTag = "task(s) generated (" + tasks.size() + ")";
                this.progressInformationParams = null;
                this.state = IcCubeRequestState.PROCESSING_TASKS;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskSubmitted(IcCubeTask task, Future<?> future) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.taskFutures.add(future);
            if (this.state.isCancellingOrCompleted()) {
                future.cancel(true);
            }
            if (!this.state.isCompleted()) {
                this.progressInformationTag = "task submitted";
                this.progressInformationParams = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableReadStarted(boolean facts, String tableName, int partitionCount, Date timestamp) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.state.isCompleted()) {
                return;
            }
            if (!facts) {
                this.dimsTableInfos.put(tableName, new IcCubeTableRequestStatus(tableName, IcCubeTableRequestStatus.Kind.DIMENSION, partitionCount, timestamp));
            } else {
                this.factsTableInfos.put(tableName, new IcCubeTableRequestStatus(tableName, IcCubeTableRequestStatus.Kind.FACTS, partitionCount, timestamp));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionReadStarted(boolean facts, String tableName, String partitionName, Date timestamp) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeTableRequestStatus tableInfo = this.unsafeGetTableInfo(facts, tableName);
            if (tableInfo == null) {
                return;
            }
            tableInfo.onPartitionReadStarted(partitionName, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionReadProgress(boolean facts, String tableName, String partitionName, Date timestamp, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeTableRequestStatus tableInfo = this.unsafeGetTableInfo(facts, tableName);
            if (tableInfo == null) {
                return;
            }
            tableInfo.onPartitionRead(partitionName, timestamp, readRowCount, readRowCountPerSec, processingQueuedTaskCount, processingQueueTaskSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionReadCompleted(boolean facts, String tableName, String partitionName, Date timestamp, long rowCount) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeTableRequestStatus tableInfo = this.unsafeGetTableInfo(facts, tableName);
            if (tableInfo == null) {
                return;
            }
            tableInfo.onPartitionReadCompleted(partitionName, timestamp, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionProcessingCompleted(boolean facts, String tableName, String partitionName, Date timestamp) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeTableRequestStatus tableInfo = this.unsafeGetTableInfo(facts, tableName);
            if (tableInfo == null) {
                return;
            }
            tableInfo.onPartitionProcessingCompleted(partitionName, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableReadCompleted(OlapBuilderContext context, boolean facts, String tableName, Date timestamp, long rowCount) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeTableRequestStatus tableInfo = this.unsafeGetTableInfo(facts, tableName);
            if (tableInfo == null) {
                return;
            }
            tableInfo.onTableReadCompleted(context, timestamp, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableProcessingCompleted(OlapBuilderContext context, boolean facts, String tableName, Date timestamp, long rowCount) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeTableRequestStatus tableInfo = this.unsafeGetTableInfo(facts, tableName);
            if (tableInfo == null) {
                return;
            }
            tableInfo.onTableProcessingCompleted(context, timestamp, rowCount);
        }
    }

    @Nullable
    private IcCubeTableRequestStatus unsafeGetTableInfo(boolean facts, String tableName) {
        if (this.state.isCompleted()) {
            return null;
        }
        IcCubeTableRequestStatus tableInfo = !facts ? this.dimsTableInfos.get(tableName) : this.factsTableInfos.get(tableName);
        return tableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestProgress(String messageTag, Serializable ... params) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (!this.state.isCompleted()) {
                this.progressInformationTag = messageTag;
                this.progressInformationParams = params;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestSchemaResolved(@Nullable String name) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.schema = name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestPrintingJobAdded(String jobUUID) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.printingJob = jobUUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestDetailAdded(String name, String value) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (!this.state.isCompleted()) {
                this.details.add(new Detail(name, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestMdxDetailAdded(String name, String schema, String mdx) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (!this.state.isCompleted()) {
                this.details.add(new MdxDetail(name, schema, mdx));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestSqlDetailAdded(String name, String schema, String jdbcDataSource, String mdx) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (!this.state.isCompleted()) {
                this.details.add(new SqlDetail(name, schema, jdbcDataSource, mdx));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestAttachedToSchemaFactory(File schemaFactory) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.schemaFactory = schemaFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestLoadSchemaStatus(OlapSchemaLifeCycleStatus loadStatus) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.loadSchemaStatus = loadStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestSetupSchedulingException(Exception exception) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.onSetupSchedulingException = true;
            if (exception instanceof ICdException) {
                this.errors.add(((ICdException)exception).getError());
            } else {
                this.errors.add(new OlapError(CdCommonErrorCode.GENERAL_ERROR, new Serializable[]{exception.getMessage()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskException(Exception exception) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.onTaskException = true;
            if (exception instanceof ICdException) {
                this.errors.add(((ICdException)exception).getError());
            } else {
                this.errors.add(new OlapError(CdCommonErrorCode.GENERAL_ERROR, new Serializable[]{exception.getMessage()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestUnexpectedException(Exception exception) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.onUnexpectedException = true;
            if (exception instanceof ICdException) {
                this.errors.add(((ICdException)exception).getError());
            } else {
                this.errors.add(new OlapError(CdCommonErrorCode.GENERAL_ERROR, new Serializable[]{exception.getMessage()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMergeToRequestCompleted(IcCubeRequestStatus mergeToStatus) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.errors.addAll(mergeToStatus.errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestBackupError(CdError error) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.state.isCancellingOrCompleted()) {
                return;
            }
            this.backupErrors.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestErrors(List<? extends CdError> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.state.isCancellingOrCompleted()) {
                return;
            }
            this.errors.addAll(errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskBusy(IcCubeTask task) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.progressInformationTag = "task busy";
            this.progressInformationParams = null;
            this.completionFuture.onRequestTaskBusy(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskDone(IcCubeTask task) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.progressInformationTag = "task done";
            this.progressInformationParams = null;
            this.completionFuture.onRequestTaskDone(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcCubeRequestStateEx onRequestProcessingCompleted(@Nullable IcCubeRequestReply reply) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.taskFutures.clear();
            if (this.state == IcCubeRequestState.CANCELLING) {
                this.errors.clear();
                this.state = IcCubeRequestState.COMPLETED_ON_CANCELLED;
            } else {
                this.state = this.hasErrors() ? IcCubeRequestState.COMPLETED_ON_ERROR : (reply != null && this.requestKind == IcCubeRequestKind.MDX && reply.isMdxOnError() ? IcCubeRequestState.COMPLETED_ON_MDX_ERROR : IcCubeRequestState.COMPLETED);
            }
            this.completionDate = new Date();
            this.progressInformationTag = "completed";
            this.progressInformationParams = null;
            return new IcCubeRequestStateEx(this.state, this.stateOnTimeout, this.stateExtraInfo);
        }
    }

    public void onGviInfo(IcCubeActiveRequestManager.GviInfo gviInfo) {
        this.gviInfo = gviInfo;
    }

    @Nullable
    public IcCubeActiveRequestManager.GviInfo getGviInfo() {
        return this.gviInfo;
    }

    public static class Detail {
        private final String name;
        private final String value;

        public Detail(String name, String value) {
            this.name = name;
            if (value == null) {
                this.value = "";
            } else {
                int maxSize = 32768;
                if (value.length() > 32768) {
                    StringBuilder sb = new StringBuilder(value.substring(0, 32768)).append(" ...");
                    this.value = sb.toString();
                } else {
                    this.value = value;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class MdxDetail
    extends Detail {
        private final String schema;

        public MdxDetail(String name, String schema, String mdx) {
            super(name, mdx);
            this.schema = schema;
        }

        public String getSchema() {
            return this.schema;
        }
    }

    public static class SqlDetail
    extends Detail {
        private final String schema;
        private final String jdbcDataSource;

        public SqlDetail(String name, String schema, String jdbcDataSource, String mdx) {
            super(name, mdx);
            this.schema = schema;
            this.jdbcDataSource = jdbcDataSource;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getJdbcDataSource() {
            return this.jdbcDataSource;
        }
    }
}

