/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.status;

import java.util.Arrays;
import java.util.List;

public enum IcCubeRequestState {
    RECEIVED,
    PROCESSING_STARTED,
    PROCESSING_TASKS,
    CANCELLING,
    COMPLETED_ON_CANCELLED,
    COMPLETED_ON_ERROR,
    COMPLETED_ON_MDX_ERROR,
    COMPLETED;


    public boolean isCancelling() {
        return this == CANCELLING;
    }

    public boolean isCancelled() {
        return this == COMPLETED_ON_CANCELLED;
    }

    public boolean isCompleted() {
        return this == COMPLETED_ON_CANCELLED || this == COMPLETED_ON_ERROR || this == COMPLETED_ON_MDX_ERROR || this == COMPLETED;
    }

    public boolean isCancellingOrCompleted() {
        return this.isCancelling() || this.isCompleted();
    }

    public static List<String> active() {
        return Arrays.asList(RECEIVED.name(), PROCESSING_STARTED.name(), PROCESSING_TASKS.name(), CANCELLING.name());
    }

    public static List<String> completed() {
        return Arrays.asList(COMPLETED_ON_CANCELLED.name(), COMPLETED_ON_ERROR.name(), COMPLETED_ON_MDX_ERROR.name(), COMPLETED.name());
    }
}

