/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.status;

import crazydev.common.exception.CdError;
import crazydev.common.gvi.GviConstants;
import crazydev.iccube.cluster.master.request.M_CancellingRequestManager;
import crazydev.iccube.cluster.master.request.M_TimeoutRequestManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.status.IcCubeRequestState;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class IcCubeActiveRequestManager {
    private final boolean sessionLess;
    private final M_CancellingRequestManager cancelRequestManager;
    private final M_TimeoutRequestManager timeoutRequestManager;
    private final Map<String, IcCubeRequestStatus> allRequestsByClientUUID = new HashMap<String, IcCubeRequestStatus>();
    private final Map<String, Map<String, List<GviInfo>>> gviRequests = new HashMap<String, Map<String, List<GviInfo>>>();

    public IcCubeActiveRequestManager(boolean sessionLess, M_CancellingRequestManager cancelRequestManager, M_TimeoutRequestManager timeoutRequestManager) {
        this.sessionLess = sessionLess;
        this.cancelRequestManager = cancelRequestManager;
        this.timeoutRequestManager = timeoutRequestManager;
    }

    public boolean hasRequestWithTimeout() {
        return this.timeoutRequestManager.hasRequests();
    }

    public int size(@Nullable String excludeUUID) {
        if (excludeUUID == null) {
            return this.allRequestsByClientUUID.size();
        }
        int count = 0;
        for (IcCubeRequestStatus status : this.allRequestsByClientUUID.values()) {
            if (status.getRequestUUID().equals(excludeUUID)) continue;
            ++count;
        }
        return count;
    }

    public Collection<IcCubeRequestStatus> status() {
        return this.allRequestsByClientUUID.values();
    }

    public void cancelAllRequests(BiConsumer<String, IcCubeRequestStatus> action) {
        this.allRequestsByClientUUID.forEach(action);
    }

    public void addRequest(String sessionUUID, String userName, @Nullable OlapTenant userTenant, IcCubeRequest request, @Nullable String printJobUUID) {
        String clientUUID = request.getClientUUID();
        if (this.allRequestsByClientUUID.containsKey(clientUUID)) {
            throw new RuntimeException("internal error: duplicated request UUID [" + clientUUID + "]");
        }
        this.cancelRequestManager.addRequest(request);
        this.timeoutRequestManager.addRequest(request);
        IcCubeRequestStatus status = new IcCubeRequestStatus(this.cancelRequestManager, userName, userTenant, request, IcCubeRequestState.RECEIVED, printJobUUID);
        this.allRequestsByClientUUID.put(clientUUID, status);
        GviInfo gvi = GviInfo.setup(sessionUUID, request);
        if (gvi != null) {
            List<GviInfo> windowRequests;
            status.onGviInfo(gvi);
            Map<String, List<GviInfo>> sessionRequests = this.gviRequests.get(sessionUUID);
            if (sessionRequests == null) {
                sessionRequests = new HashMap<String, List<GviInfo>>();
                this.gviRequests.put(sessionUUID, sessionRequests);
            }
            if ((windowRequests = sessionRequests.get(gvi.windowUid)) == null) {
                windowRequests = new ArrayList<GviInfo>();
                sessionRequests.put(gvi.windowUid, windowRequests);
            }
            windowRequests.add(gvi);
        } else {
            GviInfo gviUX = request.getGviInfo(sessionUUID);
            if (gviUX != null) {
                status.onGviInfo(gviUX);
            }
        }
    }

    @Nullable
    public IcCubeRequestStatus getRequest(String clientUUID) {
        return this.allRequestsByClientUUID.get(clientUUID);
    }

    public List<IcCubeRequestStatus> getDependentRequests(String printingJobUUID) {
        ArrayList<IcCubeRequestStatus> requests = new ArrayList<IcCubeRequestStatus>();
        this.allRequestsByClientUUID.forEach((uuid, status) -> {
            if (printingJobUUID.equals(status.getFromPrintingJob())) {
                requests.add((IcCubeRequestStatus)status);
            }
        });
        return requests;
    }

    public int busyRequestCount(String schema, String clientUUID) {
        int count = 0;
        for (IcCubeRequestStatus status : this.allRequestsByClientUUID.values()) {
            String sSchema = status.getSchema();
            String sUUID = status.getRequestUUID();
            if (sSchema == null || !sSchema.equals(schema) || sUUID.equals(clientUUID) || !status.isBusy()) continue;
            ++count;
        }
        return count;
    }

    public List<IcCubeRequestStatus> busyRequests(String schema, String clientUUID) {
        ArrayList<IcCubeRequestStatus> requests = null;
        for (IcCubeRequestStatus status : this.allRequestsByClientUUID.values()) {
            String sSchema = status.getSchema();
            String sUUID = status.getRequestUUID();
            if (sSchema == null || !sSchema.equals(schema) || sUUID.equals(clientUUID) || !status.isBusy()) continue;
            if (requests == null) {
                requests = new ArrayList<IcCubeRequestStatus>();
            }
            requests.add(status);
        }
        return requests;
    }

    @Nullable
    public List<IcCubeRequestStatus> getGviRequests(String cancelUUID, String sessionUUID, long timestamp, String windowUid, @Nullable String widgetUid) {
        List<GviInfo> windowRequests = this.getGviRequestsForWindowUid(sessionUUID, windowUid);
        if (windowRequests == null) {
            return null;
        }
        ArrayList<String> clientUUIDs = null;
        for (GviInfo request : windowRequests) {
            if (request.clientUUID.equals(cancelUUID) || !request.isAccepted(timestamp, widgetUid)) continue;
            if (clientUUIDs == null) {
                clientUUIDs = new ArrayList<String>();
            }
            clientUUIDs.add(request.clientUUID);
        }
        return this.getRequests(clientUUIDs);
    }

    @Nullable
    public List<IcCubeRequestStatus> getUXWrappedGviRequests(String cancelUUID, String sessionUUID, long timestamp, String windowUid, @Nullable String widgetUid) {
        ArrayList<String> clientUUIDs = null;
        for (IcCubeRequestStatus request : this.allRequestsByClientUUID.values()) {
            GviInfo info = request.getGviInfo();
            if (info == null || info.clientUUID.equals(cancelUUID) || !info.isAccepted(timestamp, widgetUid)) continue;
            if (clientUUIDs == null) {
                clientUUIDs = new ArrayList<String>();
            }
            clientUUIDs.add(info.clientUUID);
        }
        if (clientUUIDs == null || clientUUIDs.isEmpty()) {
            return null;
        }
        List<IcCubeRequestStatus> reqs = this.getRequests((List<String>)clientUUIDs);
        return reqs;
    }

    @Nullable
    public List<IcCubeRequestStatus> getAutoCancelGviRequests(String cancelUUID, String sessionUUID, long timestamp, String windowUid, String widgetUid) {
        List<GviInfo> windowRequests = this.getGviRequestsForWindowUid(sessionUUID, windowUid);
        if (windowRequests == null) {
            return null;
        }
        ArrayList<String> clientUUIDs = null;
        for (GviInfo request : windowRequests) {
            if (request.clientUUID.equals(cancelUUID) || !request.isAutoCancelAccepted(timestamp, widgetUid)) continue;
            if (clientUUIDs == null) {
                clientUUIDs = new ArrayList<String>();
            }
            clientUUIDs.add(request.clientUUID);
        }
        return this.getRequests(clientUUIDs);
    }

    @Nullable
    private List<GviInfo> getGviRequestsForWindowUid(String sessionUUID, String windowUid) {
        if (!this.sessionLess) {
            Map<String, List<GviInfo>> sessionRequests = this.gviRequests.get(sessionUUID);
            if (sessionRequests == null) {
                return null;
            }
            return sessionRequests.get(windowUid);
        }
        ArrayList<GviInfo> allWindowRequests = null;
        for (Map<String, List<GviInfo>> sessionRequests : this.gviRequests.values()) {
            List<GviInfo> windowRequests = sessionRequests.get(windowUid);
            if (windowRequests == null) continue;
            if (allWindowRequests == null) {
                allWindowRequests = new ArrayList<GviInfo>();
            }
            allWindowRequests.addAll(windowRequests);
        }
        return allWindowRequests;
    }

    @Nullable
    private List<IcCubeRequestStatus> getRequests(@Nullable List<String> clientUUIDs) {
        if (clientUUIDs == null) {
            return null;
        }
        ArrayList<IcCubeRequestStatus> requests = null;
        for (String clientUUID : clientUUIDs) {
            IcCubeRequestStatus request = this.allRequestsByClientUUID.get(clientUUID);
            if (request == null) continue;
            if (requests == null) {
                requests = new ArrayList<IcCubeRequestStatus>();
            }
            requests.add(request);
        }
        return requests;
    }

    public void removeRequest(OlapRequestInfo requestInfo, String sessionUUID, String clientUUID) {
        this.cancelRequestManager.removeRequest(clientUUID);
        this.timeoutRequestManager.removeRequest(clientUUID);
        this.allRequestsByClientUUID.remove(clientUUID);
        Map<String, List<GviInfo>> sessionRequests = this.gviRequests.get(sessionUUID);
        if (sessionRequests != null && !sessionRequests.isEmpty()) {
            Collection<List<GviInfo>> windowRequests = sessionRequests.values();
            for (List<GviInfo> requests : windowRequests) {
                ArrayList<GviInfo> toRemove = null;
                for (GviInfo request : requests) {
                    if (!request.clientUUID.equals(clientUUID)) continue;
                    if (toRemove == null) {
                        toRemove = new ArrayList<GviInfo>();
                    }
                    toRemove.add(request);
                }
                if (toRemove == null) continue;
                requests.removeAll(toRemove);
            }
        }
        if (OlapLoggers.REQUEST.isDebugEnabled() && OlapLoggers.isDebugEnabled(requestInfo)) {
            int all = this.allRequestsByClientUUID.size();
            int gvi = this.gviSize();
            OlapLoggers.REQUEST.debug((Object)("[R] active-requests ( ALL:" + all + " GVI:" + gvi + " )"));
        }
    }

    private int gviSize() {
        int size = 0;
        if (!this.gviRequests.isEmpty()) {
            for (Map<String, List<GviInfo>> sessionRequests : this.gviRequests.values()) {
                if (sessionRequests.isEmpty()) continue;
                for (List<GviInfo> windowRequests : sessionRequests.values()) {
                    size += windowRequests.size();
                }
            }
        }
        return size;
    }

    @Nullable
    public String getOneActiveRequestUuid__() {
        if (!this.allRequestsByClientUUID.isEmpty()) {
            return this.allRequestsByClientUUID.keySet().iterator().next();
        }
        return null;
    }

    public List<CdError> getErrorsForSchemaDefFactory(File schemaFactory) {
        ArrayList<CdError> errors = new ArrayList<CdError>();
        for (IcCubeRequestStatus status : this.allRequestsByClientUUID.values()) {
            if (!status.isAttachedToSchemaFactory(schemaFactory)) continue;
            errors.addAll(status.getAllErrors());
        }
        return errors;
    }

    public static class GviInfo {
        final String sessionUUID;
        final String clientUUID;
        final Long timestamp;
        final String windowUid;
        @Nullable
        final String widgetUid;
        final boolean noAutoCancel;

        public GviInfo(String sessionUUID, String clientUUID, Long timestamp, String windowUid, @Nullable String widgetUid, boolean noAutoCancel) {
            this.sessionUUID = sessionUUID;
            this.clientUUID = clientUUID;
            this.timestamp = timestamp;
            this.windowUid = windowUid;
            this.widgetUid = widgetUid;
            this.noAutoCancel = noAutoCancel;
        }

        @Nullable
        static GviInfo setup(String sessionUUID, IcCubeRequest request) {
            Long timestamp = request.getLongProperty(GviConstants.Param.timestamp.name());
            if (timestamp == null) {
                return null;
            }
            String windowUid = request.getProperty(GviConstants.Param.windowUId.name());
            if (windowUid == null) {
                return null;
            }
            String widgetUid = request.getProperty(GviConstants.Param.widgetUId.name());
            Boolean noAutoCancel_ = request.getBooleanProperty(GviConstants.Param.noAutoCancel.name());
            boolean noAutoCancel = noAutoCancel_ != null ? noAutoCancel_ : false;
            return new GviInfo(sessionUUID, request.getClientUUID(), timestamp, windowUid, widgetUid, noAutoCancel);
        }

        public boolean isAccepted(long timestamp, @Nullable String widgetUid) {
            if (this.timestamp < timestamp) {
                if (widgetUid == null) {
                    return true;
                }
                if (this.widgetUid != null && this.widgetUid.equals(widgetUid)) {
                    return true;
                }
            }
            return false;
        }

        public boolean isAutoCancelAccepted(long timestamp, String widgetUid) {
            return !this.noAutoCancel && this.timestamp < timestamp && this.widgetUid != null && this.widgetUid.equals(widgetUid);
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public String getWindowUid() {
            return this.windowUid;
        }

        @Nullable
        public String getWidgetUid() {
            return this.widgetUid;
        }
    }
}

