/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.request;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.request.task.IcCubeTask;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IcCubeRequestCompletionFuture {
    private final Object syncLOCK = new Object();
    @Nullable
    private String[] allTasks;
    private boolean[] completedTasks;
    private boolean busy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Object object = this.syncLOCK;
        synchronized (object) {
            return this.busy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTasksGenerated(List<? extends IcCubeTask> tasks) {
        Object object = this.syncLOCK;
        synchronized (object) {
            if (this.allTasks != null) {
                throw new CdProgrammingException("internal error: request completion inconsistency (1)");
            }
            this.allTasks = new String[tasks.size()];
            this.completedTasks = new boolean[tasks.size()];
            this.busy = false;
            for (int ii = 0; ii < tasks.size(); ++ii) {
                this.allTasks[ii] = tasks.get(ii).getTaskUid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskBusy(IcCubeTask task) {
        Object object = this.syncLOCK;
        synchronized (object) {
            this.busy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestTaskDone(IcCubeTask task) {
        Object object = this.syncLOCK;
        synchronized (object) {
            if (this.allTasks == null) {
                throw new CdProgrammingException("internal error: request completion inconsistency (2)");
            }
            int taskIndex = -1;
            for (int ii = 0; ii < this.allTasks.length; ++ii) {
                if (!task.getTaskUid().equals(this.allTasks[ii])) continue;
                taskIndex = ii;
                break;
            }
            if (taskIndex == -1) {
                throw new CdProgrammingException("internal error: request completion inconsistency : missing task [" + task.getTaskUid() + "] [" + this.completedTasks.length + "]");
            }
            if (this.completedTasks[taskIndex]) {
                throw new CdProgrammingException("internal error: request completion inconsistency : task multiple completion [" + task.getTaskUid() + "] [" + this.completedTasks.length + "]");
            }
            this.completedTasks[taskIndex] = true;
            if (this.isCompleted()) {
                this.syncLOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllTasksCompletion() {
        Object object = this.syncLOCK;
        synchronized (object) {
            if (this.allTasks == null) {
                throw new CdProgrammingException("internal error: request completion inconsistency (3)");
            }
            while (!this.isCompleted()) {
                try {
                    this.syncLOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCompleted() {
        Object object = this.syncLOCK;
        synchronized (object) {
            if (this.completedTasks == null) {
                return false;
            }
            int completedCount = 0;
            for (boolean completedTask : this.completedTasks) {
                if (!completedTask) continue;
                ++completedCount;
            }
            return completedCount == this.completedTasks.length;
        }
    }
}

